/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.GlobalIdUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MergeControlDataUpgradeService
extends BcmUpgradeService {
    private static final Log logger = LogFactory.getLog(MergeControlDataUpgradeService.class);
    DBRoute dbRoute = DBRoute.of((String)"bcm");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> upgrade() {
        if (!DB.exitsTable((DBRoute)this.dbRoute, (String)"t_bcm_mergecontrolentity")) {
            logger.error("t_bcm_mergecontrolentity is not exists, quit");
            return super.upgrade();
        }
        DataSet odsc = DB.queryDataSet((String)"mc_entitycount", (DBRoute)this.dbRoute, (String)"select count(fid) cnt from t_bcm_mergecontrolentity");
        if (odsc == null || odsc.isEmpty() || odsc.next().getInteger("cnt") == 0) {
            logger.error("t_bcm_mergecontrolentity is empty, quit");
            return super.upgrade();
        }
        DataSet ndsc = DB.queryDataSet((String)"mc_count", (DBRoute)this.dbRoute, (String)"select count(fid) cnt from t_bcm_mergecontrol");
        if (ndsc != null && !ndsc.isEmpty() && ndsc.next().getInteger("cnt") > 0) {
            logger.error("t_bcm_mergecontrol is not empty, quit");
            return super.upgrade();
        }
        DataSet modelSet = DB.queryDataSet((String)"mc_model", (DBRoute)this.dbRoute, (String)"select fid,fshownumber from t_bcm_model");
        for (Row row : modelSet) {
            long end;
            Long modelId = row.getLong("fid");
            if (modelId == null || modelId == 0L) {
                logger.error("model is not exist, skip");
                continue;
            }
            String showNumber = row.getString("fshownumber");
            long start = System.currentTimeMillis();
            logger.error("Model {} Start", (Object)showNumber);
            try {
                this.initPeriodStatus(modelId);
                logger.error("upgrade model {} start:", (Object)showNumber);
                DataSet fpSet = DB.queryDataSet((String)"mc_periodSet", (DBRoute)this.dbRoute, (String)"select fscenarioid,fyearid,fperiodid from t_bcm_mergetransferstatus where fmodelid=?", (Object[])new Object[]{modelId});
                for (Row prow : fpSet) {
                    Long scenarioId = prow.getLong("fscenarioid");
                    Long yearId = prow.getLong("fyearid");
                    Long periodId = prow.getLong("fperiodid");
                    ThreadPoolService.runInThread(() -> {
                        String join = Joiner.on((String)"_").join((Object)showNumber, (Object)scenarioId, new Object[]{yearId, periodId});
                        logger.error(join + "_Start");
                        long startPeriod = System.currentTimeMillis();
                        try {
                            this.updateMcData(modelId, scenarioId, yearId, periodId);
                        }
                        catch (Exception e) {
                            try {
                                logger.error("TX {} - {} - {} - {}  Error {}", new Object[]{modelId, scenarioId, yearId, periodId, e});
                            }
                            catch (Throwable throwable) {
                                long endPeriod = System.currentTimeMillis();
                                logger.error(String.format("%s Error End in [%d]s", join, (endPeriod - startPeriod) / 1000L));
                                throw throwable;
                            }
                            long endPeriod = System.currentTimeMillis();
                            logger.error(String.format("%s Error End in [%d]s", join, (endPeriod - startPeriod) / 1000L));
                        }
                        long endPeriod = System.currentTimeMillis();
                        logger.error(String.format("%s Error End in [%d]s", join, (endPeriod - startPeriod) / 1000L));
                    });
                }
            }
            catch (Exception e) {
                try {
                    logger.error(String.format("Model %s Error info:%s", showNumber, e));
                }
                catch (Throwable throwable) {
                    long end2 = System.currentTimeMillis();
                    logger.error(String.format("Model %s End in [%d]s", showNumber, (end2 - start) / 1000L));
                    throw throwable;
                }
                end = System.currentTimeMillis();
                logger.error(String.format("Model %s End in [%d]s", showNumber, (end - start) / 1000L));
                continue;
            }
            end = System.currentTimeMillis();
            logger.error(String.format("Model %s End in [%d]s", showNumber, (end - start) / 1000L));
        }
        return super.upgrade();
    }

    private void initPeriodStatus(long modelId) {
        DataSet exist = DB.queryDataSet((String)"mc_querymodel", (DBRoute)this.dbRoute, (String)"select fid from t_bcm_mergetransferstatus where fmodelid = ?", (Object[])new Object[]{modelId});
        if (exist != null && !exist.isEmpty()) {
            logger.error("modelId[{}] is exist in status, skip", (Object)modelId);
            return;
        }
        HashSet<Long> sceneIds = new HashSet<Long>(16);
        DataSet scSet = DB.queryDataSet((String)"mcupgrade_sceneId", (DBRoute)this.dbRoute, (String)"select fid from t_bcm_structofscene where fmodelid = ?", (Object[])new Object[]{modelId});
        for (Row frow : scSet) {
            sceneIds.add(frow.getLong("fid"));
        }
        HashSet<Long> yearIds = new HashSet<Long>(16);
        DataSet fySet = DB.queryDataSet((String)"mcupgrade_fyearid", (DBRoute)this.dbRoute, (String)"select fid from t_bcm_structoffy where fmodelid = ?", (Object[])new Object[]{modelId});
        for (Row frow : fySet) {
            yearIds.add(frow.getLong("fid"));
        }
        HashSet<Long> periodIds = new HashSet<Long>(16);
        DataSet peSet = DB.queryDataSet((String)"mcupgrade_fperiodid", (DBRoute)this.dbRoute, (String)"select fid from t_bcm_structofperiod where fmodelid = ?", (Object[])new Object[]{modelId});
        for (Row frow : peSet) {
            periodIds.add(frow.getLong("fid"));
        }
        DataSet tSet = DB.queryDataSet((String)"mc_periodSet", (DBRoute)this.dbRoute, (String)"select fscenarioid,fyearid,fperiodid from t_bcm_mergecontrolentity where fmodelid=? group by fscenarioid,fyearid,fperiodid", (Object[])new Object[]{modelId});
        ArrayList<Object[]> statusList = new ArrayList<Object[]>(16);
        for (Row r : tSet) {
            Long scenarioId = r.getLong("fscenarioid");
            Long yearId = r.getLong("fyearid");
            Long periodId = r.getLong("fperiodid");
            if (!sceneIds.contains(scenarioId)) {
                logger.error("scenarioId[{}] is not exist, skip", (Object)scenarioId);
                continue;
            }
            if (!yearIds.contains(yearId)) {
                logger.error("yearId[{}] is not exist, skip", (Object)yearId);
                continue;
            }
            if (!periodIds.contains(periodId)) {
                logger.error("periodId[{}] is not exist, skip", (Object)periodId);
                continue;
            }
            statusList.add(new Object[]{GlobalIdUtil.genGlobalLongId(), modelId, scenarioId, yearId, periodId, "", 0, null, null});
        }
        if (!statusList.isEmpty()) {
            String insertSql = "insert into t_bcm_mergetransferstatus(fid,fmodelid,fscenarioid,fyearid,fperiodid,fstatus,factoruser,fbegintime,fendtime) values(?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)this.dbRoute, (String)insertSql, statusList);
        } else {
            logger.error("modelId[{}] has no valid period data, skip", (Object)modelId);
        }
    }

    public void updateMcData(long modelId, long scenarioId, long yearId, long periodId) {
        Date startDate = TimeServiceHelper.now();
        String sql = "select fid,forgid,fcalculatestatus,fflowstatus,fpccalculatestatus,fpcflowstatus,fbegintime,fendtime from t_bcm_mergecontrolentity where fmodelid=? and fscenarioid=? and fyearid=? and fperiodid=?";
        DataSet mcSet = DB.queryDataSet((String)"mc_set", (DBRoute)this.dbRoute, (String)sql, (Object[])new Object[]{modelId, scenarioId, yearId, periodId});
        String sql2 = "select fid,forgnumber from t_bcm_stagestatus where fmodelid=? and fscenarioid=? and fyearid=? and fperiodid=?";
        DataSet stageSet = DB.queryDataSet((String)"mc_stagestatus", (DBRoute)this.dbRoute, (String)sql2, (Object[])new Object[]{modelId, scenarioId, yearId, periodId});
        LinkedListMultimap stageMap = LinkedListMultimap.create();
        for (Row srow : stageSet) {
            Long stageId = srow.getLong("fid");
            String orgNumber = srow.getString("forgnumber");
            stageMap.put((Object)orgNumber, (Object)stageId);
        }
        String sql3 = "select fid,fmerctlentity,fflowstep,flaststep,fdealuser,foperation,fdealtime,fopinion from t_bcm_dealinfo where fmerctlentity in (select fid from t_bcm_stagestatus where fmodelid=? and fscenarioid=? and fyearid=? and fperiodid=?)";
        DataSet dealSet = DB.queryDataSet((String)"mc_dealinfo", (DBRoute)this.dbRoute, (String)sql3, (Object[])new Object[]{modelId, scenarioId, yearId, periodId});
        LinkedListMultimap dealMap = LinkedListMultimap.create();
        HashMap<String, String> opMap = new HashMap<String, String>();
        opMap.put("A", "C");
        opMap.put("B", "B");
        opMap.put("C", "H");
        opMap.put("D", "A");
        HashMap taskMap = new HashMap(16);
        for (Row drow : dealSet) {
            Long dealId = drow.getLong("fid");
            Long stageId = drow.getLong("fmerctlentity");
            Long stepId = drow.getLong("fflowstep");
            Long lastStepId = drow.getLong("flaststep");
            String action = (String)opMap.get(drow.getString("foperation"));
            if (StringUtils.isEmpty((String)action)) {
                action = "null";
            }
            Long actorId = drow.getLong("fdealuser");
            Date dealTime = drow.getDate("fdealtime");
            String opinion = drow.getString("fopinion");
            Object[] para = new Object[]{dealId, null, stepId, lastStepId, 0, action, actorId, dealTime, opinion, ""};
            dealMap.put((Object)stageId, (Object)para);
        }
        stageMap.asMap().forEach((arg_0, arg_1) -> MergeControlDataUpgradeService.lambda$updateMcData$1((Multimap)dealMap, taskMap, arg_0, arg_1));
        ArrayList taskList = new ArrayList(16);
        LinkedHashMap<String, Object[]> mcMap = new LinkedHashMap<String, Object[]>(16);
        for (Row mrow : mcSet) {
            String flowStatus;
            Long orgId = mrow.getLong("forgid");
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            if (orgNode == IDNumberTreeNode.NotFoundTreeNode) continue;
            String orgNumber = orgNode.getNumber();
            String ecCurrency = orgNode.getCurrency();
            if (ecCurrency == null) {
                logger.error("Org {} ecCurrency is null, skip", (Object)orgNumber);
                continue;
            }
            String pcCurrency = null;
            if (orgNode.getParent() != null) {
                if ("Entity".equals(orgNode.getParent().getNumber())) {
                    logger.error("Org {} parent number is Entity", (Object)orgNumber);
                }
                if ((pcCurrency = orgNode.getParent().getCurrency()) == null) {
                    logger.error("Org {} pcCurrency is null, skip", (Object)orgNumber);
                }
            } else {
                logger.error("Org {} is root", (Object)orgNumber);
            }
            Date beginTime = mrow.getDate("fbegintime");
            Date endTime = mrow.getDate("fendtime");
            if (mcMap.get(orgNumber + "_" + ecCurrency) == null) {
                String flowStatus2;
                Long mcId = mrow.getLong("fid");
                String calculateStatus = mrow.getString("fcalculatestatus");
                if (!this.checkValidStatus(calculateStatus, flowStatus2 = mrow.getString("fflowstatus"))) {
                    logger.error("Org {} - {} status is invalid, skip", (Object)orgNumber, (Object)ecCurrency);
                    continue;
                }
                String archiveStatus = "";
                if ("D".equals(flowStatus2)) {
                    archiveStatus = "D";
                    flowStatus2 = "C";
                }
                Object[] para = new Object[]{mcId, modelId, scenarioId, yearId, periodId, orgNumber, ecCurrency, calculateStatus, flowStatus2, archiveStatus, 0, 0, beginTime, endTime};
                mcMap.put(orgNumber + "_" + ecCurrency, para);
                Collection tasks = (Collection)taskMap.get(orgNumber);
                if (tasks != null) {
                    for (Object[] task : tasks) {
                        task[1] = mcId;
                    }
                    taskList.addAll(tasks);
                }
            }
            if (pcCurrency == null || mcMap.get(orgNumber + "_" + pcCurrency) != null) continue;
            long mcId = GlobalIdUtil.genGlobalLongId();
            String calculateStatus = mrow.getString("fpccalculatestatus");
            if (!this.checkValidStatus(calculateStatus, flowStatus = mrow.getString("fpcflowstatus"))) {
                logger.error("Org {} - {} status is invalid, skip", (Object)orgNumber, (Object)pcCurrency);
                continue;
            }
            if ("D".equals(flowStatus)) {
                flowStatus = "C";
            }
            String archiveStatus = "";
            Object[] para = new Object[]{mcId, modelId, scenarioId, yearId, periodId, orgNumber, pcCurrency, calculateStatus, flowStatus, archiveStatus, 0, 0, beginTime, endTime};
            mcMap.put(orgNumber + "_" + pcCurrency, para);
        }
        try (TXHandle tx = TX.required();){
            try {
                if (!mcMap.isEmpty()) {
                    String insertSql = "insert into t_bcm_mergecontrol(fid,fmodelid,fscenarioid,fyearid,fperiodid,forgnumber,fcurrencynumber,fcalculatestatus,fflowstatus,farchivestatus,fprogressid,fflowtaskid,fbegintime,fendtime) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    DB.executeBatch((DBRoute)this.dbRoute, (String)insertSql, new ArrayList(mcMap.values()));
                    if (!taskList.isEmpty()) {
                        String flowSql = "insert into t_bcm_flowtask(fid,fbizid,fstepid,flaststepid,flasttaskid,faction,factorid,ffinishtime,fopinion,ftraceid) values(?,?,?,?,?,?,?,?,?,?)";
                        DB.executeBatch((DBRoute)this.dbRoute, (String)flowSql, taskList);
                    }
                }
                String updateSql = "update t_bcm_mergetransferstatus set fstatus=?,factoruser=?,fbegintime=?,fendtime=? where fmodelid=? and fscenarioid=? and fyearid=? and fperiodid=?";
                DB.update((DBRoute)this.dbRoute, (String)updateSql, (Object[])new Object[]{"C", UserServiceHelper.getCurrentUserId(), startDate, TimeServiceHelper.now(), modelId, scenarioId, yearId, periodId});
            }
            catch (Throwable e1) {
                tx.markRollback();
                logger.error("TX {} - {} - {} - {}  Error {} Rollback", new Object[]{modelId, scenarioId, yearId, periodId, e1});
                throw e1;
            }
        }
    }

    private boolean checkValidStatus(String calculateStatus, String flowStatus) {
        return "C".equals(flowStatus) || "D".equals(flowStatus) || "C".equals(calculateStatus) || "F".equals(calculateStatus);
    }

    private static /* synthetic */ void lambda$updateMcData$1(Multimap dealMap, Map taskMap, String k, Collection v) {
        for (Long stageId : v) {
            Collection deal = dealMap.get((Object)stageId);
            if (!CollectionUtils.isNotEmpty((Collection)deal)) continue;
            taskMap.put(k, deal);
        }
    }
}

