/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;

public class NewBizRuleUpdateService
extends BcmUpgradeService {
    public Map<String, Object> upgrade(Long modelid) {
        HashMap<Long, Integer> execsortMap = new HashMap<Long, Integer>(20);
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        filter.and("deletestatus", "=", (Object)false);
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"bcm_bizruleentity", (String)"scatalog,catalog,iscommon", (QFilter[])filter.toArray());
        if (rules == null || rules.length == 0) {
            return this.success();
        }
        QFilter processfilter = new QFilter("model", "=", (Object)modelid);
        processfilter.and("isleaf", "=", (Object)true);
        processfilter.and("isbizrule", "=", (Object)true);
        DynamicObject[] processes = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"number", (QFilter[])processfilter.toArray());
        QFilter existsFilter = new QFilter("model", "=", (Object)modelid);
        existsFilter.and("bizrule", "in", Arrays.stream(rules).map(dot -> dot.getLong("id")).collect(Collectors.toList()));
        DynamicObject[] alloprocessed = BusinessDataServiceHelper.load((String)"bcm_bizrulealloprocess", (String)"bizrule,member", (QFilter[])existsFilter.toArray());
        HashMap extisMap = new HashMap(20);
        Arrays.stream(alloprocessed).forEach(dot -> extisMap.put(dot.getString("bizrule.id") + String.valueOf(dot.getLong("member")), Boolean.TRUE));
        HashMap processMap = new HashMap(30);
        Arrays.stream(processes).forEach(p -> processMap.put(p.getString("number"), p.getLong("id")));
        ArrayList<DynamicObject> alloprocess = new ArrayList<DynamicObject>(rules.length);
        ArrayList<DynamicObject> updateRules = new ArrayList<DynamicObject>(rules.length);
        long dimensionid = BizRuleUtil.getProcessDimensionId(modelid);
        for (int i = 0; i < rules.length; ++i) {
            String alloprocessid;
            DynamicObject rule = rules[i];
            String processnumber = rule.getString("catalog.number");
            String catalogNumber = rule.getString("scatalog.number");
            Long ruleid = rule.getLong("id");
            if ("admin".equalsIgnoreCase(catalogNumber)) {
                alloprocessid = "-1";
                if (extisMap.containsKey(String.valueOf(ruleid) + String.valueOf(alloprocessid))) continue;
                this.addAlloProcess(alloprocess, modelid, ruleid, dimensionid, Long.valueOf(alloprocessid), execsortMap);
                rule.set("iscommon", (Object)Boolean.TRUE);
                updateRules.add(rule);
                continue;
            }
            if (StringUtils.isNotEmpty((String)processnumber) && processMap.get(processnumber) != null) {
                Long eirptProcessId;
                Long irptProcessId = (Long)processMap.get("IRpt");
                if (irptProcessId != null && !extisMap.containsKey(String.valueOf(ruleid) + String.valueOf(irptProcessId))) {
                    this.addAlloProcess(alloprocess, modelid, ruleid, dimensionid, irptProcessId, execsortMap);
                }
                if ((eirptProcessId = (Long)processMap.get("EIRpt")) == null || extisMap.containsKey(String.valueOf(ruleid) + String.valueOf(eirptProcessId))) continue;
                this.addAlloProcess(alloprocess, modelid, ruleid, dimensionid, eirptProcessId, execsortMap);
                continue;
            }
            alloprocessid = "-1";
            this.addAlloProcess(alloprocess, modelid, ruleid, dimensionid, Long.valueOf(alloprocessid), execsortMap);
            rule.set("iscommon", (Object)Boolean.TRUE);
            updateRules.add(rule);
        }
        if (!alloprocess.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])alloprocess.toArray(new DynamicObject[0]));
        }
        if (!updateRules.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateRules.toArray(new DynamicObject[0]));
        }
        return this.success();
    }

    private void addAlloProcess(List<DynamicObject> alloprocess, Long modelid, Long ruleid, long dimensionid, Long alloprocessid, Map<Long, Integer> execsortMap) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        qFilter.and("bizrule", "=", (Object)ruleid);
        qFilter.and("dimension", "=", (Object)dimensionid);
        qFilter.and("member", "=", (Object)alloprocessid);
        boolean exist = QueryServiceHelper.exists((String)"bcm_bizrulealloprocess", (QFilter[])qFilter.toArray());
        if (!exist) {
            DynamicObject tempallo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulealloprocess");
            tempallo.set("bizrule", (Object)ruleid);
            tempallo.set("dimension", (Object)dimensionid);
            tempallo.set("member", (Object)alloprocessid);
            tempallo.set("model", (Object)modelid);
            tempallo.set("execsort", (Object)this.getMaxSort(modelid, alloprocessid, execsortMap));
            alloprocess.add(tempallo);
        }
    }

    private int getMaxSort(long modelid, Long processid, Map<Long, Integer> execsortMap) {
        Integer execsort = execsortMap.get(processid);
        if (execsort == null) {
            QFilter filter = new QFilter("member", "=", (Object)processid);
            filter.and("model", "=", (Object)modelid);
            DynamicObject[] result = BusinessDataServiceHelper.load((String)"bcm_bizrulealloprocess", (String)"execsort", (QFilter[])filter.toArray(), (String)"execsort desc", (int)1);
            if (result == null || result.length == 0) {
                execsortMap.put(processid, 1);
                return 1;
            }
            execsortMap.put(processid, result[0].getInt("execsort") + 1);
            return result[0].getInt("execsort") + 1;
        }
        execsortMap.put(processid, execsort + 1);
        return execsort + 1;
    }
}

