/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.util.BCMStringUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;

public class NgmodelUpgradeService
extends BcmUpgradeService {
    private static volatile String APP_SECU = null;

    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.requiresNew();){
            try {
                HashMap<String, Long> existDataSourceMap = new HashMap<String, Long>(16);
                HashSet<String> numberSet = new HashSet<String>(16);
                String sql = "select fid, fnumber, faddress, fdatasource from t_bcm_tdp_datacenter";
                DataSet datacenter = DB.queryDataSet((String)"NgmodelUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)sql);
                while (datacenter.hasNext()) {
                    Row next = datacenter.next();
                    String address = next.getString("faddress");
                    address = BCMStringUtil.deleteEndsStr((String)address);
                    String number = next.getString("fnumber");
                    String datasource = next.getString("fdatasource");
                    Long id = next.getLong("fid");
                    existDataSourceMap.put(address + ";" + datasource, id);
                    numberSet.add(number);
                }
                String accountId = RequestContext.get().getAccountId();
                String sql1 = "select fid, fusertype, fdatasource, fuserurl,ftdpdatacenterid from t_bcm_isngmodel";
                DataSet isngmodel = DB.queryDataSet((String)"NgmodelUpgradeService1", (DBRoute)BCMConstant.DBROUTE, (String)sql1);
                while (isngmodel.hasNext()) {
                    Row next = isngmodel.next();
                    String usertype = next.getString("fusertype");
                    String datasource = next.getString("fdatasource");
                    if ("1".equals(usertype) && accountId.equals(datasource)) continue;
                    String userurl = next.getString("fuserurl");
                    userurl = BCMStringUtil.deleteEndsStr((String)userurl);
                    Long id = next.getLong("fid");
                    String checkStr = userurl + ";" + datasource;
                    Long newNgModelId = (Long)existDataSourceMap.get(checkStr);
                    if (newNgModelId != null) {
                        String sql2 = "update t_bcm_isngmodel set ftdpdatacenterid = " + newNgModelId + " where fid = " + id + ";";
                        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql2);
                        continue;
                    }
                    String ngModelNumber = this.getNgModelInfo(numberSet, 1);
                    Long addId = GlobalIdUtil.genGlobalLongId();
                    StringBuilder sb = new StringBuilder(16);
                    sb.append("insert into t_bcm_tdp_datacenter ");
                    sb.append("(fid,fnumber,fname,faddress,fdatasource,fapptype,fisspemodel,fstatus,fteststatus,fcreatorid,fmodifierid,fdescription,fappid,fpassword)");
                    sb.append(" values ");
                    sb.append("(").append(addId).append(",");
                    sb.append("'").append(ngModelNumber).append("',");
                    sb.append("'").append(ngModelNumber).append("',");
                    sb.append("'").append(userurl).append("',");
                    sb.append("'").append(datasource).append("',");
                    sb.append("'1',");
                    sb.append("'0',");
                    sb.append("'C',");
                    sb.append("'1',");
                    sb.append(1L).append(",");
                    sb.append(1L).append(",");
                    sb.append("'UpgradeService',");
                    sb.append("'bcm_peer',");
                    sb.append("'").append("DataPwd_").append(EncryptUtils.aesEncrypt((String)NgmodelUpgradeService.getThirdAppPassword())).append("')");
                    DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sb.toString());
                    String sql2 = "update t_bcm_isngmodel set ftdpdatacenterid = " + addId + " where fid = " + id + ";";
                    DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql2);
                    numberSet.add(ngModelNumber);
                    existDataSourceMap.put(checkStr, addId);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getThirdAppPassword() {
        if (!Objects.isNull(APP_SECU)) return APP_SECU;
        Class<DimMappingHelper> clazz = DimMappingHelper.class;
        synchronized (DimMappingHelper.class) {
            if (!Objects.isNull(APP_SECU)) return APP_SECU;
            Properties p = new Properties();
            try (InputStream in = OlapServiceHelper.class.getClassLoader().getResourceAsStream("bcm/cm.properties");){
                p.load(in);
                APP_SECU = "V0ahHDEEDE" + p.getProperty("lynt_cyru");
            }
            catch (IOException e) {
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return APP_SECU;
        }
    }

    private String getNgModelInfo(Set<String> numberSet, int seq) {
        String number = "NgModel" + seq;
        if (numberSet.contains(number)) {
            return this.getNgModelInfo(numberSet, ++seq);
        }
        return number;
    }
}

