/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import org.apache.commons.lang3.tuple.Pair;

public class OrgCodeUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        ArrayList orgs = new ArrayList(128);
        String sql = "select fid, fnumber, forgcode from t_bcm_structofent where forgcode != ' ' and fissysmember = 2 and fstoragetype != '3'";
        DBRoute BCM_DB_Router = DBRoute.of((String)"bcm");
        DB.query((DBRoute)BCM_DB_Router, (String)sql, rs -> {
            while (rs.next()) {
                orgs.add(Pair.of((Object)rs.getString("fnumber"), (Object)rs.getString("forgcode")));
            }
            return orgs;
        });
        if (orgs.size() > 0) {
            List orgNums = orgs.stream().map(x -> (String)x.getLeft()).collect(Collectors.toList());
            ArrayList<String> inParams = new ArrayList<String>(10);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < orgNums.size(); ++i) {
                sb.append("'");
                sb.append((String)orgNums.get(i));
                sb.append("'");
                sb.append(",");
                if (i == 0 || i % 998 != 0) continue;
                inParams.add(sb.replace(sb.length() - 1, sb.length(), "").toString());
                sb = new StringBuilder();
            }
            if (sb.length() > 0) {
                inParams.add(sb.replace(sb.length() - 1, sb.length(), "").toString());
            }
            ArrayList baseOrgs = new ArrayList(128);
            for (String string : inParams) {
                String sqlBase = "select fnumber, funiformsocialcreditcode from t_org_org where fnumber in (" + string + ") and funiformsocialcreditcode != ' '";
                DB.query((DBRoute)DBRoute.basedata, (String)sqlBase, rs -> {
                    while (rs.next()) {
                        String uniformCode = rs.getString("funiformsocialcreditcode");
                        if (uniformCode.length() != 18) continue;
                        Pair pair = Pair.of((Object)rs.getString("fnumber"), (Object)uniformCode);
                        baseOrgs.add(pair);
                    }
                    return baseOrgs;
                });
            }
            if (baseOrgs.size() > 0) {
                HashMap<String, String> result = new HashMap<String, String>(128);
                for (Pair baseOrg : baseOrgs) {
                    String orgNum = (String)baseOrg.getLeft();
                    String uniformCode = (String)baseOrg.getRight();
                    String oldOrgCode = uniformCode.substring(uniformCode.length() - 9);
                    String newOrgCode = uniformCode.substring(8, 17);
                    if (!orgs.stream().anyMatch(x -> ((String)x.getLeft()).equals(orgNum) && ((String)x.getRight()).equals(oldOrgCode))) continue;
                    result.put(orgNum, newOrgCode);
                }
                if (result.size() > 0) {
                    String string = "update t_bcm_structofent set forgcode = ? where fnumber = ?";
                    try (TXHandle tx = TX.required((String)"OrgCodeUpgradeService");){
                        try {
                            Iterator iterator = result.entrySet().iterator();
                            ArrayList<String[]> params = new ArrayList<String[]>(128);
                            while (iterator.hasNext()) {
                                Map.Entry next = iterator.next();
                                String[] param = new String[]{(String)next.getValue(), (String)next.getKey()};
                                params.add(param);
                                if (params.size() != 1000) continue;
                                DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)string, params);
                                params.clear();
                            }
                            if (params.size() > 0) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)string, params);
                            }
                        }
                        catch (Exception e) {
                            tx.markRollback();
                        }
                    }
                }
            }
        }
        return super.upgrade();
    }
}

