/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.bcm.business.serviceHelper.UpgradeServiceHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskActitvityPerm;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class PermissionClassAddTaskActPermUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        return this.upgrade(TaskActitvityPerm.PermItemMap);
    }

    public Map<String, Object> upgrade(Map<TaskActivityTypeEnum, Pair<String, String>> permItemMap) {
        WatchLogger logger = BcmLogFactory.getWatchLogInstance(this.getClass());
        logger.info("PermissionClassAddTaskActPermUpgradeService - upgrade");
        for (Map.Entry<TaskActivityTypeEnum, Pair<String, String>> e : permItemMap.entrySet()) {
            Pair<String, String> permItems = e.getValue();
            String oldPageNum = e.getKey().getMenuFormId();
            this.log.startWatch();
            this.doUpgrade(logger, (String)permItems.p1, "bcm_taskactperm", (String)permItems.p2, oldPageNum);
            this.log.infoEnd("PermissionClassAddTaskActPermUpgradeService - upgradebygroup:" + e.getKey().name() + ",groupid=" + TaskActitvityPerm.group.get((Object)e.getKey()));
        }
        return this.success();
    }

    private void doUpgrade(WatchLogger log, String newPermItem, String newPageNum, String oldPermItem, String oldPageNum) {
        try (TXHandle tx = TX.required();){
            try {
                this.doDelete(newPermItem, newPageNum);
                UpgradeServiceHelper.doUpgrade(log, newPermItem, newPageNum, oldPermItem, oldPageNum);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(String.format("PermissionClassAddTaskActPermUpgradeService - upgrade: %s", e.getMessage()));
            }
        }
    }

    private void doDelete(String newPermItem, String newPageNum) {
        String deleteSQLUser = "delete from t_perm_userpermdetail where fentitytypeid = ? and fpermitemid = ?";
        String deleteSQLRole = "delete from t_perm_rolepermdetial where fentitytypeid = ? and fpermitemid = ?";
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteSQLUser, (Object[])new Object[]{newPageNum, newPermItem});
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteSQLRole, (Object[])new Object[]{newPageNum, newPermItem});
    }

    protected Map<TaskActivityTypeEnum, Pair<String, String>> permItemMapByGroup(int groupid) {
        HashMap<TaskActivityTypeEnum, Pair<String, String>> mapByGroup = new HashMap<TaskActivityTypeEnum, Pair<String, String>>(8);
        for (Map.Entry<TaskActivityTypeEnum, Pair<String, String>> e : TaskActitvityPerm.PermItemMap.entrySet()) {
            Integer permGroupId = TaskActitvityPerm.group.get((Object)e.getKey());
            if (null == permGroupId) {
                permGroupId = 1;
            }
            if (groupid != permGroupId) continue;
            mapByGroup.put(e.getKey(), e.getValue());
        }
        return mapByGroup;
    }
}

