/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class PlatformPermUpgradeService
extends AbstractUpgradeService {
    private static String SYMBOL = "###";
    private String fileAddr = ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"PlatformPermUpgradeService_0", (String)"fi-bcm-business", (Object[])new Object[0]);
    private static final int BATCH_UPGRADE_SIZE = 2000;

    public PlatformPermUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    private void upgrade() {
        HashMap<String, Set<String>> addAnyhow = new HashMap<String, Set<String>>();
        HashMap<String, Map<String, Set<String>>> addCondition = new HashMap<String, Map<String, Set<String>>>();
        HashMap<String, String> updateCondition = new HashMap<String, String>();
        HashSet<String> deleteCondition = new HashSet<String>();
        this.getPermItem(addAnyhow, addCondition, updateCondition, deleteCondition);
        ArrayList<String> reportTypeList = new ArrayList<String>();
        reportTypeList.add(ApplicationTypeEnum.CM.getOIndex());
        reportTypeList.add(ApplicationTypeEnum.RPT.getOIndex());
        QFilter appfilter = new QFilter("model.ReportType", "in", reportTypeList);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_modelperm", (String)"model.id,model.reporttype,modelpermentry.eusers", (QFilter[])new QFilter[]{appfilter});
        HashMap userMap = new HashMap();
        HashSet<Long> userSet = new HashSet<Long>();
        if (!doc.isEmpty()) {
            Long userId = 0L;
            for (DynamicObject dynamicObject : doc) {
                Long modelId = dynamicObject.getLong("model.id");
                userId = dynamicObject.getLong("modelpermentry.eusers");
                Integer reporttype = dynamicObject.getInt("model.reporttype");
                if (reporttype == 1) {
                    userSet.add(userId);
                }
                if (userMap.containsKey(modelId)) {
                    ((Set)userMap.get(modelId)).add(userId);
                    continue;
                }
                HashSet<Long> userList = new HashSet<Long>();
                userList.add(userId);
                userMap.put(modelId, userList);
            }
        }
        JSONArray logArry = new JSONArray();
        TXHandle tx = TX.requiresNew();
        Object object = null;
        try {
            try {
                QFilter modelfilter = new QFilter("org", "in", userMap.keySet());
                this.batchUpgradeUser(modelfilter, userSet, addCondition, updateCondition, deleteCondition, logArry);
                this.batchUpgradeRole(modelfilter, addCondition, updateCondition, deleteCondition, logArry);
                this.export(logArry, ResManager.loadKDString((String)"\u91cd\u8981\u5347\u7ea7\u8bb0\u5f55\u8bf7\u4fdd\u5b58.xlsx", (String)"PlatformPermUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public void batchUpgradeRole(QFilter modelFilter, Map<String, Map<String, Set<String>>> addCondition, Map<String, String> updateCondition, Set<String> deleteCondition, JSONArray logArry) {
        QFilter modelTypefilter = new QFilter("dimtype", "=", (Object)"bcm_model");
        DynamicObjectCollection modelList = QueryServiceHelper.query((String)"perm_userrole", (String)"role.id", (QFilter[])new QFilter[]{modelFilter, modelTypefilter});
        if (CollectionUtils.isEmpty((Collection)modelList)) {
            return;
        }
        List roleIds = modelList.stream().map(dy -> dy.getString("role.id")).distinct().collect(Collectors.toList());
        int size = roleIds.size();
        int times = 0;
        int last = 0;
        do {
            last += Math.min(size - last, 2000);
            this.upgradeRole(roleIds.subList(times * 2000, last), addCondition, updateCondition, deleteCondition, logArry);
            ++times;
        } while (size > last);
    }

    private void upgradeRole(List<String> roleIds, Map<String, Map<String, Set<String>>> addCondition, Map<String, String> updateCondition, Set<String> deleteCondition, JSONArray logArry) {
        String selectFileds = "id,roleperm.id,roleperm.entity,roleperm.permitem,roleperm.bizapp,roleperm.controlmode";
        QFilter roleFilter = new QFilter("roleid", "in", roleIds);
        DynamicObject[] modelRoleList = BusinessDataServiceHelper.load((String)"perm_roleperm", (String)selectFileds, (QFilter[])new QFilter[]{roleFilter});
        if (Objects.isNull(modelRoleList) || modelRoleList.length == 0) {
            return;
        }
        ArrayList<DynamicObject> saveRoleList = new ArrayList<DynamicObject>();
        for (DynamicObject dy : modelRoleList) {
            DynamicObjectCollection rolePermEntry = dy.getDynamicObjectCollection("roleperm");
            if (rolePermEntry.isEmpty()) continue;
            JSONArray roleArry = new JSONArray();
            roleArry.add((Object)this.getTypeJsonObj(ResManager.loadKDString((String)"\u89d2\u8272", (String)"PlatformPermUpgradeService_2", (String)"fi-bcm-business", (Object[])new Object[0])));
            roleArry.add((Object)this.getTypeJsonObj(dy.getString("id")));
            Set<String> roleAllPerm = this.getAllPerm(rolePermEntry, "entity.id");
            HashMap<String, Set<String>> totalMap = new HashMap<String, Set<String>>();
            DynamicObjectCollection newRolePermEntry = this.getTotalMap(rolePermEntry, addCondition, updateCondition, deleteCondition, totalMap, roleAllPerm, roleArry, 2);
            this.getFinalEntryentity(totalMap, newRolePermEntry, roleAllPerm, roleArry, 2);
            dy.set("roleperm", (Object)newRolePermEntry);
            saveRoleList.add(dy);
            logArry.add((Object)roleArry);
        }
        if (!saveRoleList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveRoleList.toArray(new DynamicObject[0]));
        }
    }

    public void batchUpgradeUser(QFilter modelFilter, Set<Long> userSet, Map<String, Map<String, Set<String>>> addCondition, Map<String, String> updateCondition, Set<String> deleteCondition, JSONArray logArry) {
        DynamicObjectCollection models = QueryServiceHelper.query((String)"perm_userperm", (String)"id,user.id", (QFilter[])new QFilter[]{modelFilter});
        if (CollectionUtils.isEmpty((Collection)models)) {
            return;
        }
        List permIds = models.stream().filter(dy -> !userSet.contains(dy.getLong("user.id"))).map(dy -> dy.getString("id")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(permIds)) {
            return;
        }
        int size = permIds.size();
        int times = 0;
        int last = 0;
        do {
            last += Math.min(size - last, 2000);
            this.upgradeUser(permIds.subList(times * 2000, last), addCondition, updateCondition, deleteCondition, logArry);
            ++times;
        } while (size > last);
    }

    private void upgradeUser(List<String> permIds, Map<String, Map<String, Set<String>>> addCondition, Map<String, String> updateCondition, Set<String> deleteCondition, JSONArray logArry) {
        String selectFileds = "id,entryentity.id,entryentity.entitytype,entryentity.permitem,entryentity.bizapp,entryentity.controlmode";
        QFilter filter = new QFilter("id", "in", permIds);
        DynamicObject[] permArr = BusinessDataServiceHelper.load((String)"perm_userperm", (String)selectFileds, (QFilter[])new QFilter[]{filter});
        if (Objects.isNull(permArr) || permArr.length == 0) {
            return;
        }
        ArrayList<DynamicObject> saveUserList = new ArrayList<DynamicObject>();
        for (DynamicObject dy : permArr) {
            DynamicObjectCollection userPermEntry = dy.getDynamicObjectCollection("entryentity");
            if (userPermEntry.isEmpty()) continue;
            JSONArray userArry = new JSONArray();
            userArry.add((Object)this.getTypeJsonObj(ResManager.loadKDString((String)"\u4e2a\u4eba", (String)"PlatformPermUpgradeService_3", (String)"fi-bcm-business", (Object[])new Object[0])));
            userArry.add((Object)this.getTypeJsonObj(dy.getString("id")));
            Set<String> userAllPerm = this.getAllPerm(userPermEntry, "entitytype.id");
            HashMap<String, Set<String>> totalMap = new HashMap<String, Set<String>>();
            DynamicObjectCollection newUserPermEntry = this.getTotalMap(userPermEntry, addCondition, updateCondition, deleteCondition, totalMap, userAllPerm, userArry, 1);
            this.getFinalEntryentity(totalMap, newUserPermEntry, userAllPerm, userArry, 1);
            dy.set("entryentity", (Object)newUserPermEntry);
            saveUserList.add(dy);
            logArry.add((Object)userArry);
        }
        if (!saveUserList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveUserList.toArray(new DynamicObject[0]));
        }
    }

    private JSONObject getTypeJsonObj(String type) {
        JSONObject data = new JSONObject();
        data.put("key", (Object)type);
        JSONObject typeObj = new JSONObject();
        typeObj.put("value", (Object)data);
        return typeObj;
    }

    private Set<String> getAllPerm(DynamicObjectCollection rolePermEntry, String entityKey) {
        HashSet<String> roleAllPerm = new HashSet<String>();
        for (DynamicObject dynamicObject : rolePermEntry) {
            String entity = dynamicObject.getString(entityKey);
            String permitem = dynamicObject.getString("permitem.id");
            String bizappId = dynamicObject.getString("bizapp.id");
            String key = bizappId + SYMBOL + entity + SYMBOL + permitem;
            roleAllPerm.add(key);
        }
        return roleAllPerm;
    }

    private void getFinalEntryentity(Map<String, Set<String>> finalMap, DynamicObjectCollection newUserPermEntry, Set<String> userAllPerm, JSONArray userArry, int type) {
        String entitytype = "entitytype";
        if (type == 2) {
            entitytype = "entity";
        }
        JSONArray addArr = new JSONArray();
        JSONObject addkey = new JSONObject();
        addkey.put("key", (Object)addArr);
        JSONObject addValue = new JSONObject();
        addValue.put("value", (Object)addkey);
        userArry.add((Object)addValue);
        for (Map.Entry<String, Set<String>> entry : finalMap.entrySet()) {
            Set<String> pitems = entry.getValue();
            String key = entry.getKey();
            String bizapp = key.split(SYMBOL)[0];
            String entitytypeId = key.split(SYMBOL)[1];
            HashSet<String> newPitems = new HashSet<String>();
            for (String item : pitems) {
                String itemKey = key + SYMBOL + item;
                if (!userAllPerm.add(itemKey)) continue;
                newPitems.add(item);
            }
            for (String permitemId : newPitems) {
                DynamicObject newRow = new DynamicObject(newUserPermEntry.getDynamicObjectType());
                newRow.set(entitytype, (Object)entitytypeId);
                newRow.set("permitem", (Object)permitemId);
                if (type == 1) {
                    newRow.set("controlmode", (Object)"10");
                }
                newRow.set("bizapp", (Object)bizapp);
                newUserPermEntry.add((Object)newRow);
                addArr.add((Object)(key + SYMBOL + permitemId));
            }
        }
    }

    private void getFinalMap(Map<String, Set<String>> finalMap, Map<String, Set<String>> totalMap) {
        for (Map.Entry<String, Set<String>> entry : totalMap.entrySet()) {
            String key = entry.getKey();
            Set<String> value = entry.getValue();
            if (finalMap.containsKey(key)) {
                finalMap.get(key).addAll(value);
                continue;
            }
            HashSet<String> tempSet = new HashSet<String>();
            tempSet.addAll(value);
            finalMap.put(key, tempSet);
        }
    }

    private DynamicObjectCollection getTotalMap(DynamicObjectCollection userPermEntry, Map<String, Map<String, Set<String>>> addCondition, Map<String, String> updateCondition, Set<String> deleteCondition, Map<String, Set<String>> totalMap, Set<String> userAllPerm, JSONArray userArry, int type) {
        DynamicObjectCollection newUserPermEntry = new DynamicObjectCollection();
        JSONArray updateArr = new JSONArray();
        JSONObject updatekey = new JSONObject();
        updatekey.put("key", (Object)updateArr);
        JSONObject updateValue = new JSONObject();
        updateValue.put("value", (Object)updatekey);
        userArry.add((Object)updateValue);
        JSONArray deleteArr = new JSONArray();
        JSONObject deletekey = new JSONObject();
        deletekey.put("key", (Object)deleteArr);
        JSONObject deleteValue = new JSONObject();
        deleteValue.put("value", (Object)deletekey);
        userArry.add((Object)deleteValue);
        String entitytypeId = "entitytype.id";
        String entitytype = "entitytype";
        if (type == 2) {
            entitytypeId = "entity.id";
            entitytype = "entity";
        }
        for (DynamicObject dynamicObject : userPermEntry) {
            String entity = dynamicObject.getString(entitytypeId);
            String permitem = dynamicObject.getString("permitem.id");
            String bizappId = dynamicObject.getString("bizapp.id");
            String key = entity + SYMBOL + permitem;
            if (addCondition.containsKey(key)) {
                this.setTotalMap(totalMap, bizappId, addCondition.get(key));
            }
            if (updateCondition.containsKey(key)) {
                userAllPerm.remove(key);
                String newPerim = updateCondition.get(key);
                if (userAllPerm.contains(newPerim)) {
                    JSONObject deleteObj = new JSONObject();
                    deleteObj.put("entitytypeId", (Object)dynamicObject.getString(entitytypeId));
                    deleteObj.put("permitemId", (Object)dynamicObject.getString("permitem.id"));
                    deleteObj.put("controlmode", (Object)dynamicObject.getString("controlmode"));
                    deleteObj.put("bizappId", (Object)dynamicObject.getString("bizapp.id"));
                    deleteArr.add((Object)deleteObj);
                    continue;
                }
                String[] newPerimArr = newPerim.split(SYMBOL);
                dynamicObject.set(entitytype, (Object)newPerimArr[0]);
                dynamicObject.set("permitem", (Object)newPerimArr[1]);
                JSONObject updateObj = new JSONObject();
                updateObj.put("pre", (Object)key);
                updateObj.put("post", (Object)newPerim);
                updateObj.put("bizappId", (Object)dynamicObject.getString("bizapp.id"));
                updateArr.add((Object)updateObj);
            }
            if (deleteCondition.contains(key)) {
                userAllPerm.remove(key);
                JSONObject deleteObj = new JSONObject();
                deleteObj.put("entitytypeId", (Object)dynamicObject.getString(entitytypeId));
                deleteObj.put("permitemId", (Object)dynamicObject.getString("permitem.id"));
                deleteObj.put("controlmode", (Object)dynamicObject.getString("controlmode"));
                deleteObj.put("bizappId", (Object)dynamicObject.getString("bizapp.id"));
                deleteArr.add((Object)deleteObj);
                continue;
            }
            newUserPermEntry.add((Object)dynamicObject);
        }
        return newUserPermEntry;
    }

    private void setTotalMap(Map<String, Set<String>> totalMap, String bizappId, Map<String, Set<String>> addMap) {
        for (Map.Entry<String, Set<String>> map : addMap.entrySet()) {
            String key = map.getKey();
            Set<String> value = map.getValue();
            String appKey = bizappId + SYMBOL + key;
            if (totalMap.containsKey(appKey)) {
                totalMap.get(appKey).addAll(value);
                continue;
            }
            HashSet<String> newValue = new HashSet<String>();
            newValue.addAll(value);
            totalMap.put(appKey, newValue);
        }
    }

    private void getPermItem(Map<String, Set<String>> addAnyhow, Map<String, Map<String, Set<String>>> addCondition, Map<String, String> updateCondition, Set<String> deleteCondition) {
        String havePerm = ResManager.getLocaleString((String)"\u81ea\u52a8\u6709\u6743", (String)"PlatformPermUpgradeService_4", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String noCondition = ResManager.getLocaleString((String)"\u65e0\u6761\u4ef6", (String)"PlatformPermUpgradeService_5", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String modify = ResManager.getLocaleString((String)"\u4fee\u6539", (String)"PlatformPermUpgradeService_6", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String delete = ResManager.getLocaleString((String)"\u5220\u9664", (String)"PlatformPermUpgradeService_7", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("bcm/permitemlist_930PlatPerm_0908.csv");
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String DELIMITER = ",";
            String line = br.readLine();
            int rowNum = 1;
            while ((line = br.readLine()) != null) {
                String[] columns = line.split(DELIMITER);
                if (columns.length < 5) continue;
                String entity = columns[0];
                String permitem = columns[1];
                String handType = columns[3];
                String handReference = columns[4];
                if (StringUtils.isEmpty((String)handType)) continue;
                if (handType.startsWith(havePerm)) {
                    if (StringUtils.isEmpty((String)handReference)) {
                        throw new KDBizException(rowNum + "line is not standard");
                    }
                    if (noCondition.equals(handReference)) {
                        Set<String> addAnyhowSet = addAnyhow.get(entity);
                        if (addAnyhowSet == null) {
                            addAnyhowSet = new HashSet<String>();
                            addAnyhow.put(entity, addAnyhowSet);
                        }
                        addAnyhowSet.add(permitem);
                    } else {
                        Set<String> addConditionSet;
                        if (!handReference.contains(SYMBOL)) {
                            throw new KDBizException(rowNum + "line is not standard");
                        }
                        Map<String, Set<String>> addConditionMap = addCondition.get(handReference);
                        if (addConditionMap == null) {
                            addConditionMap = new HashMap<String, Set<String>>();
                            addCondition.put(handReference, addConditionMap);
                        }
                        if ((addConditionSet = addConditionMap.get(entity)) == null) {
                            addConditionSet = new HashSet<String>();
                            addConditionMap.put(entity, addConditionSet);
                        }
                        addConditionSet.add(permitem);
                    }
                } else if (handType.startsWith(modify)) {
                    updateCondition.put(handReference, entity + SYMBOL + permitem);
                } else if (handType.startsWith(delete)) {
                    deleteCondition.add(entity + SYMBOL + entity);
                }
                ++rowNum;
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
    }

    private String getCellValue(XSSFCell c) {
        if (c == null) {
            return "";
        }
        return c.getStringCellValue();
    }

    public void export(JSONArray data, String fileName) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(500000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        int rowIndex = 0;
        for (int i = 0; i < data.size(); ++i) {
            JSONArray titles = data.getJSONArray(i);
            if (titles == null) continue;
            ExportWriter.writeLine((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONArray)titles, (int)rowIndex);
            ++rowIndex;
        }
        this.fileAddr = ExportUtil.writeFile(wb, fileName);
    }

    @Override
    void saveData() {
        this.upgrade();
    }

    @Override
    protected void readyUpgradeData() {
    }

    @Override
    public boolean doExcuteUpgrade() {
        boolean isSuccess = super.doExcuteUpgrade();
        if (isSuccess) {
            super.saveExcuteStatus(AbstractUpgradeService.ExcuteEnum.SUCESS, this.fileAddr);
        }
        return isSuccess;
    }
}

