/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.CslSchemeEnum;

public class RateCslSchemeUpgradeService
extends AbstractUpgradeService {
    private static final String ENTITY_RATE_ENTITY = "Entity!RateEntity";

    public RateCslSchemeUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    protected void readyUpgradeData() {
    }

    @Override
    void saveData() {
        HashSet<Long> modelId = new HashSet<Long>(1);
        modelId.add(this.context.getModelId());
        this.doupgrade(modelId);
    }

    public void doupgrade(Set<Long> models) {
        this.checkOlap(models);
        try (TXHandle handle = TX.required();){
            try {
                this.updateRateView(models);
                this.addRateRoot(models);
                this.updateOrgCslscheme(models);
                this.addRateRootToOlap(models);
            }
            catch (Exception e) {
                handle.markRollback();
                throw new RuntimeException(e);
            }
        }
    }

    private void updateRateView(Set<Long> models) {
        QFilter qf = new QFilter("number", "in", (Object)new String[]{"DefaultRateScheme", "root"}).and("model", "in", models);
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,model,number", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> ids = new ArrayList<Long>(models);
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : dyc) {
            if ("DefaultRateScheme".equals(dynamicObject.getString("number"))) {
                ids.remove(dynamicObject.getLong("model"));
                continue;
            }
            if (!"root".equals(dynamicObject.getString("number"))) continue;
            map.put(dynamicObject.getLong("model"), dynamicObject.getLong("id"));
        }
        DynamicObject[] dynamicObjects = new DynamicObject[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_cslscheme");
            obj.set("number", (Object)"DefaultRateScheme");
            obj.set("name", (Object)CslSchemeEnum.DefaultRate.getName());
            obj.set("model", (Object)ids.get(i));
            obj.set("isleaf", (Object)1);
            obj.set("isenable", (Object)CslSchemeEnum.DefaultRate.isIsenable());
            obj.set("nodetype", (Object)CslSchemeEnum.DefaultRate.getNodetype());
            obj.set("level", (Object)CslSchemeEnum.DefaultRate.getLevel());
            obj.set("longnumber", (Object)CslSchemeEnum.DefaultRate.getLongnumber());
            obj.set("islegalorgview", (Object)1);
            obj.set("parent", map.get(ids.get(i)));
            obj.set("creater", (Object)1L);
            obj.set("modifier", (Object)1L);
            obj.set("createdate", (Object)BCMConstant.PRESET_CREATE_TIME);
            obj.set("modifytime", (Object)BCMConstant.PRESET_CREATE_TIME);
            dynamicObjects[i] = obj;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private void addRateRoot(Set<Long> models) {
        QFilter qf = new QFilter("number", "=", (Object)"RateEntity").and("model", "in", models);
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,model", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> ids = new ArrayList<Long>(models);
        for (DynamicObject dynamicObject : dyc) {
            ids.remove(dynamicObject.getLong("model"));
        }
        ArrayList<DynamicObject> dynamicList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < ids.size(); ++i) {
            DynamicObject rateRootMember = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymember");
            DimensionServiceHelper.initDimensionDyObjectWithOrg(rateRootMember);
            rateRootMember.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u6c47\u7387\u6839\u7ec4\u7ec7", (String)"RateCslSchemeUpgradeService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            rateRootMember.set("number", (Object)"RateEntity");
            rateRootMember.set("model", (Object)ids.get(i));
            QFilter qFilter = new QFilter("model", "=", (Object)ids.get(i));
            qFilter.and("number", "=", (Object)"Entity");
            DynamicObject col = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{qFilter});
            rateRootMember.set("dimension", col.get("id"));
            rateRootMember.set("status", (Object)"C");
            rateRootMember.set("enable", (Object)"1");
            rateRootMember.set("createtime", (Object)BCMConstant.PRESET_CREATE_TIME);
            rateRootMember.set("modifytime", (Object)BCMConstant.PRESET_CREATE_TIME);
            rateRootMember.set("creator", (Object)1L);
            rateRootMember.set("modifier", (Object)1L);
            BusinessDataWriter.save((IDataEntityType)rateRootMember.getDynamicObjectType(), (Object[])new Object[]{rateRootMember});
            DynamicObject rateTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
            rateTree.set("status", (Object)"C");
            rateTree.set("enable", (Object)"1");
            rateTree.set("createtime", (Object)BCMConstant.PRESET_CREATE_TIME);
            rateTree.set("modifytime", (Object)BCMConstant.PRESET_CREATE_TIME);
            rateTree.set("model", (Object)ids.get(i));
            rateTree.set("dimension", col.get("id"));
            QFilter filter = new QFilter("model", "=", (Object)ids.get(i)).and("number", "=", (Object)"Entity");
            DynamicObject entity = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"id,name", (QFilter[])new QFilter[]{filter});
            rateTree.set("parent", (Object)entity);
            rateTree.set("level", (Object)2);
            rateTree.set("member", (Object)rateRootMember);
            rateTree.set("storagetype", (Object)"4");
            rateTree.set("isleaf", (Object)false);
            rateTree.set("longnumber", (Object)ENTITY_RATE_ENTITY);
            rateTree.set("number", (Object)"RateEntity");
            rateTree.set("name", (Object)ResManager.loadKDString((String)"\u6c47\u7387\u7ec4\u7ec7", (String)"RateCslSchemeUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            rateTree.set("issysmember", (Object)1);
            rateTree.set("isexchangerate", (Object)true);
            rateTree.set("dseq", (Object)1000);
            rateTree.set("creator", (Object)1L);
            rateTree.set("modifier", (Object)1L);
            dynamicList.add(rateTree);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicList.toArray(new DynamicObject[dynamicList.size()]));
    }

    private void addRateRootToOlap(Set<Long> models) {
        QFilter qf = new QFilter("number", "=", (Object)"RateEntity").and("model", "in", models);
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,model", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> ids = new ArrayList<Long>(models);
        for (DynamicObject dynamicObject : dyc) {
            ids.remove(dynamicObject.getLong("model"));
        }
        for (int i = 0; i < ids.size(); ++i) {
            QFilter qFilter1 = new QFilter("id", "=", (Object)ids.get(i));
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number,name", (QFilter[])new QFilter[]{qFilter1});
            OlapServiceHelper.createMember(model.getString("number"), "Entity", "RateEntity", 5, "Entity");
        }
    }

    private void updateOrgCslscheme(Set<Long> models) {
        QFilter qFilter = new QFilter("model", "in", models);
        QFilter qFilter2 = new QFilter("ISEXCHANGERATE", "=", (Object)String.valueOf(1));
        DynamicObject[] eneitys = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,createtime,cslscheme,model,number,parent,level,longnumber,bizchangerds.bizmodifytime,bizchangerds.bizmodifier,bizchangerds.bizeffdate,bizchangerds.changetype", (QFilter[])new QFilter[]{qFilter, qFilter2});
        HashMap<Long, Long> parentIds = new HashMap<Long, Long>(16);
        for (DynamicObject eneity : eneitys) {
            if (!"RateEntity".equals(eneity.getString("number"))) continue;
            parentIds.put(eneity.getLong("model.id"), eneity.getLong("id"));
        }
        QFilter qf2 = new QFilter("number", "=", (Object)"DefaultRateScheme").and("model", "in", models);
        DynamicObjectCollection cslschemes = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,model", (QFilter[])new QFilter[]{qf2});
        DynamicObjectType entityType = eneitys[0].getDynamicObjectCollection("bizchangerds").getDynamicObjectType();
        for (DynamicObject entity : eneitys) {
            if (parentIds.get(entity.getLong("model.id")) == null) continue;
            if (!"RateEntity".equals(entity.getString("number"))) {
                entity.set("longnumber", (Object)("Entity!RateEntity!" + entity.getString("number")));
                entity.set("parent", parentIds.get(entity.getLong("model.id")));
                entity.set("level", (Object)3);
            }
            for (DynamicObject cslscheme : cslschemes) {
                if (entity.getLong("model.id") != cslscheme.getLong("model")) continue;
                entity.set("cslscheme", (Object)cslscheme.getLong("id"));
            }
            if (entity.getDynamicObjectCollection("bizchangerds").size() >= 1 || "RateEntity".equals(entity.getString("number")) || "RatePreset".equals(entity.getString("number"))) continue;
            DynamicObject tmpData = new DynamicObject(entityType);
            tmpData.set("bizmodifytime", (Object)entity.getDate("createtime"));
            tmpData.set("bizmodifier", (Object)1L);
            tmpData.set("bizeffdate", (Object)entity.getDate("createtime"));
            tmpData.set("changetype", (Object)1);
            entity.getDynamicObjectCollection("bizchangerds").add((Object)tmpData);
        }
        SaveServiceHelper.save((DynamicObject[])eneitys);
    }

    private Set<Long> checkOlap(Set<Long> models) {
        Iterator<Long> iterator = models.iterator();
        while (iterator.hasNext()) {
            Long modelId = iterator.next();
            DynamicObject modelDyn = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number,datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
            if (modelDyn != null && this.checkConnection(modelDyn.getLong("datasource"))) continue;
            iterator.remove();
        }
        return models;
    }

    private boolean checkConnection(long datasourceId) {
        QFilter idFilter = new QFilter("id", "=", (Object)datasourceId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"serveraddress,port,username,password", (QFilter[])new QFilter[]{idFilter});
        if (dyn == null) {
            return false;
        }
        String serveraddress = dyn.getString("serveraddress");
        String port = dyn.getString("port");
        String username = dyn.getString("username");
        String password = dyn.getString("password");
        String conn = "http://" + serveraddress + ":" + port + "/bos-olap-webserver/services/httpolap";
        return OlapServiceHelper.checkIsOnline(conn, username, password);
    }
}

