/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;

public class ReportTempUpgradeService
extends AbstractUpgradeService {
    DynamicObject[] schemeDys;
    DynamicObject[] tempDys;
    List<Long> needAllProids = new ArrayList<Long>();
    List<DynamicObject> allProTemps = new ArrayList<DynamicObject>();

    public ReportTempUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    protected void saveData() {
        if (this.schemeDys != null) {
            SaveServiceHelper.save((DynamicObject[])this.schemeDys);
        }
        if (this.tempDys != null) {
            SaveServiceHelper.save((DynamicObject[])this.tempDys);
        }
        if (!this.allProTemps.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.allProTemps.toArray(new DynamicObject[0]));
        }
    }

    @Override
    protected void readyUpgradeData() {
        DynamicObject[] schemes;
        QFilter bpFilter = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"Rpt", "IRpt", "RAdj", "ERpt", "EIRpt", "ERAdj", "SRPT", "CS", "PC"}));
        DynamicObjectCollection bps = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,dimension.id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.context.getModelId()), bpFilter});
        HashMap<String, DynamicObject> num2bp = new HashMap<String, DynamicObject>(2);
        long dim_bpid = 0L;
        for (DynamicObject bp : bps) {
            dim_bpid = bp.getLong("dimension.id");
            num2bp.put(bp.getString("number"), bp);
        }
        Long bp_csid = this.context.getDel_bps().containsKey("CS") ? this.context.getDel_bps().get("CS") : Long.valueOf(0L);
        Long bp_pcid = this.context.getDel_bps().containsKey("PC") ? this.context.getDel_bps().get("PC") : Long.valueOf(0L);
        Long bp_irptid = this.context.getDel_bps().containsKey("IRpt") ? this.context.getDel_bps().get("IRpt") : Long.valueOf(0L);
        Long bp_sirptid = this.context.getDel_bps().containsKey("SIRPT") ? this.context.getDel_bps().get("SIRPT") : Long.valueOf(0L);
        for (DynamicObject scheme : schemes = BusinessDataServiceHelper.load((String)"bcm_reportdata_custseting", (String)"detail.dimension,detail.dimensionmember", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.context.getModelId())})) {
            for (DynamicObject d : scheme.getDynamicObjectCollection("detail")) {
                if (d.getLong("dimension.id") != dim_bpid) continue;
                if (d.getLong("dimensionmember") == bp_csid.longValue() && num2bp.get("IRpt") != null) {
                    d.set("dimensionmember", (Object)((DynamicObject)num2bp.get("IRpt")).getString("id"));
                    continue;
                }
                if (d.getLong("dimensionmember") != bp_sirptid.longValue() || num2bp.get("SRPT") == null) continue;
                d.set("dimensionmember", (Object)((DynamicObject)num2bp.get("SRPT")).getString("id"));
            }
        }
        this.schemeDys = schemes;
        DynamicObject[] temps = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)"viewpointmembentry.viewmembid,pagemembentry.pagemembid,pagemembentry.pagedimension,pagemembentry.membbound,pagemembentry.seq,viewpointmembentry.viewdimension,pagemembentry.pagedimension,pagepropentry.pagepropdim", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.context.getModelId())});
        Predicate<Object> isNull = o -> o == null;
        for (DynamicObject temp : temps) {
            for (DynamicObject d : temp.getDynamicObjectCollection("viewpointmembentry")) {
                if (d.getLong("viewmembid") != bp_csid.longValue() && d.getLong("viewmembid") != bp_pcid.longValue() && d.getLong("viewmembid") != bp_irptid.longValue()) continue;
                d.set("viewmembid", num2bp.get("EIRpt"));
            }
            DynamicObjectCollection pagemembentry = temp.getDynamicObjectCollection("pagemembentry");
            if (pagemembentry != null && pagemembentry.size() > 0) {
                DynamicObjectCollection dc = new DynamicObjectCollection();
                for (DynamicObject d : pagemembentry) {
                    if (dim_bpid == d.getLong("pagedimension.id") && (d.getLong("pagemembid") == bp_csid.longValue() || d.getLong("pagemembid") == bp_pcid.longValue() || d.getLong("pagemembid") == bp_irptid.longValue())) {
                        this.initPageMember(isNull, (DynamicObject)num2bp.get("Rpt"), d, dc);
                        this.initPageMember(isNull, (DynamicObject)num2bp.get("IRpt"), d, dc);
                        this.initPageMember(isNull, (DynamicObject)num2bp.get("RAdj"), d, dc);
                        this.initPageMember(isNull, (DynamicObject)num2bp.get("ERpt"), d, dc);
                        this.initPageMember(isNull, (DynamicObject)num2bp.get("EIRpt"), d, dc);
                        this.initPageMember(isNull, (DynamicObject)num2bp.get("ERAdj"), d, dc);
                        continue;
                    }
                    dc.add((Object)d);
                }
                temp.set("pagemembentry", (Object)dc);
            }
            this.collectNeedAllProTemp(temp);
        }
        this.tempDys = temps;
        if (!this.needAllProids.isEmpty()) {
            DynamicObject[] apTemps;
            for (DynamicObject temp : apTemps = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_templateentity").getAllFields().keySet()), (QFilter[])new QFilter[]{new QFilter("id", "in", this.needAllProids)})) {
                this.upgradeColAndRow(temp);
            }
        }
    }

    public void initPageMember(Predicate<Object> isNull, DynamicObject bpDy, DynamicObject sourceDy, DynamicObjectCollection dc) {
        if (!isNull.test(bpDy)) {
            for (DynamicObject bp : dc) {
                if (bp.getLong("pagemembid") != bpDy.getLong("id")) continue;
                return;
            }
            DynamicObject pageMember = (DynamicObject)OrmUtils.clone((IDataEntityBase)sourceDy, (boolean)false, (boolean)true);
            pageMember.set("pagemembid", (Object)bpDy.getLong("id"));
            pageMember.set("membbound", (Object)RangeEnum.VALUE_10.getValue());
            dc.add((Object)pageMember);
        }
    }

    private void collectNeedAllProTemp(DynamicObject temp) {
        HashSet dims = new HashSet();
        temp.getDynamicObjectCollection("viewpointmembentry").forEach(v -> dims.add(v.getString("viewdimension.number")));
        temp.getDynamicObjectCollection("pagepropentry").forEach(v -> dims.add(v.getString("pagepropdim.number")));
        temp.getDynamicObjectCollection("pagemembentry").forEach(v -> dims.add(v.getString("pagedimension.number")));
        if (dims.contains(DimTypesEnum.CURRENCY.getNumber()) && dims.contains(DimTypesEnum.PROCESS.getNumber())) {
            return;
        }
        this.needAllProids.add(temp.getLong("id"));
    }

    private void upgradeColAndRow(DynamicObject temp) {
        int update = 0;
        DynamicObjectCollection areas = temp.getDynamicObjectCollection("areapositionentry");
        if (areas != null && !areas.isEmpty()) {
            for (DynamicObject area : areas) {
                if (this.upgradeDetail(area.getDynamicObjectCollection("rowmembdetail"), true)) {
                    ++update;
                }
                if (!this.upgradeDetail(area.getDynamicObjectCollection("colmembdetail"), false)) continue;
                ++update;
            }
        }
        if (update > 0) {
            this.upgradeData(temp);
            this.allProTemps.add(temp);
        }
    }

    private boolean upgradeDetail(DynamicObjectCollection details, boolean isRow) {
        boolean upgrade = false;
        if (details == null || details.isEmpty()) {
            return upgrade;
        }
        for (DynamicObject detail : details) {
            String dimNum = detail.getString((isRow ? "rowdimension" : "coldimension") + ".number");
            if (!DimTypesEnum.CURRENCY.getNumber().equals(dimNum) && !DimTypesEnum.PROCESS.getNumber().equals(dimNum)) continue;
            long id = detail.getLong(isRow ? "rowmembid" : "colmembid");
            IDNumberTreeNode member = MemberReader.findMemberById((long)this.context.getModelId(), (String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (Long)id);
            if ((member = this.getReplaceMember(dimNum, member)) == null) continue;
            detail.set(isRow ? "rowmembid" : "colmembid", (Object)member.getId());
            upgrade = true;
        }
        return upgrade;
    }

    private IDNumberTreeNode getReplaceMember(String dimNum, IDNumberTreeNode member) {
        if (DimTypesEnum.CURRENCY.getNumber().equals(dimNum)) {
            if ("PC".equals(member.getNumber())) {
                return MemberReader.findCurrencyMemberByNum((String)this.context.getCube(), (String)"DC");
            }
        } else if (DimTypesEnum.PROCESS.getNumber().equals(dimNum)) {
            if ("CS".equals(member.getNumber()) || IDNumberTreeNode.NotFoundTreeNode == member) {
                return MemberReader.findProcessMemberByNum((String)this.context.getCube(), (String)"EIRpt");
            }
            if ("SIRPT".equalsIgnoreCase(member.getNumber())) {
                return MemberReader.findProcessMemberByNum((String)this.context.getCube(), (String)"SRPT");
            }
        }
        return null;
    }

    private void upgradeData(DynamicObject temp) {
        String data = temp.getString("data");
        String rptdata = temp.getString("rptdata");
        temp.set("data", (Object)this.upgradeSpread(data));
        temp.set("rptdata", (Object)this.upgradeSpread(rptdata));
    }

    private String upgradeSpread(String data) {
        try {
            Class<?> clazz = Class.forName("kd.fi.bcm.spread.util.TemplateUpgradeUtil");
            Method upgradeSpread = clazz.getMethod("upgradeSpread", String.class);
            return (String)upgradeSpread.invoke(null, data);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

