/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.serviceHelper.UpgradeServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;

public class RptCslSchemeUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        this.doUpgrade();
        return this.success();
    }

    public void doUpgrade() {
        QFilter qf = new QFilter("reporttype", "in", (Object)new String[]{ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex()});
        DynamicObjectCollection models = QueryServiceHelper.query((String)"bcm_model", (String)"id", (QFilter[])qf.toArray());
        try (TXHandle tx = TX.required();){
            try {
                for (DynamicObject model : models) {
                    long modelId = model.getLong("id");
                    Long rptDefaultSchemeId = CslSchemeServiceHelper.getRptDefaultSchemeId(modelId);
                    if (rptDefaultSchemeId != 0L) continue;
                    long rootId = UpgradeServiceHelper.createRoot(modelId);
                    Long id = DBServiceHelper.genGlobalLongId();
                    DynamicObject defaultScheme = UpgradeServiceHelper.buildSingleScheme(modelId, rootId, id, "DefaultScheme");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{defaultScheme});
                    DB.execute((DBRoute)new DBRoute("bcm"), (String)("update t_bcm_structofent set fschemeid = " + id + " where fmodelid = " + modelId + " and fisexchangerate = " + 0));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }
}

