/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;

public class RptOlapOrgUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        HashMap orgId2NumMap = new HashMap();
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)BCMConstant.DBROUTE, (String)"select fid,fnumber from t_bcm_structofent");){
            ds.forEachRemaining(entry -> orgId2NumMap.put(entry.getLong("fid"), entry.getString("fnumber")));
        }
        HashMap olaporgUpMap = new HashMap();
        HashMap adjHead2MergeMap = new HashMap();
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)BCMConstant.DBROUTE, (String)"select entry.fid  entryId,entry.fmergeid  newmergeid,entry.folaporg  folaporg, entity.flongnumber  orglongnum,entity.fnumber  orgnum,process.fnumber  proNum,adjust.fentity  oldmergeId  from t_bcm_rptadjustdata entry  join t_bcm_rptadjust adjust on adjust.fid = entry.fadjustid  join t_bcm_structofent entity on entity.fid = entry.forgid  join t_bcm_structofprocess process on process.fid = entry.fprocessid  where entry.fisdefaultcurrency = '1' ");){
            int olapOrgIndex = ds.getRowMeta().getFieldIndex("folaporg");
            int orgLongNumIndex = ds.getRowMeta().getFieldIndex("orglongnum");
            int processNumIndex = ds.getRowMeta().getFieldIndex("proNum");
            int entityNumIndex = ds.getRowMeta().getFieldIndex("orgnum");
            int pkIdIndex = ds.getRowMeta().getFieldIndex("entryId");
            int mergeIdIndex = ds.getRowMeta().getFieldIndex("newmergeid");
            int oldMergeIdIndex = ds.getRowMeta().getFieldIndex("oldmergeId");
            ds.forEachRemaining(entry -> {
                long mergeId;
                String oldOlapOrg = entry.getString(olapOrgIndex);
                String newOlapOrg = null;
                if (OrgRelaProcessMembPool.isRelaProcess((String)entry.getString(processNumIndex))) {
                    String mergeNum = (String)orgId2NumMap.get(entry.getLong(oldMergeIdIndex));
                    newOlapOrg = AdjustCheckServiceHelper.getParentDirectChild(mergeNum, entry.getString(orgLongNumIndex));
                } else {
                    newOlapOrg = entry.getString(entityNumIndex);
                }
                if (StringUtils.isNotEmpty((String)newOlapOrg) && (StringUtils.isEmpty((String)oldOlapOrg) || !oldOlapOrg.equals(newOlapOrg))) {
                    olaporgUpMap.put(entry.getLong(pkIdIndex), newOlapOrg);
                }
                if ((mergeId = entry.getLong(mergeIdIndex).longValue()) == 0L) {
                    adjHead2MergeMap.put(entry.getLong(pkIdIndex), entry.getLong(oldMergeIdIndex));
                }
            });
        }
        PlatUtil.executeWithTX(tx -> {
            AdjustCheckServiceHelper.updateEntriesOlapOrg(olaporgUpMap);
            AdjustCheckServiceHelper.updateEntriesMergeId(adjHead2MergeMap);
        });
        return super.upgrade();
    }
}

