/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntryExt;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.upgrade.ConfigUpgradeService;
import kd.fi.bcm.common.enums.LinkageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;

public class RptadjustUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgradeBefore() {
        return this.doUpdate();
    }

    private Map<String, Object> doUpdate() {
        this.queryBcmModel().stream().forEach(e -> {
            QFilter qf = new QFilter("model", "=", e.p1).and("number", "in", (Object)new String[]{"CS", "IRpt"});
            DynamicObjectCollection processes = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id, number", (QFilter[])qf.toArray());
            long csId = 0L;
            long irptId = 0L;
            for (DynamicObject dy : processes) {
                if ("CS".equals(dy.getString("number"))) {
                    csId = dy.getLong("id");
                    continue;
                }
                if (!"IRpt".equals(dy.getString("number"))) continue;
                irptId = dy.getLong("id");
            }
            QFilter filter = new QFilter("model", "=", e.p1);
            QFilter qFilter = new QFilter("process", "=", (Object)csId);
            DynamicObject[] adjuctProcess = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)"id,process", (QFilter[])new QFilter[]{filter, qFilter});
            if (adjuctProcess.length != 0 && csId != 0L) {
                ArrayList<Long> ids = new ArrayList<Long>(10);
                for (DynamicObject process : adjuctProcess) {
                    ids.add(process.getLong("id"));
                }
                ArrayList<Object[]> param = new ArrayList<Object[]>(10);
                for (Long id : ids) {
                    ArrayList<Long> ob = new ArrayList<Long>();
                    ob.add(irptId);
                    ob.add(id);
                    param.add(ob.toArray());
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)"update t_bcm_rptadjustdata set fprocessid=? where fid =?", param);
            }
            if (irptId != 0L && csId != 0L) {
                DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)"UPDATE t_bcm_rptadjustcomdim SET FMEMBERID = ? WHERE FMEMBERID = ?", (Object[])new Object[]{irptId, csId});
            }
        });
        String param = ResManager.getLocaleString((String)"IRpt\u62a5\u8868", (String)"RptadjustUpgradeService_0", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String sql = "UPDATE T_BCM_RPTADJUST SET FPROCESS = 'IRpt',FBUSSNESSTYPE = 'RPTADJUSTSELF',FNAME =? WHERE FPROCESS = 'CS'";
        DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{param});
        return this.success();
    }

    @Override
    public Map<String, Object> upgrade() {
        Set<Long> modelSet = this.queryBcmModel().stream().map(model -> (Long)model.p1).collect(Collectors.toSet());
        if (modelSet != null && !modelSet.isEmpty()) {
            this.upgradeLinkSource(modelSet);
            this.upgradeCM005();
            this.upgradeReportAdjustProcess(modelSet);
            this.upgradeRptAdjustQueryScheme(modelSet);
            this.updateWorkPaper(modelSet);
        }
        return this.success();
    }

    private void updateWorkPaper(Set<Long> modelSet) {
        DynamicObject[] workDys = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_templateentity").getAllFields().keySet()), (QFilter[])new QFilter("model", "in", modelSet).and("templatetype", "=", (Object)TemplateTypeEnum.MSN.getType()).toArray());
        Map<Long, List<DynamicObject>> workMaps = Arrays.stream(workDys).collect(Collectors.groupingBy(work -> work.getLong("model.id")));
        HashBasedTable processTable = HashBasedTable.create();
        DynamicObject[] processDys = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,name,number,model", (QFilter[])new QFilter("model", "in", modelSet).and("number", "in", (Object)new String[]{"SADJ", "CADJ", "SCCADJ", "DADJ", "ADJT", "SEJE", "DEJE", "EJET"}).toArray());
        Arrays.stream(processDys).forEach(arg_0 -> RptadjustUpgradeService.lambda$updateWorkPaper$3((Table)processTable, arg_0));
        HashMap atMap = new HashMap(16);
        DynamicObject[] atDys = BusinessDataServiceHelper.load((String)"bcm_audittrialmembertree", (String)"id,name,number,model", (QFilter[])new QFilter("model", "in", modelSet).and("number", "=", (Object)"ADJE").toArray());
        Arrays.stream(atDys).forEach(atDy -> atMap.put(atDy.getLong("model.id"), atDy));
        HashMap currencyMap = new HashMap(16);
        DynamicObject[] currDys = BusinessDataServiceHelper.load((String)"bcm_audittrialmembertree", (String)"id,name,number,model", (QFilter[])new QFilter("model", "in", modelSet).and("number", "=", (Object)"ADJE").toArray());
        Arrays.stream(currDys).forEach(currDy -> currencyMap.put(currDy.getLong("model.id"), currDy));
        ArrayList uppdateDys = new ArrayList(10);
        workMaps.forEach((arg_0, arg_1) -> this.lambda$updateWorkPaper$6((Table)processTable, atMap, currencyMap, uppdateDys, arg_0, arg_1));
        if (!uppdateDys.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])uppdateDys.toArray(new DynamicObject[uppdateDys.size()]));
        }
    }

    private void setColDimensionEntryExt(AreaRangeEntry areaEntry, String header, int startColIdx, boolean displayChild, DynamicObject processs, DynamicObject auditTrail, DynamicObject currency) {
        ColDimensionEntryExt colDimensionEntryExt = new ColDimensionEntryExt(areaEntry);
        colDimensionEntryExt.setHeader(header);
        colDimensionEntryExt.setIndex(startColIdx);
        colDimensionEntryExt.setDisplayChild(displayChild);
        areaEntry.addColDimEntryExt(colDimensionEntryExt);
    }

    private void upgradeLinkSource(Set<Long> modelSet) {
        Collection linkDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_linkagemapping", (String)"model,entryentity.linkagetype,entryentity.audittrial,entryentity.audittrialrange", (QFilter[])new QFilter("model", "in", modelSet).toArray()).values();
        HashBasedTable audittrialTable = HashBasedTable.create();
        BusinessDataServiceHelper.loadFromCache((String)"bcm_audittrialmembertree", (String)"number,model", (QFilter[])new QFilter("model", "in", modelSet).and("number", "in", (Object)new String[]{"LinkageJournal", "ATTotal"}).toArray()).values().forEach(arg_0 -> RptadjustUpgradeService.lambda$upgradeLinkSource$7((Table)audittrialTable, arg_0));
        if (linkDys.size() > 0) {
            linkDys.forEach(arg_0 -> RptadjustUpgradeService.lambda$upgradeLinkSource$9((Table)audittrialTable, arg_0));
            SaveServiceHelper.update((DynamicObject[])linkDys.toArray(new DynamicObject[linkDys.size()]));
        }
    }

    private void upgradeCM005() {
        new ConfigUpgradeService().upgradeBefore();
        DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)"UPDATE t_bcm_adjbiztypecfgentry SET fisshow = '0' WHERE fbusinesstypevalue = 'ADJUSTCROSSLEVEL'");
    }

    private void upgradeReportAdjustProcess(Set<Long> modelSet) {
    }

    private void upgradeRptAdjustQueryScheme(Set<Long> modelSet) {
        Collection queryDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_rptadjustqueryplan", (String)"model,commembentry.comdimension,commembentry.commembid", (QFilter[])new QFilter("model", "in", modelSet).toArray()).values();
        HashBasedTable processTable = HashBasedTable.create();
        BusinessDataServiceHelper.loadFromCache((String)"bcm_processmembertree", (String)"number,model", (QFilter[])new QFilter("model", "in", modelSet).and("number", "in", (Object)new String[]{"IRpt", "CS"}).toArray()).values().forEach(arg_0 -> RptadjustUpgradeService.lambda$upgradeRptAdjustQueryScheme$10((Table)processTable, arg_0));
        if (queryDys.size() > 0) {
            queryDys.forEach(arg_0 -> RptadjustUpgradeService.lambda$upgradeRptAdjustQueryScheme$12((Table)processTable, arg_0));
            SaveServiceHelper.update((DynamicObject[])queryDys.toArray(new DynamicObject[queryDys.size()]));
        }
    }

    private static /* synthetic */ void lambda$upgradeRptAdjustQueryScheme$12(Table processTable, DynamicObject queryDy) {
        long modelid = queryDy.getLong("model.id");
        long irptid = (Long)processTable.get((Object)modelid, (Object)"IRpt");
        queryDy.getDynamicObjectCollection("entryentity").forEach(queryChildDy -> {
            if ("Process".equals(queryChildDy.getDynamicObject("comdimension").getString("number")) && queryChildDy.get("commembid") != null && queryChildDy.getLong("commembid") != 0L && irptid == queryChildDy.getLong("commembid")) {
                queryChildDy.set("commembid", processTable.get((Object)modelid, (Object)"CS"));
            }
        });
    }

    private static /* synthetic */ void lambda$upgradeRptAdjustQueryScheme$10(Table processTable, DynamicObject processDy) {
        Long cfr_ignored_0 = (Long)processTable.put((Object)processDy.getLong("model.id"), (Object)processDy.getString("number"), (Object)processDy.getLong("id"));
    }

    private static /* synthetic */ void lambda$upgradeLinkSource$9(Table audittrialTable, DynamicObject linkDy) {
        long modelid = linkDy.getLong("model.id");
        linkDy.getDynamicObjectCollection("entryentity").forEach(linkChildDy -> {
            if (LinkageTypeEnum.SOURCE.getIndex().equals(linkChildDy.getString("linkagetype"))) {
                linkChildDy.set("audittrial", audittrialTable.get((Object)modelid, (Object)"LinkageJournal"));
                linkChildDy.set("audittrialrange", (Object)"10");
            } else {
                linkChildDy.set("audittrial", audittrialTable.get((Object)modelid, (Object)"ATTotal"));
                linkChildDy.set("audittrialrange", (Object)"90");
            }
        });
    }

    private static /* synthetic */ void lambda$upgradeLinkSource$7(Table audittrialTable, DynamicObject audittrialDy) {
        DynamicObject cfr_ignored_0 = (DynamicObject)audittrialTable.put((Object)audittrialDy.getLong("model.id"), (Object)audittrialDy.getString("number"), (Object)audittrialDy);
    }

    private /* synthetic */ void lambda$updateWorkPaper$6(Table processTable, Map atMap, Map currencyMap, List uppdateDys, Long model, List workList) {
        for (DynamicObject dyna : workList) {
            TemplateModel tmp = new TemplateModel();
            tmp.loadDynaObj2Model(dyna);
            tmp.setSpreadJson(null);
            tmp.setRptData(null);
            AreaRangeEntry oldArea = tmp.getAreaRangeEntries().get(0);
            tmp.getAreaRangeEntries().clear();
            AreaRangeEntry areaEntry = new AreaRangeEntry(tmp);
            areaEntry.setAreaRange("C2:H2");
            areaEntry.setStartPosition("C2");
            areaEntry.getRowDimEntries().addAll(oldArea.getRowDimEntries());
            int startColIdx = ExcelUtils.pos2XY((String)areaEntry.getStartPosition())[0];
            this.setColDimensionEntryExt(areaEntry, ResManager.loadKDString((String)"\u5408\u5e76\u8c03\u6574\u660e\u7ec6", (String)"RptadjustUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0]), startColIdx++, true, (DynamicObject)processTable.get((Object)model, (Object)"SADJ"), (DynamicObject)atMap.get(model), (DynamicObject)currencyMap.get(model));
            this.setColDimensionEntryExt(areaEntry, ResManager.loadKDString((String)"\u5408\u5e76\u5c42\u8c03\u6574", (String)"RptadjustUpgradeService_2", (String)"fi-bcm-business", (Object[])new Object[0]), startColIdx++, false, (DynamicObject)processTable.get((Object)model, (Object)"CADJ"), (DynamicObject)atMap.get(model), (DynamicObject)currencyMap.get(model));
            this.setColDimensionEntryExt(areaEntry, ResManager.loadKDString((String)"\u5408\u5e76\u8d21\u732e\u8c03\u6574", (String)"RptadjustUpgradeService_3", (String)"fi-bcm-business", (Object[])new Object[0]), startColIdx++, false, (DynamicObject)processTable.get((Object)model, (Object)"SCCADJ"), (DynamicObject)atMap.get(model), (DynamicObject)currencyMap.get(model));
            this.setColDimensionEntryExt(areaEntry, ResManager.loadKDString((String)"\u5408\u5e76\u5355\u5143\u8c03\u6574", (String)"RptadjustUpgradeService_4", (String)"fi-bcm-business", (Object[])new Object[0]), startColIdx++, false, (DynamicObject)processTable.get((Object)model, (Object)"DADJ"), (DynamicObject)atMap.get(model), (DynamicObject)currencyMap.get(model));
            this.setColDimensionEntryExt(areaEntry, ResManager.loadKDString((String)"\u8c03\u6574\u6c47\u603b\u6570", (String)"RptadjustUpgradeService_5", (String)"fi-bcm-business", (Object[])new Object[0]), startColIdx++, false, (DynamicObject)processTable.get((Object)model, (Object)"ADJT"), (DynamicObject)atMap.get(model), (DynamicObject)currencyMap.get(model));
            this.setColDimensionEntryExt(areaEntry, ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u9500\u660e\u7ec6", (String)"RptadjustUpgradeService_6", (String)"fi-bcm-business", (Object[])new Object[0]), startColIdx++, true, (DynamicObject)processTable.get((Object)model, (Object)"SEJE"), (DynamicObject)atMap.get(model), (DynamicObject)currencyMap.get(model));
            this.setColDimensionEntryExt(areaEntry, ResManager.loadKDString((String)"\u5408\u5e76\u5355\u5143\u62b5\u9500", (String)"RptadjustUpgradeService_7", (String)"fi-bcm-business", (Object[])new Object[0]), startColIdx++, false, (DynamicObject)processTable.get((Object)model, (Object)"DEJE"), (DynamicObject)atMap.get(model), (DynamicObject)currencyMap.get(model));
            this.setColDimensionEntryExt(areaEntry, ResManager.loadKDString((String)"\u62b5\u9500\u6c47\u603b\u6570", (String)"RptadjustUpgradeService_8", (String)"fi-bcm-business", (Object[])new Object[0]), startColIdx++, false, (DynamicObject)processTable.get((Object)model, (Object)"EJET"), (DynamicObject)atMap.get(model), (DynamicObject)currencyMap.get(model));
            tmp.getAreaRangeEntries().add(areaEntry);
            uppdateDys.add(tmp.genDynamicObject());
        }
    }

    private static /* synthetic */ void lambda$updateWorkPaper$3(Table processTable, DynamicObject processDy) {
        DynamicObject cfr_ignored_0 = (DynamicObject)processTable.put((Object)processDy.getLong("model.id"), (Object)processDy.getString("number"), (Object)processDy);
    }
}

