/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RuleHelpItemUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        HashMap<String, String> map = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("bcm/bcm_rulehelperitem.xml");){
            Document document = reader.read(resourceAsStream);
            Element node = document.getRootElement();
            Iterator iter = node.elementIterator();
            while (iter.hasNext()) {
                Element row = (Element)iter.next();
                String id = row.element("fid").getText();
                String content = row.element("fcontent").getText();
                map.put(id, content);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        if (map.size() > 0) {
            List ids = LongUtil.toLongList(map.keySet());
            SQLBuilder4RDB updateSql = new SQLBuilder4RDB();
            updateSql.append("update t_bcm_rulehelperitem set fcontent = ?, fmodifydate = ? where fid = ?");
            ArrayList<Object[]> paremList = new ArrayList<Object[]>(map.size());
            for (Map.Entry ent : map.entrySet()) {
                String content = (String)ent.getValue();
                paremList.add(new Object[]{content, TimeServiceHelper.now(), LongUtil.toLong(ent.getKey())});
            }
            if (!paremList.isEmpty()) {
                try (TXHandle tx = TX.required((String)"RuleHelpItemUpgradeService");){
                    try {
                        DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql.toString(), paremList);
                        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_rulehelperitem set fcatalogid = 1712257449265731584 where fid = 1712424584646497280");
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        this.log.error("insert rulehelpitem content error", (Throwable)e);
                        throw new KDBizException(e.getMessage());
                    }
                }
            }
        }
        return super.upgrade();
    }
}

