/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import org.apache.commons.collections.CollectionUtils;

public class SceneCslschemeUpgradeService
extends BcmUpgradeService {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(SceneCslschemeUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        String sqlCsl = "select fid, fmodel from t_bcm_cslscheme where fnodetype = '1' and fnumber != 'DefaultRateScheme'";
        DataSet cslRows = DB.queryDataSet((String)"select_all_cslscheme", (DBRoute)DBRoute.of((String)"bcm"), (String)sqlCsl);
        HashMap<Long, List> model2csls = new HashMap<Long, List>(16);
        while (cslRows.hasNext()) {
            Row next = cslRows.next();
            Long cslId = next.getLong("fid");
            Long modelId = next.getLong("fmodel");
            model2csls.computeIfAbsent(modelId, k -> new ArrayList(10)).add(cslId);
        }
        if (model2csls.size() > 0) {
            String sqlScene = "select fid, fmodelid from t_bcm_structofscene where flevel = 2 and fid not in (select fid from t_bcm_scenecslscheme)";
            DataSet sceneRows = DB.queryDataSet((String)"select_all_scene", (DBRoute)DBRoute.of((String)"bcm"), (String)sqlScene);
            ArrayList<Tuple> model2sId2cslList = new ArrayList<Tuple>(10);
            while (sceneRows.hasNext()) {
                Row next = sceneRows.next();
                Long modelId = next.getLong("fmodelid");
                List cslIds = (List)model2csls.get(modelId);
                if (!CollectionUtils.isNotEmpty((Collection)cslIds)) continue;
                Long sceneId = next.getLong("fid");
                Tuple tuple = Tuple.create((Object)modelId, (Object)sceneId, (Object)cslIds);
                model2sId2cslList.add(tuple);
            }
            if (model2sId2cslList.size() > 0) {
                String insertSql = "insert into t_bcm_scenecslscheme (fpkid, fid, fbasedataid) values (?, ?, ?)";
                Iterator iterator = model2sId2cslList.iterator();
                ArrayList<Object[]> params = new ArrayList<Object[]>(30);
                try (TXHandle tx = TX.required((String)"bcm_SceneCslschemeUpgradeService");){
                    try {
                        while (iterator.hasNext()) {
                            Tuple next = (Tuple)iterator.next();
                            Long scId = (Long)next.p2;
                            List cslIds = (List)next.p3;
                            for (Long cslId : cslIds) {
                                Object[] param = new Object[]{GlobalIdUtil.genGlobalLongId(), scId, cslId};
                                params.add(param);
                            }
                            if (params.size() != 5000) continue;
                            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, params);
                            params.clear();
                        }
                        if (params.size() > 0) {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, params);
                        }
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        LOG.error(e.getMessage(), (Throwable)e);
                        throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[]{e.getMessage()});
                    }
                }
            }
        }
        return super.upgrade();
    }
}

