/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class ShareOrgPermUpgradeService
extends BcmUpgradeService {
    public Map<String, Object> upgradeTest(Long modelId) {
        DataSet dataSet = this.getData(modelId);
        if (dataSet.isEmpty()) {
            return Maps.newHashMap();
        }
        return this.upgradeStart(dataSet.limit(0, 1));
    }

    @Override
    public Map<String, Object> upgrade() {
        return this.upgradeStart(this.getData(null));
    }

    private DataSet getData(Long modelId) {
        QFilter qFilter = new QFilter("storagetype", "=", (Object)StorageTypeEnum.SHARE.index);
        if (modelId != null) {
            qFilter.and("model", "=", (Object)modelId);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bcm", (String)"bcm_entitymembertree", (String)"id", (QFilter[])qFilter.toArray(), null);
        return dataSet;
    }

    private Map<String, Object> upgradeStart(DataSet dataSet) {
        ArrayList idList = new ArrayList(10000);
        dataSet.forEach(x -> {
            if (x != null && x.getLong("id") != null) {
                idList.add(x.getLong("id"));
            }
        });
        try (TXHandle tx = TXHandle.get();){
            try {
                BatchProcessHelper.batchConsume(idList, (int)10000, x -> DeleteServiceHelper.delete((String)"bcm_memberperm", (QFilter[])new QFilter("member", "in", x).toArray()));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return super.success();
    }
}

