/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.enums.CvtFactorEnum4Edit;
import kd.fi.bcm.common.util.QFBuilder;

public class SpecialCvtFormulaUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        this.doUpgrade();
        return this.success();
    }

    public void doUpgrade() {
        QFBuilder qf = new QFBuilder();
        qf.add("convertformula", "!=", (Object)"").or("convertformula", "!=", (Object)" ");
        qf.add("cvtformulaechoed", "=", (Object)"").or("cvtformulaechoed", "=", (Object)" ");
        DynamicObject[] udfs = BusinessDataServiceHelper.load((String)"bcm_userdefcvtformula", (String)"convertformula, cvtformulaechoed", (QFilter[])qf.toArray());
        HashSet<String> cvtNumbers = new HashSet<String>(CvtFactorEnum4Edit.values().length);
        for (CvtFactorEnum4Edit factor : CvtFactorEnum4Edit.values()) {
            cvtNumbers.add(factor.getNumber());
        }
        Set rateNumbers = SysMembConstant.rateNumbers;
        Set preRateNumbers = SysMembConstant.preRateNumbers;
        for (DynamicObject udf : udfs) {
            String formula = udf.getString("convertformula");
            try {
                StringBuffer cvtformulaechoed = new StringBuffer();
                StringBuffer factor = new StringBuffer();
                for (int j = 0; j < formula.length(); ++j) {
                    char letter = formula.charAt(j);
                    if (letter >= 'A' && letter <= 'Z' || letter >= 'a' && letter <= 'z' || letter >= '0' && letter <= '9') {
                        factor.append(letter);
                        continue;
                    }
                    if (factor.length() == 0) {
                        cvtformulaechoed.append(letter);
                        continue;
                    }
                    String tmp = factor.toString();
                    if (cvtNumbers.contains(tmp)) {
                        cvtformulaechoed.append("CVT(\"cvtfactor@").append(tmp).append("\")");
                    } else if (rateNumbers.contains(tmp) || preRateNumbers.contains(tmp)) {
                        cvtformulaechoed.append("CVT(\"exchange@").append(tmp).append("\")");
                    }
                    cvtformulaechoed.append(letter);
                    factor = new StringBuffer();
                }
                if (factor.length() > 0) {
                    String tmp = factor.toString();
                    if (cvtNumbers.contains(tmp)) {
                        cvtformulaechoed.append("CVT(\"cvtfactor@").append(tmp).append("\")");
                    } else if (rateNumbers.contains(tmp) || preRateNumbers.contains(tmp)) {
                        cvtformulaechoed.append("CVT(\"exchange@").append(tmp).append("\")");
                    }
                }
                udf.set("cvtformulaechoed", (Object)cvtformulaechoed.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (udfs.length > 0) {
            SaveServiceHelper.save((DynamicObject[])udfs);
        }
    }
}

