/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class TemplateScenarioUpgradeService
extends BcmUpgradeService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(TemplateScenarioUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        try {
            this.updateCheckTmplScenario(null);
            this.updatePaperTemplateScenario(null);
            this.updateInvTemplateScenario(null);
        }
        catch (Exception e) {
            logger.error("\u5347\u7ea7\u9002\u7528\u60c5\u666f\u5931\u8d25", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return super.upgrade();
    }

    public void updateByModelId(long newModelId) {
        try {
            this.updateCheckTmplScenario(newModelId);
            this.updatePaperTemplateScenario(newModelId);
            this.updateInvTemplateScenario(newModelId);
        }
        catch (Exception e) {
            logger.error("\u5347\u7ea7\u9002\u7528\u60c5\u666f\u5931\u8d25\uff0cnewModelId=" + newModelId, (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private void updateInvTemplateScenario(Long newModelId) {
        String sql = "select a.fid as fid ,a.fscenarioid as fscenarioid from t_bcm_invelimtemplate a left join t_bcm_invtmplscenario b on a.fid = b.fid where b.fid  is  null";
        if (newModelId != null) {
            sql = sql + " and a.fmodelid = " + newModelId;
        }
        DataSet ds = DB.queryDataSet((String)"find_invtmplscenario", (DBRoute)DBRoute.of((String)"bcm"), (String)sql, null);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            paramList.add(new Object[]{row.getLong("fid"), 1, GlobalIdUtil.genGlobalLongId(), row.getLong("fscenarioid"), "10", "0"});
        }
        if (paramList.size() > 0) {
            String insertSql = "INSERT INTO t_bcm_invtmplscenario (fid,fseq,fentryid,fscenarioid,fscope,fisexcept) VALUES (?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, paramList);
        }
    }

    private void updatePaperTemplateScenario(Long modelId) {
        String tmplSql = "select t.fid as fid from t_bcm_papertemplate t where t.fgroupid = 0";
        if (modelId != null) {
            tmplSql = tmplSql + " and t.fmodelid = " + modelId;
        }
        DataSet adjDs = DB.queryDataSet((String)"update_groupid_bcm_papertemplate_date", (DBRoute)DBRoute.of((String)"bcm"), (String)tmplSql, null);
        ArrayList<Object[]> adjParamList = new ArrayList<Object[]>(16);
        while (adjDs != null && adjDs.hasNext()) {
            Row row = adjDs.next();
            adjParamList.add(new Object[]{row.getLong("fid"), row.getLong("fid")});
        }
        if (adjParamList.size() > 0) {
            String updateSql = "update t_bcm_papertemplate set fgroupid = ? where fid = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql, adjParamList);
        }
        String sceneSql = "select distinct a.fgroupid as groupid,a.fscenarioid as scenarioid,a.fmodelid as modelid,c.flongnumber as longnumber from t_bcm_papertemplate a left join t_bcm_tmplscenario b on a.fmodelid = b.fmodelid and a.fgroupid = b.fgroupid left join t_bcm_papertplcatalog c on a.fmodelid = c.fmodelid and a.ftemplatecatalog  = c.fid where b.fid is null";
        if (modelId != null) {
            sceneSql = sceneSql + " and a.fmodelid = " + modelId;
        }
        DataSet ds = DB.queryDataSet((String)"init_bcm_tmplscenario_date", (DBRoute)DBRoute.of((String)"bcm"), (String)sceneSql, null);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            TemplateCatalogEnum catalog = PaperTemplateService.getCatalogEnumByLongnumber(row.getString("longnumber"));
            if (catalog == null) continue;
            String type = null;
            if (TemplateCatalogEnum.INVELIM == catalog) {
                type = PaperTemplateTypeEnum.INVELIM.getCode();
            } else if (TemplateCatalogEnum.INNERTRADE == catalog) {
                type = PaperTemplateTypeEnum.INNERTRADE.getCode();
            } else if (TemplateCatalogEnum.PRTADJUST == catalog) {
                type = PaperTemplateTypeEnum.PRTADJUST.getCode();
            }
            if (type == null) continue;
            paramList.add(new Object[]{GlobalIdUtil.genGlobalLongId(), row.getLong("scenarioid"), row.getLong("modelid"), "10", row.getLong("groupid"), "0", type});
        }
        if (paramList.size() > 0) {
            String insertSql = "INSERT INTO t_bcm_tmplscenario (fid,fscenarioid,fmodelid,fscope,fgroupid,fisexcept,ftype) VALUES (?,?,?,?,?,?,?);";
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, paramList);
        }
    }

    private void updateCheckTmplScenario(Long modelId) {
        DataSet ds = DB.queryDataSet((String)"find_checktmplscenario_data", (DBRoute)DBRoute.of((String)"bcm"), (String)"select a.fid as fid ,a.fscenarioid as fscenarioid from t_bcm_checktmpl a left join t_bcm_checktmplscenario b on a.fid = b.fid where b.fid  is  null;", null);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            paramList.add(new Object[]{row.getLong("fid"), GlobalIdUtil.genGlobalLongId(), 1, row.getLong("fscenarioid"), "10", "0"});
        }
        if (paramList.size() > 0) {
            String insertSql = "INSERT INTO t_bcm_checktmplscenario (fid,fentryid,fseq,fscenarioid,fscope,fisexcept) VALUES (?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, paramList);
        }
    }
}

