/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.IUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;

public class UpgradeServieceManager {
    private long upgradeId;
    private UpgradeContext context;
    private boolean modelSucess = false;
    List<IUpgradeService> upgradeServices = new ArrayList<IUpgradeService>(16);
    List<ServiceNode> serviceNodes = new ArrayList<ServiceNode>(16);

    public UpgradeServieceManager(long upgradeId, UpgradeContext context) {
        this.upgradeId = upgradeId;
        this.context = context;
    }

    public UpgradeContext getContext() {
        return this.context;
    }

    public void addUpgradeService(IUpgradeService service) {
        this.upgradeServices.add(service);
    }

    private void excuteRelaUpgrade() {
        this.cacheDelBp();
        ServiceNode root = this.buildServiceNode();
        this.doExcuteUpgrade(root);
        this.updateUpgradeModelRecord();
    }

    private void cacheDelBp() {
        DynamicObject[] bps;
        QFilter bpFilter = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"CS"}));
        for (DynamicObject bp : bps = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,dimension.id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.context.getModelId()), bpFilter})) {
            this.context.getDel_bps().put(bp.getString("number"), bp.getLong("id"));
        }
    }

    private void doExcuteUpgrade(ServiceNode root) {
        root.getService().doExcuteUpgrade();
        if (((AbstractUpgradeService)root.getService()).getExcuteStatus() != AbstractUpgradeService.ExcuteEnum.EXCUTING) {
            for (ServiceNode childNode : root.getChildNodes()) {
                this.doExcuteUpgrade(childNode);
            }
        }
    }

    private ServiceNode buildServiceNode() {
        HashMap<String, ServiceNode> num2Nodes = new HashMap<String, ServiceNode>(16);
        for (IUpgradeService upgradeService : this.upgradeServices) {
            if (!(upgradeService instanceof AbstractUpgradeService)) continue;
            AbstractUpgradeService service = (AbstractUpgradeService)upgradeService;
            ServiceNode node = new ServiceNode(service.getNumber(), upgradeService);
            this.serviceNodes.add(node);
            num2Nodes.put(service.getNumber(), node);
        }
        for (ServiceNode node : this.serviceNodes) {
            for (String parentNumber : ((AbstractUpgradeService)node.getService()).getParentNumbers()) {
                node.getParentNodes().add((ServiceNode)num2Nodes.get(parentNumber));
            }
        }
        ServiceNode root = null;
        for (ServiceNode serviceNode : this.serviceNodes) {
            AbstractUpgradeService service = (AbstractUpgradeService)serviceNode.getService();
            if (service.getParentNumbers().size() >= 1) continue;
            root = serviceNode;
        }
        this.getRoot(root);
        return root;
    }

    private void getRoot(ServiceNode root) {
        for (ServiceNode serviceNode : this.serviceNodes) {
            AbstractUpgradeService service = (AbstractUpgradeService)serviceNode.getService();
            if (root == null && service.getParentNumbers().isEmpty()) {
                root = serviceNode;
                this.getRoot(root);
                continue;
            }
            if (root == null || !service.getParentNumbers().contains(root.getNumber())) continue;
            for (String parentNumber : service.getParentNumbers()) {
                if (root.isInChildNodes(parentNumber)) continue;
                root.getChildNodes().add(serviceNode);
            }
        }
    }

    public boolean excuteUpgrade() {
        this.excuteRelaUpgrade();
        return this.modelSucess;
    }

    private void updateUpgradeModelRecord() {
        boolean sucess = true;
        for (ServiceNode serviceNode : this.serviceNodes) {
            if (((AbstractUpgradeService)serviceNode.getService()).getExcuteStatus() == AbstractUpgradeService.ExcuteEnum.SUCESS) continue;
            sucess = false;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)this.upgradeId, (String)"bcm_upgradecontent");
        boolean isModify = false;
        Date nowTime = TimeServiceHelper.now();
        for (DynamicObject modelRecord : dy.getDynamicObjectCollection("entryentity")) {
            if (modelRecord.getLong("model.id") != this.context.getModelId()) continue;
            modelRecord.set("model", (Object)this.context.getModelId());
            modelRecord.set("upgradetime", (Object)nowTime);
            modelRecord.set("dycal_time", (Object)this.context.getDycal_time());
            modelRecord.set("data", (Object)JSONObject.toJSONString((Object)this.context));
            modelRecord.set("status", (Object)sucess);
            isModify = true;
        }
        if (!isModify) {
            DynamicObject upgradeRecord = new DynamicObject(dy.getDynamicObjectCollection("entryentity").getDynamicObjectType());
            upgradeRecord.set("model", (Object)this.context.getModelId());
            upgradeRecord.set("upgradetime", (Object)nowTime);
            upgradeRecord.set("dycal_time", (Object)this.context.getDycal_time());
            upgradeRecord.set("data", (Object)JSONObject.toJSONString((Object)this.context));
            upgradeRecord.set("status", (Object)sucess);
            dy.getDynamicObjectCollection("entryentity").add((Object)upgradeRecord);
        }
        this.modelSucess = sucess;
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
    }

    public static class ServiceNode {
        private String number;
        private IUpgradeService service;
        private boolean iscomplete = false;
        private List<ServiceNode> parentNodes = new ArrayList<ServiceNode>(0);
        private List<ServiceNode> childNodes = new ArrayList<ServiceNode>(0);

        public ServiceNode(String number, IUpgradeService service) {
            this.number = number;
            this.service = service;
        }

        public boolean isParentsComplete() {
            for (ServiceNode parentNode : this.parentNodes) {
                if (parentNode.iscomplete) continue;
                return false;
            }
            return true;
        }

        public String getNumber() {
            return this.number;
        }

        public IUpgradeService getService() {
            return this.service;
        }

        public boolean isIscomplete() {
            return this.iscomplete;
        }

        public List<ServiceNode> getParentNodes() {
            return this.parentNodes;
        }

        public List<ServiceNode> getChildNodes() {
            return this.childNodes;
        }

        public void setIscomplete(boolean iscomplete) {
            this.iscomplete = iscomplete;
        }

        public boolean isInChildNodes(String number) {
            for (ServiceNode childNode : this.childNodes) {
                if (!childNode.number.equals(number)) continue;
                return true;
            }
            return false;
        }
    }
}

