/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.business.util.UpgradeWorkPaperTemplateUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.TemplateTypeEnum;

public class WorkPaperUpgradeService
extends AbstractUpgradeService {
    List<DynamicObject> uppdateDys;
    List<Object> pks;

    public WorkPaperUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    protected void saveData() {
        if (!this.uppdateDys.isEmpty()) {
            for (DynamicObject t : this.uppdateDys) {
                BusinessDataWriter.update((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t});
                AppCacheServiceHelper.remove(t.getString("id"));
                GlobalCacheServiceHelper.invalidateTemplateModel((String)t.getString("id"));
            }
        }
        UpgradeWorkPaperTemplateUtil.upgradeWpTemplate(this.context.getModelId());
    }

    @Override
    protected void readyUpgradeData() {
        this.pks = QueryServiceHelper.queryPrimaryKeys((String)"bcm_templateentity", (QFilter[])new QFilter("model", "=", (Object)this.context.getModelId()).and("templatetype", "=", (Object)String.valueOf(TemplateTypeEnum.MSN.getType())).toArray(), null, (int)-1);
        DynamicObject[] workDys = BusinessDataServiceHelper.load((Object[])this.pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"));
        Map<Long, List<DynamicObject>> workMaps = Arrays.stream(workDys).collect(Collectors.groupingBy(work -> work.getLong("model.id")));
        this.uppdateDys = new ArrayList<DynamicObject>(10);
        workMaps.forEach((model, workList) -> {
            for (DynamicObject dyna : workList) {
                dyna.set("isoldtemplate", (Object)"1");
                this.uppdateDys.add(dyna);
            }
        });
    }
}

