/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade.adjust;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class AdjustBelongOrgUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        String insertSql = "INSERT INTO t_bcm_adbelongorglist(FID,FENTRYID,FBELONGORGID) VALUES (?,?,?); ";
        ArrayList singleParams = new ArrayList(16);
        ArrayList obParams = new ArrayList(16);
        PlatUtil.executeWithTXNew(tx -> {
            DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"delete from t_bcm_adbelongorglist");
            String queryHeadSql = "select adjust.fid id,adjust.fprocess process,adjust.fbelongorg belongorg from t_bcm_rptadjust adjust JOIN T_BCM_StructOfFY fy ON fy.FId = adjust.fyearid where fy.fnumber >= 'FY2024'";
            try (DataSet ds = DB.queryDataSet((String)"queryHeadSql", (DBRoute)BCMConstant.DBROUTE, (String)queryHeadSql);){
                ds.forEach(r -> {
                    if (OrgRelaProcessMembPool.isRelaProcess((String)r.getString("process"))) {
                        Object[] param = new Object[]{r.getLong("id"), GlobalIdUtil.genGlobalLongId(), r.getLong("belongorg")};
                        obParams.add(param);
                        AdjustOperationHelper.executeDBBatch(insertSql, obParams, 50000, false);
                    } else {
                        singleParams.add(r.getLong("id"));
                    }
                });
            }
            HashMap pk2MainOrgMap = new HashMap(singleParams.size());
            BatchProcessHelper.batchConsume((List)singleParams, (int)50000, childParamList -> {
                String queryEntrySql = String.format("select distinct fadjustid,forgid from t_bcm_rptadjustdata where fadjustid in (%s)", String.join((CharSequence)",", (CharSequence[])childParamList.stream().map(Object::toString).distinct().toArray(String[]::new)));
                try (DataSet ds = DB.queryDataSet((String)"queryEntrySql", (DBRoute)BCMConstant.DBROUTE, (String)queryEntrySql);){
                    ds.forEach(r -> {
                        long adjustId = r.getLong("fadjustid");
                        long orgId = r.getLong("forgid");
                        Object[] param = new Object[]{adjustId, GlobalIdUtil.genGlobalLongId(), orgId};
                        obParams.add(param);
                        AdjustOperationHelper.executeDBBatch(insertSql, obParams, 50000, false);
                        pk2MainOrgMap.computeIfAbsent(r.getLong("fadjustid"), aLong -> orgId);
                    });
                }
                AdjustOperationHelper.executeDBBatch(insertSql, obParams, 50000, true);
                String updateHeadSql = "UPDATE t_bcm_rptadjust SET fbelongorg = ?,fentity = ? WHERE FID = ?; ";
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
                pk2MainOrgMap.forEach((adjustId, orgId) -> {
                    Object[] childParam = new Object[]{orgId, orgId, adjustId};
                    updateParams.add(childParam);
                    AdjustOperationHelper.executeDBBatch(updateHeadSql, updateParams, 50000, false);
                });
                AdjustOperationHelper.executeDBBatch(updateHeadSql, updateParams, 50000, true);
                pk2MainOrgMap.clear();
            });
        });
        return this.success();
    }
}

