/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade.epbs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.epm.epbs.common.enums.CloudTypeEnum;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.util.UpgradeUtil;
import kd.fi.bcm.common.BCMConstant;

public class EpbsDataSourceUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        block33: {
            String field = "fid,fnumber,fname,fserveraddress,fport,fusername,fpassword,fdiscription,fdataconnect,faccountid,fcreatorid,fcreatetime,fmodifierid,fmodifytime";
            try (DataSet dataSet = DB.queryDataSet((String)(this.getClass().getSimpleName() + ".upgrade"), (DBRoute)BCMConstant.DBROUTE, (String)String.format("select %s from t_bcm_datasource", field));){
                ArrayList list = new ArrayList(16);
                ArrayList<Long> pkIds = new ArrayList<Long>(16);
                String[] fieldArr = field.split(",");
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    for (String f : fieldArr) {
                        Object value = next.get(f);
                        if (f.equals("fpassword")) {
                            value = String.valueOf(value).startsWith("OlapPwd_") ? String.valueOf(value).substring("OlapPwd_".length()) : EncryptUtils.aesEncrypt((String)EncryptUtils.aesDecrypt((String)String.valueOf(value)));
                        }
                        map.put(f, value);
                    }
                    list.add(map);
                    pkIds.add(next.getLong("fid"));
                }
                String epbsField = "fid,fnumber,fname,fserveraddress,fport,fusername,fpassword,fdataconnect,fdesc,faccountid,faccountnumber,fcreatorid,fcreatetime,fmodifierid,fmodifytime";
                String[] epbsfieldArr = epbsField.split(",");
                String sql = String.format("insert into t_epbs_datasource (%s) values (%s)", epbsField, UpgradeUtil.placeHolder(epbsfieldArr.length));
                ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                ArrayList<Object[]> multiLangParams = new ArrayList<Object[]>(16);
                String[] pkId = DB.genStringIds((String)"t_epbs_datasource_l", (int)list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Map data = (Map)list.get(i);
                    ArrayList list1 = new ArrayList();
                    ArrayList<String> list2 = new ArrayList<String>();
                    list2.add(pkId[i]);
                    list2.add((String)data.get("fid"));
                    list2.add(Lang.zh_CN.name());
                    for (String f : epbsfieldArr) {
                        if (f.equals("fdesc")) {
                            list1.add(data.get("fdiscription"));
                            list2.add((String)data.get("fdiscription"));
                            continue;
                        }
                        if (f.equals("fname")) {
                            list2.add((String)data.get(f));
                            list1.add(data.get(f));
                            continue;
                        }
                        list1.add(data.get(f));
                    }
                    params.add(list1.toArray());
                    multiLangParams.add(list2.toArray());
                }
                String deleteSql = String.format("delete from t_epbs_datasource where fid in (%s)", UpgradeUtil.placeHolder(pkIds.size()));
                String multiLangField = "fpkid,fid,flocaleid,fname,fdesc";
                String multiLangSql = String.format("insert into t_epbs_datasource_l (%s) values (%s)", multiLangField, UpgradeUtil.placeHolder(multiLangField.split(",").length));
                String deletemultiLangSql = String.format("delete from t_epbs_datasource_l where fid in (%s)", UpgradeUtil.placeHolder(pkIds.size()));
                if (pkIds.isEmpty()) break block33;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        DB.execute((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)deleteSql, (Object[])pkIds.toArray());
                        DB.executeBatch((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)sql, params);
                        DB.execute((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)deletemultiLangSql, (Object[])pkIds.toArray());
                        DB.executeBatch((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)multiLangSql, multiLangParams);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25!", (String)"EpbsParamSetUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0])), new Object[0]);
                    }
                }
                AppCacheServiceHelper.clear();
            }
        }
        return this.success();
    }
}

