/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade.epbs;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.common.enums.CloudTypeEnum;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.util.UpgradeUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class EpbsModelUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        ArrayList<Object[]> multiLangParams = new ArrayList<Object[]>(16);
        HashSet reporttypes = Sets.newHashSet((Object[])new String[]{ApplicationTypeEnum.CM.getOIndex(), ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex()});
        String field = "fid,fnumber,fshownumber,fname,fdescription,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fstatus,fenable,freporttype,fdatasource";
        DataSet dataSet = DB.queryDataSet((String)(this.getClass().getSimpleName() + ".upgrade"), (DBRoute)BCMConstant.DBROUTE, (String)String.format("select %s from t_bcm_model", field));
        ArrayList<Long> pkIds = new ArrayList<Long>(16);
        String[] fieldArr = field.split(",");
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String freporttype = next.getString("freporttype");
            if (!reporttypes.contains(freporttype)) continue;
            ArrayList<Object> list1 = new ArrayList<Object>(16);
            for (String f : fieldArr) {
                if (Objects.equals("freporttype", f)) continue;
                String[] value = next.get(f);
                list1.add(value);
            }
            list1.add(ApplicationTypeEnum.getEnumByIndex((String)freporttype).name().toLowerCase(Locale.ROOT));
            params.add(list1.toArray());
            pkIds.add(next.getLong("fid"));
        }
        dataSet.close();
        String multiLangField = "fpkid,fid,flocaleid,fname,fdescription";
        dataSet = DB.queryDataSet((String)(this.getClass().getSimpleName() + ".upgrade"), (DBRoute)BCMConstant.DBROUTE, (String)String.format("select %s from t_bcm_model_l", multiLangField));
        int multiLangCount = dataSet.copy().count("fpkid", false);
        String[] pkId = DB.genStringIds((String)"t_epbs_model_l", (int)multiLangCount);
        int index = 0;
        String[] multiLangFieldArr = multiLangField.split(",");
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            ArrayList<Object> list1 = new ArrayList<Object>(16);
            list1.add(pkId[index]);
            for (String f : multiLangFieldArr) {
                if (Objects.equals("fpkid", f)) continue;
                Object value = next.get(f);
                list1.add(value);
            }
            multiLangParams.add(list1.toArray());
            ++index;
        }
        dataSet.close();
        String deleteSql = String.format("delete from t_epbs_model where fid in (%s)", UpgradeUtil.placeHolder(pkIds.size()));
        String epbsField = "fid,fnumber,fshownumber,fname,fdescription,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fstatus,fenable,fdatasource,fappnum";
        String sql = String.format("insert into t_epbs_model (%s) values (%s)", epbsField, UpgradeUtil.placeHolder(epbsField.split(",").length));
        String deletemultiLangSql = String.format("delete from t_epbs_model_l where fid in (%s)", UpgradeUtil.placeHolder(pkIds.size()));
        String multiLangSql = String.format("insert into t_epbs_model_l (%s) values (%s)", multiLangField, UpgradeUtil.placeHolder(multiLangField.split(",").length));
        if (CollectionUtils.isEmpty(pkIds)) {
            return this.success();
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)deleteSql, (Object[])pkIds.toArray());
                DB.execute((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)deletemultiLangSql, (Object[])pkIds.toArray());
                DB.executeBatch((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)sql, params);
                DB.executeBatch((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)multiLangSql, multiLangParams);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25!", (String)"EpbsParamSetUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0])), new Object[0]);
            }
        }
        return this.success();
    }
}

