/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade.epbs;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.schedule.formplugin.SavePlugin;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.ScheduleUtil;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.upgrade.epbs.BcmOlapTraceLogUpgradeTask;
import kd.fi.bcm.business.util.UpgradeUtil;

public class EpbsOlapTraceLogUpgradeService
extends BcmUpgradeService {
    private static String STARTTIME = "starttime";
    private static String ENDTIME = "endtime";

    @Override
    public Map<String, Object> upgrade() {
        EpbsOlapTraceLogUpgradeService.createSchedule();
        return this.success();
    }

    public void upgradeOlapTraceLog(Map<String, Object> map) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTime = null;
        Date endTime = null;
        Calendar now = Calendar.getInstance();
        try {
            if (!map.containsKey(STARTTIME)) {
                endTime = now.getTime();
                now.add(2, -2);
                startTime = now.getTime();
            } else {
                startTime = format.parse((String)map.get(STARTTIME));
                endTime = format.parse((String)map.get(ENDTIME));
            }
            while (startTime.getTime() < endTime.getTime()) {
                now = Calendar.getInstance();
                now.setTime(startTime);
                now.add(2, 1);
                Date currentEndTime = now.getTime();
                if (currentEndTime.getTime() > endTime.getTime()) {
                    currentEndTime = endTime;
                }
                this.upgradeOlapTraceLog(format.format(startTime), format.format(currentEndTime));
                startTime = currentEndTime;
                this.updateStartTime(startTime, endTime, map, format);
            }
            this.updateStartTime(startTime, endTime, map, format);
        }
        catch (Exception e) {
            try {
                this.log.error((Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25!", (String)"EpbsParamSetUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0])), new Object[0]);
            }
            catch (Throwable throwable) {
                this.updateStartTime(startTime, endTime, map, format);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeOlapTraceLog(String startTime, String endTime) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        ArrayList<Long> pkIds = new ArrayList<Long>(16);
        int pageSize = 5000;
        int pageIndex = 0;
        int count = pageSize;
        String field = "fid,fusername,fopname,fopdesc,fopdate,ftraceid,fdetail,funiqueid";
        DataSet dataSet = null;
        try {
            while (count == pageSize) {
                params.clear();
                pkIds.clear();
                this.log.startWatch();
                count = 0;
                String where = String.format(" fopdate > '%s' and fopdate <= '%s'", startTime, endTime);
                String top = "TOP " + pageSize + "," + pageIndex;
                String selectSql = String.format("select %s %s from t_bcm_traceoplog where %s order by fid", top, field, where);
                dataSet = DB.queryDataSet((String)(this.getClass().getSimpleName() + ".upgrade"), (DBRoute)DBRoute.log, (String)selectSql);
                this.log.infoEnd("t_bcm_traceoplog select " + top + where);
                String[] fieldArr = field.split(",");
                while (dataSet.hasNext()) {
                    ++count;
                    Row next = dataSet.next();
                    ArrayList<Object> list1 = new ArrayList<Object>(16);
                    for (String f : fieldArr) {
                        Object value = next.get(f);
                        list1.add(value);
                    }
                    params.add(list1.toArray());
                    pkIds.add(next.getLong("fid"));
                }
                dataSet.close();
                if (count > 0) {
                    this.log.startWatch();
                    String deleteSql = String.format("delete from t_epbs_traceoplog where fid in (%s)", UpgradeUtil.placeHolder(pkIds.size()));
                    DB.execute((DBRoute)DBRoute.log, (String)deleteSql, (Object[])pkIds.toArray());
                    String insertSql = String.format("insert into t_epbs_traceoplog (%s) values (%s)", field, UpgradeUtil.placeHolder(field.split(",").length));
                    DB.executeBatch((DBRoute)DBRoute.log, (String)insertSql, params);
                    this.log.infoEnd("t_epbs_traceoplog del and insert " + top + where);
                }
                pageIndex += pageSize;
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
            params.clear();
            pkIds.clear();
        }
    }

    private void updateStartTime(Date startTime, Date endTime, Map<String, Object> map, SimpleDateFormat format) {
        if (null != startTime) {
            map.put(STARTTIME, format.format(startTime));
            map.put(ENDTIME, format.format(endTime));
            ScheduleUtil.updateJobParams((String)((String)map.get("job")), map);
        }
    }

    public static String createSchedule() {
        AppTypeEnum appTypeEnum = AppTypeEnum.CM;
        String scheduleNumber = EpbsOlapTraceLogUpgradeService.numberFormat(appTypeEnum.getAppNum(), true);
        DynamicObject scheduleDyn = ScheduleUtil.getScheduleDyn((String)scheduleNumber);
        if (null != scheduleDyn) {
            return (String)scheduleDyn.getPkValue();
        }
        String name = ResManager.loadKDString((String)"\u5408\u5e76\u591a\u7ef4\u8ffd\u6eaf\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7%s", (String)"TaskScheduleHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]);
        String scheduleName = String.format(name, ResManager.loadKDString((String)"\u8ba1\u5212", (String)"TaskScheduleHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        Calendar expireTime = Calendar.getInstance();
        expireTime.add(1, 1);
        Calendar planTime = Calendar.getInstance();
        planTime.add(12, 2);
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        String jobName = String.format(name, ResManager.loadKDString((String)"\u4f5c\u4e1a", (String)"TaskScheduleHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        String jobNumber = EpbsOlapTraceLogUpgradeService.numberFormat(appTypeEnum.getAppNum(), false);
        String className = BcmOlapTraceLogUpgradeTask.class.getName();
        ScheduleUtil.createTaskDefine((String)BcmOlapTraceLogUpgradeTask.class.getSimpleName(), (String)className, (String)appTypeEnum.getAppId());
        ScheduleUtil.ScheduleModel scheduleModel = new ScheduleUtil.ScheduleModel();
        scheduleModel.setAppId(appTypeEnum.getAppId());
        scheduleModel.setScheduleNumber(scheduleNumber);
        scheduleModel.setScheduleName(scheduleName);
        scheduleModel.setJobNumber(jobNumber);
        scheduleModel.setJobName(jobName);
        scheduleModel.setClassName(className);
        scheduleModel.setExpireTime(expireTime.getTime());
        scheduleModel.setPlanTime(planTime.getTime());
        scheduleModel.setParamMap(paramMap);
        scheduleModel.setTxthost(SavePlugin.getHostIpAddress());
        String scheduleId = ScheduleUtil.createSchedule((ScheduleUtil.ScheduleModel)scheduleModel);
        paramMap.put("job", scheduleModel.getJobId());
        ScheduleUtil.updateJobParams((String)scheduleModel.getJobId(), paramMap);
        return scheduleId;
    }

    private static String numberFormat(String appnum, boolean isSchedule) {
        String number = String.format("%s_%s", appnum, "EpbsOlapTraceLogUpgrade");
        return ScheduleUtil.numberFormat((String)number, (boolean)isSchedule);
    }
}

