/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade.epbs;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.common.cache.helper.GlobalCacheServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.upgrade.epbs.EpbsParamSetUpgradeServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class EpbsParamSetUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        List<Long> modelIds = this.queryBcmModel().stream().map(e -> (Long)e.p1).collect(Collectors.toList());
        modelIds.add(0L);
        return this.upgrade(modelIds);
    }

    public Map<String, Object> upgrade(List<Long> modelIds) {
        try {
            List<String> failedNumbers = new EpbsParamSetUpgradeServiceHelper().upgrade(modelIds);
            if (CollectionUtils.isNotEmpty(failedNumbers)) {
                return this.fail(new KDBizException(new ErrorCode("", "param %s upgrade fail."), new Object[]{failedNumbers}));
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25!", (String)"EpbsParamSetUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0])), new Object[0]);
        }
        GlobalCacheServiceHelper.getCommonCache().invalidateAll();
        return this.success();
    }
}

