/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade.epbs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.paramsetting.enums.PsControlTypeEnum;
import kd.epm.epbs.business.paramsetting.enums.PsDataTypeEnum;
import kd.epm.epbs.business.paramsetting.enums.PsFormTypeEnum;
import kd.epm.epbs.business.paramsetting.model.ParamSetControl;
import kd.epm.epbs.business.paramsetting.model.ParamSetFormModel;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.common.enums.CloudTypeEnum;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.JSONUtils;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;

public class EpbsParamSetUpgradeServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(EpbsParamSetUpgradeServiceHelper.class);
    private final Map<String, PresetParamVO> epbsPresetParam;
    private List<Long> treeIds = Arrays.asList(1808880221076591616L, 1924587608428539904L);

    public EpbsParamSetUpgradeServiceHelper() {
        String sql = "select fid,fnumber,ftype,fformtype,fisolate,fissys from t_epbs_preset_param;";
        ArrayList<HashMap> presetParamList = new ArrayList<HashMap>(100);
        DataSet queryDataSet = DB.queryDataSet((String)"queryEPMParam", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        Object object = null;
        try {
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                HashMap rowData = Maps.newHashMapWithExpectedSize((int)16);
                rowData.put("id", row.getLong("fid"));
                rowData.put("number", row.getString("fnumber"));
                rowData.put("type", row.getInteger("ftype"));
                rowData.put("formtype", row.getInteger("fformtype"));
                rowData.put("isolate", row.getBoolean("fisolate"));
                rowData.put("issys", row.getBoolean("fissys"));
                presetParamList.add(rowData);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        HashMap<String, PresetParamVO> epbsPresetParamMap = new HashMap<String, PresetParamVO>(16);
        for (Map map : presetParamList) {
            epbsPresetParamMap.put(map.get("number").toString(), this.convertMap2PresetParamVO(map));
        }
        this.epbsPresetParam = MapUtils.unmodifiableMap(epbsPresetParamMap);
        LOGGER.info(ResManager.loadKDString((String)"\u5df2\u7ecf\u9884\u7f6e\u7684\u53c2\u6570", (String)"EpbsParamSetUpgradeServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]) + this.presetNumbers());
    }

    private PresetParamVO convertMap2PresetParamVO(Map<String, Object> presetParam) {
        return new PresetParamVO((Long)presetParam.get("id"), (Integer)presetParam.get("formtype"), (Integer)presetParam.get("type"), (Boolean)presetParam.get("isolate"), (Boolean)presetParam.get("issys"));
    }

    public List<String> upgrade(List<Long> modelIds) {
        block18: {
            try (TXHandle txHandle = TX.required();){
                if (modelIds.isEmpty()) break block18;
                List<String> numbers = this.presetNumbers();
                List<String> failedNumbers = this.upgradeDefaultForm(modelIds, numbers);
                if (CollectionUtils.isNotEmpty(failedNumbers)) {
                    List<String> list = failedNumbers;
                    return list;
                }
                try {
                    this.upgradeCustomForm(modelIds);
                    this.upgradeCommonForm(modelIds);
                    this.upgradeExtendParam(modelIds);
                    this.upgradeAuditLog(modelIds);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    throw e;
                }
            }
        }
        return new ArrayList<String>();
    }

    private List<String> presetNumbers() {
        return new ArrayList<String>(this.epbsPresetParam.keySet());
    }

    private void upgradeIsSupportNewMyTemplate(List<Long> modelIds) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "isSupportNewMytemplate");
        this.batchUpdateEntry(dataList, "isSupportNewMytemplate", data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("config", data.get("config"));
            Object json = data.get("json");
            if (json != null && StringUtils.isNotEmpty((String)json.toString())) {
                JSONObject extParam = JSONObjectUtil.parseObjectOrder((String)json.toString());
                jsonObject.put("self", extParam.get((Object)"self"));
            }
            return new ConfigVO(LongUtil.toLong(data.get("model")), JSONUtils.toString((Object)jsonObject), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
        });
    }

    private List<String> upgradeDefaultForm(List<Long> modelIds, List<String> numbers) {
        ArrayList<String> failedNumbers = new ArrayList<String>();
        Map<String, List<ConfigVO>> number2Value = this.getNumber2Value(modelIds, numbers);
        ArrayList<Object[]> sqlParam = new ArrayList<Object[]>();
        ArrayList<Object[]> updateSqlParam = new ArrayList<Object[]>();
        ArrayList<Object[]> deleteSqlParam = new ArrayList<Object[]>();
        number2Value.forEach((k, v) -> {
            PresetParamVO presetParamVO = this.epbsPresetParam.get(k);
            long id = presetParamVO.getId();
            if (this.isSingleValueParam((String)k)) {
                v.forEach(configVO -> {
                    Object[] param;
                    if (configVO.getFmodelid() == 0L && !presetParamVO.isIsolate()) {
                        param = new Object[]{configVO.getFconfig(), configVO.getFmodifytime(), configVO.getFmodifierid(), id, configVO.getFmodelid()};
                        updateSqlParam.add(param);
                    }
                    if (configVO.getFmodelid() != 0L && presetParamVO.isIsolate()) {
                        deleteSqlParam.add(new Object[]{id, configVO.getFmodelid()});
                        param = new Object[]{id, DB.genGlobalLongId(), configVO.getFmodelid(), configVO.getFconfig(), configVO.getFmodifytime(), configVO.getFmodifierid()};
                        sqlParam.add(param);
                    }
                });
            }
        });
        String deleteSql = "delete from t_epbs_param_set where fid=? and fmodelid=?";
        String insertSql = "insert into t_epbs_param_set (fid,fentryid,fmodelid,fparams,fmodifytime,fmodifierid) values (?,?,?,?,?,?)";
        String updateSql = "update t_epbs_param_set set fparams=?,fmodifytime=?,fmodifierid=? where fid=? and fmodelid=?";
        this.executeSql(DBRoute.of((String)CloudTypeEnum.EPM.name()), deleteSql, deleteSqlParam);
        this.executeSql(DBRoute.of((String)CloudTypeEnum.EPM.name()), insertSql, sqlParam);
        this.executeSql(DBRoute.of((String)CloudTypeEnum.EPM.name()), updateSql, updateSqlParam);
        return failedNumbers;
    }

    private Map<String, List<ConfigVO>> getNumber2Value(List<Long> modelIds, List<String> numbers) {
        List<Map<String, Object>> list = this.batchGetJsonAndConfigModifyTimeDesc(modelIds, numbers);
        HashSet<String> insertModelIds = new HashSet<String>(16);
        HashMap<String, List<ConfigVO>> number2Value = new HashMap<String, List<ConfigVO>>();
        for (Map<String, Object> row : list) {
            number2Value.putIfAbsent(row.get("number").toString(), new ArrayList());
            if (!insertModelIds.add(row.get("number") + "|" + row.get("model"))) continue;
            ((List)number2Value.get(row.get("number").toString())).add(new ConfigVO(LongUtil.toLong((Object)row.get("model")), (String)row.get("config"), (Long)row.get("modifier"), (Date)row.get("modifytime")));
        }
        return number2Value;
    }

    private boolean isSingleValueParam(String k) {
        PresetParamVO presetParamVO = this.epbsPresetParam.get(k);
        return PsDataTypeEnum.getByIndex((int)presetParamVO.getType()).isSingleParam();
    }

    private void executeSql(DBRoute dbRoute, String sql, List<Object[]> sqlParam) {
        if (CollectionUtils.isEmpty(sqlParam)) {
            return;
        }
        DB.executeBatch((DBRoute)dbRoute, (String)sql, sqlParam);
    }

    public void upgradeCustomForm(List<Long> modelIds) {
        this.upgradeCM005(modelIds);
        this.upgradeCM024(modelIds);
        this.upgradeCM018(modelIds);
        this.upgradeCM041(modelIds);
        this.upgradeCM034(modelIds);
        this.upgradeCM021(modelIds, "CM021");
        this.upgradeCM021(modelIds, "CM004");
        this.upgradeCM021(modelIds, "CM043");
        this.upgradeCM053(modelIds, "CM044");
        this.upgradeCM053(modelIds, "CM053");
        this.upgradeCM053(modelIds, "CM056");
    }

    public void batchUpdateEntry(List<Map<String, Object>> dataList, String number, Function<Map<String, Object>, ConfigVO> func) {
        if (CollectionUtils.isNotEmpty(dataList)) {
            HashSet modelIds = new HashSet(16);
            String sql = "INSERT INTO t_epbs_param_set(fid, fentryid, fseq, fmodelid, fparams,fmodifierid, fmodifytime) VALUES (?, ?, 0, ?, ?, ?, ?)";
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(10);
            ArrayList<Object[]> deleteParams = new ArrayList<Object[]>(10);
            long id = this.epbsPresetParam.get(number).getId();
            boolean isolate = this.epbsPresetParam.get(number).isIsolate();
            dataList.forEach(e -> {
                ConfigVO p = (ConfigVO)func.apply((Map<String, Object>)e);
                if (p != null && p.getFmodelid() != null && modelIds.add(p.getFmodelid()) && (isolate && p.getFmodelid() != 0L || !isolate && p.getFmodelid() == 0L)) {
                    ArrayList<Object> list = new ArrayList<Object>(10);
                    list.add(id);
                    list.add(GlobalIdUtil.genGlobalLongId());
                    list.add(p.getFmodelid());
                    list.add(p.getFconfig());
                    list.add(p.getFmodifierid());
                    list.add(p.getFmodifytime());
                    sqlParams.add(list.toArray());
                    deleteParams.add(new Object[]{id, p.getFmodelid()});
                }
            });
            this.executeSql(new DBRoute(CloudTypeEnum.EPM.name()), "delete from t_epbs_param_set where fid=? and fmodelid = ?", deleteParams);
            this.executeSql(new DBRoute(CloudTypeEnum.EPM.name()), sql, sqlParams);
        }
    }

    public void upgradeCM018(List<Long> modelIds) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM018");
        this.batchUpdateEntry(dataList, "CM018", data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("checkreport", (Object)this.checkIsBoolean((String)data.get("config")));
            String json = (String)data.get("json");
            String processSelection = StringUtils.isEmpty((String)json) ? "1" : JSONObjectUtil.parseObjectOrder((String)json).getString("processselection");
            jsonObject.put("processselection", (Object)processSelection);
            return new ConfigVO(LongUtil.toLong(data.get("model")), JSONUtils.toString((Object)jsonObject), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
        });
    }

    private boolean checkIsBoolean(String booleanConfig) {
        return "1".equals(booleanConfig) || "true".equals(booleanConfig) || ResManager.loadKDString((String)"\u662f", (String)"EpbsParamSetUpgradeServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]).equals(booleanConfig);
    }

    public void upgradeMoreCheckBox(List<Long> modelIds, List<String> numbers) {
        Map<String, String> map = this.getEPMPresetParam(numbers);
        for (String number : numbers) {
            List<Map<String, Object>> list = this.queryConfigFromAdjBizType(modelIds, number);
            Map<Long, List<Map>> groupByModelMap = list.stream().collect(Collectors.groupingBy(r -> (Long)r.get("model")));
            List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, number);
            this.batchUpdateEntry(dataList, number, data -> {
                String params = (String)map.get(number);
                List childrenList = (List)groupByModelMap.get(LongUtil.toLong(data.get("model")));
                if (childrenList != null && !childrenList.isEmpty()) {
                    HashMap<String, Boolean> businesstyMap = new HashMap<String, Boolean>(4);
                    for (Map objectMap : childrenList) {
                        String businessType = (String)data.get("businesstypevalue");
                        if (!StringUtils.isEmpty((String)businessType)) continue;
                        businesstyMap.put(businessType, (Boolean)objectMap.get("isshow"));
                    }
                    params = JSONUtils.toString(businesstyMap);
                }
                return new ConfigVO(LongUtil.toLong(data.get("model")), params, LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
            });
        }
    }

    public void upgradeCM005(List<Long> modelIds) {
        List<Map<String, Object>> list = this.queryConfigFromAdjBizType(modelIds, "CM005");
        List<Map<String, Object>> configDataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM005");
        HashMap modifyInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map<String, Object> rowData : configDataList) {
            modifyInfoMap.put(LongUtil.toLong((Object)rowData.get("model")), rowData);
        }
        Map<Long, List<Map>> groupByModelMap = list.stream().collect(Collectors.groupingBy(r -> (Long)r.get("model")));
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<Long, List<Map>> entry : groupByModelMap.entrySet()) {
            HashMap data2 = Maps.newHashMapWithExpectedSize((int)16);
            Long modelId = entry.getKey();
            Map modifyInfo = (Map)modifyInfoMap.get(modelId);
            if (modifyInfo == null || modifyInfo.get("modifier") == null || modifyInfo.get("modifytime") == null || entry.getValue().isEmpty()) continue;
            data2.put("model", modelId);
            data2.put("modifier", modifyInfo.get("modifier"));
            data2.put("modifytime", modifyInfo.get("modifytime"));
            List entryList = entry.getValue().stream().map(e -> {
                HashMap map = new HashMap(4);
                map.put("isshow", e.get("isshow"));
                HashMap nameMap = new HashMap(4);
                nameMap.put("zh_CN", e.get("showname"));
                map.put("showname", nameMap);
                map.put("businesstypevalue", e.get("businesstypevalue"));
                return map;
            }).collect(Collectors.toList());
            HashMap v = new HashMap(1);
            v.put("entryentity", entryList);
            data2.put("param", JSONUtils.toString(v));
            dataList.add(data2);
        }
        this.batchUpdateEntry(dataList, "CM005", data -> new ConfigVO(LongUtil.toLong(data.get("model")), (String)data.get("param"), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime")));
    }

    public void upgradeCommonForm(List<Long> modelIds) {
        this.upgradeCM032(modelIds);
        this.upgradeCM012(modelIds);
        this.upgradeCM047(modelIds);
        this.upgradeCM052(modelIds);
        this.upgradeCM030(modelIds);
        this.upgradeIsSupportNewMyTemplate(modelIds);
        this.upgradeMoreCheckBox(modelIds, Arrays.asList("CM003", "CM014", "CM049", "CM045"));
    }

    private void upgradeCM012(List<Long> modelIds) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM012");
        this.batchUpdateEntry(dataList, "CM012", data -> {
            String config = (String)data.get("config");
            String json = (String)data.get("json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("params", (Object)config);
            if (StringUtils.isNotEmpty((String)json)) {
                jsonObject.put("periodStatus", (Object)json);
            }
            return new ConfigVO(LongUtil.toLong(data.get("model")), jsonObject.toJSONString(), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
        });
    }

    private List<Map<String, Object>> getJsonAndConfigModifyTimeDesc(List<Long> modelIds, String number) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        if (modelIds.isEmpty()) {
            return dataList;
        }
        List idStrList = modelIds.stream().map(x -> x + "").collect(Collectors.toList());
        String sqlConfigSetting = "select fid,fmodelid,fnumber,fconfig,fjson,fmodifierid,fmodifytime,fdescriptioin,fignoredimensionlesreport,flinkcreatetype from t_bcm_configsetting where fmodelid in (" + String.join((CharSequence)",", idStrList) + ") and fnumber = '" + number + "' order by fmodifytime desc;";
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryConfigSetting", (DBRoute)BCMConstant.DBROUTE, (String)sqlConfigSetting);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                HashMap rowData = Maps.newHashMapWithExpectedSize((int)16);
                rowData.put("id", next.getLong("fid"));
                rowData.put("model", next.getLong("fmodelid"));
                rowData.put("number", next.getString("fnumber"));
                rowData.put("config", next.getString("fconfig"));
                rowData.put("json", next.getString("fjson"));
                rowData.put("modifier", next.getLong("fmodifierid"));
                rowData.put("modifytime", next.getDate("fmodifytime"));
                rowData.put("ignoredimensionlesreport", next.getBoolean("fignoredimensionlesreport"));
                rowData.put("linkcreatetype", next.getString("flinkcreatetype"));
                rowData.put("description", next.getString("fdescriptioin"));
                dataList.add(rowData);
            }
        }
        return dataList;
    }

    private List<Map<String, Object>> batchGetJsonAndConfigModifyTimeDesc(List<Long> modelIds, List<String> numbers) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        if (modelIds.isEmpty() || numbers.isEmpty()) {
            return dataList;
        }
        List idStrList = modelIds.stream().map(x -> x + "").collect(Collectors.toList());
        String sqlConfigSetting = "select fmodelid,fnumber,fconfig,fjson,fmodifierid,fmodifytime from t_bcm_configsetting where fmodelid in (" + String.join((CharSequence)",", idStrList) + ") and fnumber in ('" + String.join((CharSequence)"','", numbers) + "') order by fmodifytime desc;";
        try (DataSet queryDataSet = DB.queryDataSet((String)"batchQueryConfigSetting", (DBRoute)BCMConstant.DBROUTE, (String)sqlConfigSetting);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                HashMap rowData = Maps.newHashMapWithExpectedSize((int)16);
                rowData.put("model", next.getLong("fmodelid"));
                rowData.put("number", next.getString("fnumber"));
                rowData.put("config", next.getString("fconfig"));
                rowData.put("json", next.getString("fjson"));
                rowData.put("modifier", next.getLong("fmodifierid"));
                rowData.put("modifytime", next.getDate("fmodifytime"));
                dataList.add(rowData);
            }
        }
        return dataList;
    }

    private Map<String, String> getEPMPresetParam(List<String> numbers) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        ArrayList<HashMap> dataList = new ArrayList<HashMap>(10);
        if (numbers.isEmpty()) {
            return map;
        }
        String sql = "select fnumber,fdefaultparams from t_epbs_preset_param where fnumber in ('" + String.join((CharSequence)"','", numbers) + "');";
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryEPMParam", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                HashMap rowData = Maps.newHashMapWithExpectedSize((int)16);
                rowData.put("number", next.getString("fnumber"));
                rowData.put("defaultparams", next.getString("fdefaultparams"));
                dataList.add(rowData);
            }
        }
        dataList.forEach(dy -> map.put((String)dy.get("number"), (String)dy.get("defaultparams")));
        return map;
    }

    private List<Map<String, Object>> queryConfigFromAdjBizType(List<Long> modelIds, String number) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        if (modelIds.isEmpty()) {
            return dataList;
        }
        List idStrList = modelIds.stream().map(x -> x + "").collect(Collectors.toList());
        String masterSql = "select fid,fmodelid,fnumber from t_bcm_adjbiztypecfg where fmodelid in (" + String.join((CharSequence)",", idStrList) + ") and fnumber = '" + number + "';";
        ArrayList<String> masterFidList = new ArrayList<String>(10);
        HashMap fid2ModelMap = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryBCMAdjBizType", (DBRoute)BCMConstant.DBROUTE, (String)masterSql);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                masterFidList.add(next.getString("fid"));
                fid2ModelMap.put(next.getLong("fid"), next.getLong("fmodelid"));
            }
        }
        if (masterFidList.isEmpty()) {
            return dataList;
        }
        String childrenSql = "select fid,fentryid,fisshow,fbusinesstypevalue,fpresetname,fshowname from t_bcm_adjbiztypecfgentry where fid in (" + String.join((CharSequence)",", masterFidList) + ");";
        try (DataSet queryChiledrenDataSet = DB.queryDataSet((String)"queryBCMAdjBizTypeChildren", (DBRoute)BCMConstant.DBROUTE, (String)childrenSql);){
            while (queryChiledrenDataSet != null && queryChiledrenDataSet.hasNext()) {
                Row next = queryChiledrenDataSet.next();
                HashMap rowData = Maps.newHashMapWithExpectedSize((int)16);
                rowData.put("id", next.getLong("fid"));
                rowData.put("model", fid2ModelMap.get(next.getLong("fid")));
                rowData.put("entryid", next.getLong("fentryid"));
                rowData.put("isshow", next.getBoolean("fisshow"));
                rowData.put("businesstypevalue", next.getString("fbusinesstypevalue"));
                rowData.put("showname", next.getString("fshowname"));
                dataList.add(rowData);
            }
        }
        return dataList;
    }

    public void upgradeCM024(List<Long> modelIds) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM024");
        this.batchUpdateEntry(dataList, "CM024", data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("params", data.get("config"));
            jsonObject.put("ignoredimensionlesreport", data.get("ignoredimensionlesreport"));
            return new ConfigVO(LongUtil.toLong(data.get("model")), jsonObject.toJSONString(), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
        });
    }

    public void upgradeCM047(List<Long> modelIds) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM047");
        this.batchUpdateEntry(dataList, "CM047", data -> {
            JSONObject jsonObject = new JSONObject();
            if (StringUtils.isNotEmpty((String)((String)data.get("json")))) {
                JSONObject json = JSONObjectUtil.parseObjectOrder((String)((String)data.get("json")));
                jsonObject.put("config_num", (Object)json.getIntValue("config_num"));
            } else {
                jsonObject.put("config_num", (Object)1000);
            }
            return new ConfigVO(LongUtil.toLong(data.get("model")), jsonObject.toJSONString(), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
        });
    }

    public void upgradeCM032(List<Long> modelIds) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM032");
        this.batchUpdateEntry(dataList, "CM032", data -> {
            String value = (String)data.get("linkcreatetype");
            if (StringUtils.isEmpty((String)value)) {
                value = (String)data.get("config");
            }
            return new ConfigVO(LongUtil.toLong(data.get("model")), StringUtils.isNotEmpty((String)value) ? value : " ", LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
        });
    }

    private void upgradeCM041(List<Long> modelIds) {
        List<Map<String, Object>> list = this.queryConfigBCMFloatColor(modelIds, "CM041");
        List<Map<String, Object>> configDataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM041");
        HashMap modifyInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map<String, Object> rowData : configDataList) {
            modifyInfoMap.put(LongUtil.toLong((Object)rowData.get("model")), rowData);
        }
        Map<Long, List<Map>> groupByModelMap = list.stream().collect(Collectors.groupingBy(r -> (Long)r.get("model")));
        Map<String, String> epbsParamMap = this.getEPMPresetParam(Lists.newArrayList((Object[])new String[]{"CM041"}));
        String defaultCm041 = epbsParamMap.get("CM041");
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<Long, List<Map>> entry : groupByModelMap.entrySet()) {
            HashMap data2 = Maps.newHashMapWithExpectedSize((int)16);
            Long modelId = entry.getKey();
            Map modifyInfo = (Map)modifyInfoMap.get(modelId);
            if (modifyInfo != null && modifyInfo.get("modifier") != null && modifyInfo.get("modifytime") != null && !entry.getValue().isEmpty()) {
                data2.put("model", modelId);
                data2.put("modifier", modifyInfo.get("modifier"));
                data2.put("modifytime", modifyInfo.get("modifytime"));
                JSONObject jsonObject = JSON.parseObject((String)defaultCm041);
                jsonObject.put("config", modifyInfo.get("config"));
                for (Map objectMap : entry.getValue()) {
                    jsonObject.put("color" + objectMap.get("ictype"), objectMap.get("color"));
                }
                data2.put("param", jsonObject.toJSONString());
            }
            dataList.add(data2);
        }
        this.batchUpdateEntry(dataList, "CM041", data -> new ConfigVO(LongUtil.toLong(data.get("model")), (String)data.get("param"), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime")));
    }

    private List<Map<String, Object>> queryConfigBCMFloatColor(List<Long> modelIds, String number) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        if (modelIds.isEmpty()) {
            return dataList;
        }
        List idStrList = modelIds.stream().map(x -> x + "").collect(Collectors.toList());
        String masterSql = "select fid,fmodelid,fnumber from t_bcm_adjbiztypecfg where fmodelid in (" + String.join((CharSequence)",", idStrList) + ") and fnumber = '" + number + "';";
        ArrayList<String> masterFidList = new ArrayList<String>(10);
        HashMap fid2ModelMap = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryBCMAdjBizTypeForColor", (DBRoute)BCMConstant.DBROUTE, (String)masterSql);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                masterFidList.add(next.getString("fid"));
                fid2ModelMap.put(next.getLong("fid"), next.getLong("fmodelid"));
            }
        }
        if (masterFidList.isEmpty()) {
            return dataList;
        }
        String childrenSql = "select fid,fentryid,fisenable,fictype,fcolor from t_bcm_floatcolor where fid in (" + String.join((CharSequence)",", masterFidList) + ");";
        try (DataSet queryChiledrenDataSet = DB.queryDataSet((String)"queryBCMFloatColor", (DBRoute)BCMConstant.DBROUTE, (String)childrenSql);){
            while (queryChiledrenDataSet != null && queryChiledrenDataSet.hasNext()) {
                Row next = queryChiledrenDataSet.next();
                HashMap rowData = Maps.newHashMapWithExpectedSize((int)16);
                rowData.put("id", next.getLong("fid"));
                rowData.put("model", fid2ModelMap.get(next.getLong("fid")));
                rowData.put("entryid", next.getLong("fentryid"));
                rowData.put("isenable", next.getBoolean("fisenable"));
                rowData.put("ictype", next.getString("fictype"));
                rowData.put("color", next.getString("fcolor"));
                dataList.add(rowData);
            }
        }
        return dataList;
    }

    private void upgradeCM034(List<Long> modelIds) {
        Map<Long, Set<Long>> sceneIdMap = this.getCM034SceneIdSet(modelIds);
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM034");
        this.batchUpdateEntry(dataList, "CM034", data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("config", data.get("config"));
            jsonObject.put("scenario", sceneIdMap.get(LongUtil.toLong(data.get("id"))));
            return new ConfigVO(LongUtil.toLong(data.get("model")), jsonObject.toJSONString(), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
        });
    }

    private Map<Long, Set<Long>> getCM034SceneIdSet(List<Long> modelIds) {
        HashMap sceneIdMap = Maps.newHashMapWithExpectedSize((int)16);
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM034");
        Set masterIdSet = dataList.stream().map(r -> String.valueOf(r.get("id"))).collect(Collectors.toSet());
        if (masterIdSet.isEmpty()) {
            return sceneIdMap;
        }
        String masterSql = "select fid,fpkid,fbasedataid from t_bcm_exceptionscenario where fid in (" + String.join((CharSequence)",", masterIdSet) + ");";
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryBCMExceptScene", (DBRoute)BCMConstant.DBROUTE, (String)masterSql);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                Set sceneIdSet = sceneIdMap.getOrDefault(next.getLong("fid"), new HashSet(16));
                sceneIdSet.add(next.getLong("fbasedataid"));
                sceneIdMap.put(next.getLong("fid"), sceneIdSet);
            }
        }
        return sceneIdMap;
    }

    private void upgradeCM021(List<Long> modelIds, String configNumber) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, configNumber);
        Map<Long, List<Map<String, Object>>> paramMap = this.getConfigParamMap(modelIds);
        this.batchUpdateEntry(dataList, configNumber, data -> {
            List list = paramMap.getOrDefault(LongUtil.toLong(data.get("id")), new ArrayList(10));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("config", data.get("config"));
            jsonObject.put("entryentity", (Object)list);
            if (StringUtils.isNotEmpty((String)((String)data.get("json")))) {
                JSONObject jsonObject1 = JSON.parseObject((String)((String)data.get("json")));
                jsonObject.putAll((Map)jsonObject1);
            }
            return new ConfigVO(LongUtil.toLong(data.get("model")), jsonObject.toJSONString(), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifytime"));
        });
    }

    private Map<Long, List<Map<String, Object>>> getConfigParamMap(List<Long> modelIds) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM034");
        Set masterIdSet = dataList.stream().map(r -> String.valueOf(r.get("id"))).collect(Collectors.toSet());
        if (masterIdSet.isEmpty()) {
            return paramMap;
        }
        String masterSql = "select fid,fentryid,fbasetype,fmemberid,frangevalue from t_bcm_configparam where fid in (" + String.join((CharSequence)",", masterIdSet) + ");";
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryConfigParam", (DBRoute)BCMConstant.DBROUTE, (String)masterSql);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                List paramList = paramMap.getOrDefault(next.getLong("fid"), new ArrayList(10));
                HashMap param = Maps.newHashMapWithExpectedSize((int)16);
                param.put("entity", next.getLong("fmemberid"));
                param.put("basedatatype", next.getString("fbasetype"));
                param.put("rangevalue", next.getInteger("frangevalue"));
                paramList.add(param);
                paramMap.put(next.getLong("fid"), paramList);
            }
        }
        return paramMap;
    }

    public void upgradeExtendParam(List<Long> modelIds) {
        List<String> numbers = this.presetNumbers();
        ArrayList<HashMap> dataList = new ArrayList<HashMap>(10);
        if (modelIds.isEmpty() || numbers.isEmpty()) {
            return;
        }
        List idStrList = modelIds.stream().map(x -> x + "").collect(Collectors.toList());
        String sqlConfigSetting = "select fid,fmodelid,fnumber,fname,fconfig,fjson,fdescriptioin,fmodifierid,fmodifytime from t_bcm_configsetting where fisenable = '0' and fmodelid in (" + String.join((CharSequence)",", idStrList) + ") and fnumber not in ('" + String.join((CharSequence)"','", numbers) + "') order by fmodifytime desc";
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryOtherConfigSetting", (DBRoute)BCMConstant.DBROUTE, (String)sqlConfigSetting);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                HashMap rowData = Maps.newHashMapWithExpectedSize((int)16);
                rowData.put("id", next.getLong("fid"));
                rowData.put("model", next.getLong("fmodelid"));
                rowData.put("number", next.getString("fnumber"));
                rowData.put("name", next.getString("fname"));
                rowData.put("config", next.getString("fconfig"));
                rowData.put("json", next.getString("fjson"));
                rowData.put("modifier", next.getLong("fmodifierid"));
                rowData.put("modifytime", next.getDate("fmodifytime"));
                rowData.put("description", next.getString("fdescriptioin"));
                dataList.add(rowData);
            }
        }
        List<Map<String, Object>> newDys = dataList.stream().filter(row -> !numbers.contains(row.get("number").toString().trim())).collect(Collectors.toList());
        this.presetAndUpgrade(new HashMap<String, DynamicObject>(16), newDys);
    }

    private void presetAndUpgrade(Map<String, DynamicObject> modelMaps, List<Map<String, Object>> dys) {
        HashMap<String, ConfigVO> map = new HashMap<String, ConfigVO>(16);
        for (Map<String, Object> dy : dys) {
            DynamicObject[] number = (DynamicObject[])dy.get("number");
            if (map.containsKey(dy.get("model") + "|" + (String)number)) continue;
            map.put(dy.get("model") + "|" + dy.get("number"), new ConfigVO(LongUtil.toLong((Object)dy.get("model")), (String)dy.get("config"), (Long)dy.get("modifier"), (Date)dy.get("modifytime")));
            boolean isGlobal = LongUtil.toLong((Object)dy.get("model")) == 0L;
            DynamicObjectCollection entryEntity = modelMaps.computeIfAbsent((String)number, arg_0 -> this.lambda$presetAndUpgrade$27((String)number, dy, isGlobal, arg_0)).getDynamicObjectCollection("entryentity");
            if (isGlobal && LongUtil.toLong((Object)dy.get("model")) != 0L) continue;
            DynamicObject detail = isGlobal && CollectionUtils.isNotEmpty((Collection)entryEntity) ? (DynamicObject)entryEntity.get(0) : entryEntity.addNew();
            detail.set("model", dy.get("model"));
            detail.set("params", dy.get("config"));
        }
        DynamicObject[] saved = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])modelMaps.values().toArray(new DynamicObject[0]));
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        for (DynamicObject dy : saved) {
            DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                ConfigVO configVO = (ConfigVO)map.get(dynamicObject.getLong("model") + "|" + dy.getString("number"));
                if (configVO == null) continue;
                Object[] sqlParam = new Object[]{configVO.getFmodifierid(), configVO.getFmodifytime(), dynamicObject.getLong("id")};
                sqlParams.add(sqlParam);
            }
        }
        String updateModifierAndModifyTimeSql = "update t_epbs_param_set set fmodifierid=?, fmodifytime=? where fentryid=?";
        this.executeSql(DBRoute.of((String)CloudTypeEnum.EPM.name()), updateModifierAndModifyTimeSql, sqlParams);
    }

    public void upgradeAuditLog(List<Long> modelIds) {
        String configNumber = "EPM001";
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        if (modelIds.isEmpty()) {
            return;
        }
        List idStrList = modelIds.stream().map(x -> x + "").collect(Collectors.toList());
        String sqlConfigSetting = "select fid,fmodelid,fisopenauditlog,fmodifierid,fmodifydate from t_bcm_logsetting where fmodelid in (" + String.join((CharSequence)",", idStrList) + ");";
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryAuditLog", (DBRoute)BCMConstant.DBROUTE, (String)sqlConfigSetting);){
            while (queryDataSet != null && queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                HashMap rowData = Maps.newHashMapWithExpectedSize((int)16);
                rowData.put("id", next.getLong("fid"));
                rowData.put("model", next.getLong("fmodelid"));
                rowData.put("isopenauditlog", next.getBoolean("fisopenauditlog"));
                rowData.put("modifier", next.getLong("fmodifierid"));
                rowData.put("modifydate", next.getDate("fmodifydate"));
                dataList.add(rowData);
            }
        }
        this.batchUpdateEntry(dataList, configNumber, data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("opendatalog", data.get("isopenauditlog"));
            return new ConfigVO(LongUtil.toLong(data.get("model")), jsonObject.toJSONString(), LongUtil.toLong(data.get("modifier")), (Date)data.get("modifydate"));
        });
    }

    public void upgradeCM052(List<Long> modelIds) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM052");
        this.batchUpdateEntry(dataList, "CM052", data -> {
            String jsonStr = (String)data.get("json");
            JSONObject jsonObject = new JSONObject();
            if (StringUtils.isNotEmpty((String)jsonStr)) {
                JSONObject json = JSONObjectUtil.parseObjectOrder((String)jsonStr);
                jsonObject.put("config_num", (Object)json.getIntValue("config_num"));
            } else {
                jsonObject.put("config_num", (Object)-1);
            }
            return new ConfigVO(LongUtil.toLong(data.get("model")), JSONUtils.toString((Object)jsonObject), (Long)data.get("modifier"), (Date)data.get("modifytime"));
        });
    }

    public void upgradeCM053(List<Long> modelIds, String number) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, number);
        this.batchUpdateEntry(dataList, number, data -> {
            String jsonStr = (String)data.get("json");
            JSONObject json = new JSONObject();
            json.put("config", (Object)this.checkIsBoolean((String)data.get("config")));
            if (StringUtils.isNotEmpty((String)jsonStr)) {
                json.put("entryentity", (Object)JSONArray.parseArray((String)jsonStr));
            }
            return new ConfigVO(LongUtil.toLong(data.get("model")), JSONUtils.toString((Object)json), (Long)data.get("modifier"), (Date)data.get("modifytime"));
        });
    }

    public void upgradeCM030(List<Long> modelIds) {
        List<Map<String, Object>> dataList = this.getJsonAndConfigModifyTimeDesc(modelIds, "CM030");
        this.batchUpdateEntry(dataList, "CM030", data -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("config", (Object)this.checkIsBoolean((String)data.get("config")));
            jsonObject.put("ismerge", (Object)("0".equals(data.get("json")) ? "0" : "1"));
            return new ConfigVO(LongUtil.toLong(data.get("model")), JSONUtils.toString((Object)jsonObject), (Long)data.get("modifier"), (Date)data.get("modifytime"));
        });
    }

    private /* synthetic */ DynamicObject lambda$presetAndUpgrade$27(String number, Map dy, boolean isGlobal, String k) {
        ParamSettingModel ps = new ParamSettingModel();
        ps.setSys(false);
        ps.setNumber(number);
        ps.setName((ILocaleString)new LocaleString((String)dy.get("name")));
        String desc = (String)dy.get("description");
        ps.setDesc((ILocaleString)(desc == null ? new LocaleString("-") : new LocaleString(desc)));
        ps.setIsolate(!isGlobal);
        ps.setShow(true);
        ps.setNodes(this.treeIds);
        ps.setType(PsDataTypeEnum.TEXT);
        ps.setFormType(PsFormTypeEnum.COMMON.getIndex());
        ParamSetFormModel form = new ParamSetFormModel();
        ParamSetControl control = new ParamSetControl();
        control.setType(PsControlTypeEnum.TEXT.getIndex());
        form.setControls(Collections.singletonList(control));
        ps.setFormWithFormModel(form);
        ps.setParams("");
        return ps.genDynamicObject();
    }

    static class PresetParamVO {
        private long id;
        private int formType;
        private int type;
        private boolean isolate;
        private boolean sys;

        public PresetParamVO(long id, int formType, int type, boolean isolate, boolean sys) {
            this.id = id;
            this.formType = formType;
            this.type = type;
            this.isolate = isolate;
            this.sys = sys;
        }

        public long getId() {
            return this.id;
        }

        public int getFormType() {
            return this.formType;
        }

        public int getType() {
            return this.type;
        }

        public boolean isIsolate() {
            return this.isolate;
        }

        public boolean isSys() {
            return this.sys;
        }
    }

    static class ConfigVO {
        private String fconfig;
        private Long fmodelid;
        private Date fmodifytime;
        private Long fmodifierid;

        public ConfigVO(Long fmodelid, String fconfig, Long fmodifierid, Date fmodifytime) {
            this.fconfig = fconfig;
            this.fmodelid = fmodelid;
            this.fmodifytime = fmodifytime;
            this.fmodifierid = fmodifierid;
        }

        public String getFconfig() {
            return this.fconfig;
        }

        public Long getFmodelid() {
            return this.fmodelid;
        }

        public Date getFmodifytime() {
            return this.fmodifytime;
        }

        public Long getFmodifierid() {
            return this.fmodifierid;
        }
    }
}

