/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import org.apache.commons.collections.CollectionUtils;

public class AppendPermItemAuthUpgradeUtil {
    private static final Log logger = LogFactory.getLog(AppendPermItemAuthUpgradeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upgrade(List<Object[]> oldEntPerItem2NewMapList, StringBuilder pProcessInfo) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"bos/permissinon/AppendPermItemAuthUpgradeUtil");
            lock.lock();
            if (null == pProcessInfo) {
                pProcessInfo = new StringBuilder();
            }
            if (null == oldEntPerItem2NewMapList || oldEntPerItem2NewMapList.isEmpty()) {
                logger.info("AppendPermItemAuthUpgradeUtil.upgrade, oldEntPerItem2NewMapList is empty.");
                boolean bl = true;
                return bl;
            }
            for (int i = 0; i < oldEntPerItem2NewMapList.size(); ++i) {
                Object[] oldEntPerItem2NewMap = oldEntPerItem2NewMapList.get(i);
                if (null == oldEntPerItem2NewMap || Objects.equals(0, oldEntPerItem2NewMap.length)) {
                    logger.info("AppendPermItemAuthUpgradeUtil.upgrade, oldEntPerItem2NewMap is empty, i:{}", (Object)i);
                    continue;
                }
                Object oldEntNumObj = oldEntPerItem2NewMap[0];
                Object oldPermItemIdObj = oldEntPerItem2NewMap[1];
                Object newEntNumObj = oldEntPerItem2NewMap[2];
                Object newPermItemIdObj = oldEntPerItem2NewMap[3];
                if (Objects.isNull(newEntNumObj) || Objects.isNull(newPermItemIdObj)) {
                    logger.info("AppendPermItemAuthUpgradeUtil.upgrade, oldEntNumObj:{}, oldPermItemIdObj:{}, newEntNumObj:{}, newPermItemIdObj:{}", new Object[]{oldEntNumObj, oldPermItemIdObj, newEntNumObj, newPermItemIdObj});
                    continue;
                }
                String newEntNum = (String)newEntNumObj;
                String newPermItemId = (String)newPermItemIdObj;
                if (StringUtils.isEmpty((String)newEntNum) || StringUtils.isEmpty((String)newPermItemId)) {
                    logger.info("AppendPermItemAuthUpgradeUtil.upgrade, newEntNum or newPermItemId is empty, oldEntNumObj:{}, oldPermItemIdObj:{}, newEntNum:{}, newPermItemId:{}", new Object[]{oldEntNumObj, oldPermItemIdObj, newEntNum, newPermItemId});
                    continue;
                }
                Object threeStrategyEntryIdObj = Objects.equals(4, oldEntPerItem2NewMap.length) ? null : oldEntPerItem2NewMap[4];
                Object[] threeStrategyEntryIdArr = Objects.isNull(threeStrategyEntryIdObj) ? new Long[]{} : (Long[])threeStrategyEntryIdObj;
                String oldEntNum = Objects.isNull(oldEntNumObj) ? "" : (String)oldEntNumObj;
                String oldPermItemId = Objects.isNull(oldPermItemIdObj) ? "" : (String)oldPermItemIdObj;
                try (TXHandle h = TX.requiresNew();){
                    try {
                        if (null != threeStrategyEntryIdArr && threeStrategyEntryIdArr.length > 0 && StringUtils.isNotEmpty((String)newEntNum) && StringUtils.isNotEmpty((String)newPermItemId)) {
                            AppendPermItemAuthUpgradeUtil.appendAdminSchemeDetail((Long[])threeStrategyEntryIdArr, newEntNum, newPermItemId);
                        }
                        if (!StringUtils.isNotEmpty((String)oldEntNum) || !StringUtils.isNotEmpty((String)oldPermItemId) || !StringUtils.isNotEmpty((String)newEntNum) || !StringUtils.isNotEmpty((String)newPermItemId)) continue;
                        Map oldEntNumAppIdMap = FormHelper.getAppIdByFormNum((List)Lists.newArrayList((Object[])new String[]{oldEntNum}));
                        String oldAppId = (String)oldEntNumAppIdMap.get(oldEntNum);
                        Map newEntNumAppIdMap = FormHelper.getAppIdByFormNum((List)Lists.newArrayList((Object[])new String[]{newEntNum}));
                        String newAppId = (String)newEntNumAppIdMap.get(newEntNum);
                        if (StringUtils.isNotEmpty((String)oldAppId) && StringUtils.isNotEmpty((String)newAppId) && !Objects.equals(oldAppId, newAppId)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u65e7\u8868\u5355\u4e0e\u65b0\u8868\u5355\u6240\u5c5e\u5e94\u7528\u4e0d\u4e00\u81f4\u3002", (String)"OLDAPPID_NOT_THE_SAME_NEWAPPID", (String)"bos-permission-cache", (Object[])new Object[0]));
                        }
                        AppendPermItemAuthUpgradeUtil.copyPermForAdmingroupFunperm(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermItemAuthUpgradeUtil.copyPermForUserPermDetail(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermItemAuthUpgradeUtil.copyPermForDisFunPerm(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermItemAuthUpgradeUtil.copyPermForRolePermDetail(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermItemAuthUpgradeUtil.copyPermForBizRolePerm(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        AppendPermItemAuthUpgradeUtil.copyPermForBizRoleDisPerm(oldEntNum, newEntNum, oldPermItemId, newPermItemId);
                        continue;
                    }
                    catch (Exception e) {
                        String errInfo = String.format(ResManager.loadKDString((String)"\u3010\u8ffd\u52a0\u6743\u9650\u9879\u6388\u6743\u3011\u5347\u7ea7\u5f02\u5e38\uff0coldEntNum\uff1a%1$s\uff0coldPermItemId\uff1a%2$s\uff0cnewEntNum\uff1a%3$s\uff0cnewPermItemId\uff1a%4$s\uff0cthreeStrategyEntryIdArr\uff1a%5$s\uff0c%6$s", (String)"AppendPermItemAuthUpgradeUtil_1", (String)"bos-permission-cache", (Object[])new Object[0]), oldEntNum, oldPermItemId, newEntNum, newPermItemId, Arrays.toString(threeStrategyEntryIdArr), e.getMessage());
                        logger.error(errInfo, (Throwable)e);
                        h.markRollback();
                        pProcessInfo.append(errInfo);
                        OPDescMultiLangEnumBridge bridge = new OPDescMultiLangEnumBridge("\u3010\u8ffd\u52a0\u6743\u9650\u9879\u6388\u6743\u3011\u5347\u7ea7\u5f02\u5e38\uff0coldEntNum\uff1a%1$s\uff0coldPermItemId\uff1a%2$s\uff0cnewEntNum\uff1a%3$s\uff0cnewPermItemId\uff1a%4$s\uff0cthreeStrategyEntryIdArr\uff1a%5$s\uff0c%6$s", "AppendPermItemAuthUpgradeUtil_1", "bos-permission-cache", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{oldEntNum, oldPermItemId, newEntNum, newPermItemId, Arrays.toString(threeStrategyEntryIdArr), e.getMessage()}));
                        AppendPermItemAuthUpgradeUtil.addOperLog(errInfo, bridge);
                        throw e;
                    }
                }
            }
        }
        finally {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            if (null != lock) {
                lock.unlock();
            }
        }
        return true;
    }

    private static void appendAdminSchemeDetail(Long[] threeStrategyEntryIdArr, String newEntNum, String ... newPermItemIds) {
        final HashMap<String, String> appEntMap = new HashMap<String, String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fnumber, a.fbizappid");
        sb.append(" from t_meta_entitydesign a ");
        sb.append(" inner join t_meta_bizapp b on a.fbizappid = b.fid");
        HashSet cloudSet = Sets.newHashSet((Object[])new String[]{"0QLCSO6KKZC9", "83bfebc800000bac"});
        String cloudSetStr = String.join((CharSequence)"','", cloudSet);
        sb.append(" where b.fbizcloudid in ('").append(cloudSetStr).append("')");
        sb.append(" and a.fnumber = ? ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{newEntNum}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String fbizappid = rs.getString("fbizappid");
                    String fnumber = rs.getString("fnumber");
                    if (StringUtils.isEmpty((String)fbizappid) || StringUtils.isEmpty((String)fnumber)) continue;
                    appEntMap.put(fbizappid, fnumber);
                }
                return null;
            }
        });
        if (null == appEntMap || appEntMap.isEmpty()) {
            return;
        }
        Set<String> exist = AppendPermItemAuthUpgradeUtil.queryForAdminSchemeDetail(threeStrategyEntryIdArr, appEntMap, newPermItemIds);
        int size = threeStrategyEntryIdArr.length * appEntMap.size() * newPermItemIds.length - exist.size();
        long[] detailIds = DB.genLongIds((String)"t_perm_adminschemedetail", (int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        int idx = 0;
        for (Long threeStrategyEntryId : threeStrategyEntryIdArr) {
            for (String newPermItemId : newPermItemIds) {
                for (Map.Entry appEnt : appEntMap.entrySet()) {
                    String appId = (String)appEnt.getKey();
                    String entNum = (String)appEnt.getValue();
                    String unique = threeStrategyEntryId + "_" + appId + "_" + entNum + "_" + newPermItemId;
                    if (exist.contains(unique)) continue;
                    paramList.add(new Object[]{threeStrategyEntryId, detailIds[idx], 0, appId, entNum, newPermItemId});
                    ++idx;
                }
            }
        }
        String sql = "insert into t_perm_adminschemedetail (fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid) values(?, ?, ?, ?, ?, ?)";
        SqlUtil.syncInsert(paramList, (String)sql, (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.base, (boolean)true);
    }

    private static Set<String> queryForAdminSchemeDetail(Long[] threeStrategyEntryIdArr, Map<String, String> appEntMap, String[] newPermItemIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid from t_perm_adminschemedetail where 1=1 ", new Object[0]);
        sqlBuilder.appendIn(" and fentryid", (Object[])threeStrategyEntryIdArr);
        sqlBuilder.appendIn(" and fbizappid", (Object[])appEntMap.keySet().toArray(new String[appEntMap.size()]));
        sqlBuilder.appendIn(" and fentitynum", (Object[])appEntMap.values().toArray(new String[appEntMap.size()]));
        sqlBuilder.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> exist = new HashSet<String>(8);
                while (rs.next()) {
                    exist.add(rs.getObject("fentryid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
                }
                return exist;
            }
        });
    }

    private static void copyPermForBizRoleDisPerm(String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermItemAuthUpgradeUtil.queryForBizRoleDisPerm(oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermItemAuthUpgradeUtil.existForBizRoleDisPerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
        AppendPermItemAuthUpgradeUtil.insertForBizRoleDisPerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
    }

    private static void insertForBizRoleDisPerm(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String[] newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_bizroledisperm");
        insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
        insertSql.append(" VALUES(?,?,?,?,?,?);");
        long[] entryIds = DB.genLongIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(count * newPermItemIds.length);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + row.get("fbizappid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, row.get("fbizappid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static int existForBizRoleDisPerm(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static DataSet queryForBizRoleDisPerm(String oldEntityTypeId, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForBizRoleDisPerm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static void copyPermForBizRolePerm(String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermItemAuthUpgradeUtil.queryForBizRolePerm(oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermItemAuthUpgradeUtil.existForBizRolePerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
        AppendPermItemAuthUpgradeUtil.insertForBizRolePerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
    }

    private static void insertForBizRolePerm(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String[] newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_bizroleperm");
        insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
        insertSql.append(" VALUES(?,?,?,?,?,?);");
        long[] entryIds = DB.genLongIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + row.get("fbizappid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, row.get("fbizappid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static int existForBizRolePerm(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static DataSet queryForBizRolePerm(String oldEntityTypeId, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static void copyPermForDisFunPerm(String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermItemAuthUpgradeUtil.queryForDisFunPerm(oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermItemAuthUpgradeUtil.existForDisFunPerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
        AppendPermItemAuthUpgradeUtil.insertForUserRoleDisFunPerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
    }

    private static void insertForUserRoleDisFunPerm(Set<String> exist, DataSet copy, int count, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_disfunperm");
        insertSql.append(" (fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : copy) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + row.get("forgid") + "_" + row.get("fbizappid") + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("fdimtype") + "_" + row.get("fisincludesuborg");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{ids[index++], row.get("fuserid"), row.get("forgid"), newPermItemId, newEntityTypeId, row.get("fentryid"), row.get("ffrom"), row.get("fbizappid"), row.get("fsource"), row.get("fbizroleid"), row.get("fdimtype"), row.get("fisincludesuborg")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static DataSet queryForDisFunPerm(String oldEntityTypeId, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg from t_perm_disfunperm ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForDisFunPerm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static int existForDisFunPerm(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>(8);
        HashSet<Object> orgIds = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            orgIds.add(row.get("forgid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,forgid,fbizappid,fentitytypeid,fpermitemid,fdimtype,fisincludesuborg from t_perm_disfunperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            existSql.appendIn(" and forgid ", orgIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fuserid") + "_" + rs.getObject("forgid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesuborg"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void copyPermForRolePermDetail(String oldEntityTypeId, String newEntityTypeId, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermItemAuthUpgradeUtil.queryForRolePermDetail(oldEntityTypeId, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermItemAuthUpgradeUtil.existForRolePermDetail(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
        AppendPermItemAuthUpgradeUtil.insertForUserRolePermDetail(exist, dataSet, count, newEntityTypeId, newPermItemIds);
    }

    private static DataSet queryForRolePermDetail(String oldEntityTypeId, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid from t_perm_rolepermdetial ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForRolePermDetail", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static int existForRolePermDetail(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        HashSet<Object> roleIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            bizAppIds.add(row.get("fbizappid"));
            roleIds.add(row.get("froleid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fbizappid,fentitytypeid,fpermitemid,froleid from t_perm_rolepermdetial", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        if (!CollectionUtils.isEmpty(roleIds)) {
            existSql.appendIn(" and froleid", roleIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("froleid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForUserRolePermDetail(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_rolepermdetial");
        insertSql.append(" (fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?);");
        String[] entryIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fbizappid") + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("froleid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), entryIds[index++], row.get("fseq"), row.get("fcontrolmode"), newPermItemId, row.get("finheritmode"), newEntityTypeId, row.get("fbizappid"), row.get("froleid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static void copyPermForUserPermDetail(String oldEntNum, String newEntNum, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermItemAuthUpgradeUtil.queryForUserPermDetail(oldEntNum, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermItemAuthUpgradeUtil.existForUserPermDetail(exist, dataSet.copy(), newEntNum, newPermItemIds);
        AppendPermItemAuthUpgradeUtil.insertForUserPermDetail(exist, dataSet, count, newEntNum, newPermItemIds);
    }

    private static DataSet queryForUserPermDetail(String oldEntNum, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid from t_perm_userpermdetail ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldEntNum, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForUserPermDetail", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static int existForUserPermDetail(final Set<String> exist, DataSet dataSet, String newEntNum, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        HashSet<Object> dimIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            bizAppIds.add(row.get("fbizappid"));
            dimIds.add(row.get("fdimid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,fbizappid,fentitytypeid,fpermitemid,fdimid,fdimtype,fisincludesub from t_perm_userpermdetail", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntNum});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and  fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        if (!CollectionUtils.isEmpty(dimIds)) {
            existSql.appendIn(" and fdimid ", dimIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fuserid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesub"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForUserPermDetail(Set<String> exist, DataSet dataSet, int count, String newEntNum, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_userpermdetail");
        insertSql.append(" (fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_userpermdetail", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + row.get("fbizappid") + "_" + newEntNum + "_" + newPermItemId + "_" + row.get("fdimid") + "_" + row.get("fdimtype") + "_" + row.get("fisincludesub");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), row.get("fuserid"), row.get("fdimtype"), row.get("fdimid"), row.get("fisincludesub"), String.valueOf(entryIds[index++]), row.get("fseq"), row.get("fcontrolmode"), newPermItemId, newEntNum, row.get("fbizappid"), row.get("fsource"), row.get("fbizroleid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static void copyPermForAdmingroupFunperm(String oldEntNum, String newEntNum, String oldPermItemId, String ... newPermItemIds) {
        DataSet dataSet = AppendPermItemAuthUpgradeUtil.queryForAdmingroupFunperm(oldEntNum, oldPermItemId);
        HashSet<String> exist = new HashSet<String>(8);
        int count = AppendPermItemAuthUpgradeUtil.existForAdmingroupFunperm(exist, dataSet.copy(), newEntNum, newPermItemIds);
        AppendPermItemAuthUpgradeUtil.insertForAdmingroupFunperm(exist, dataSet, count, newEntNum, newPermItemIds);
    }

    private static DataSet queryForAdmingroupFunperm(String oldEntNum, String oldPermItemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fusergroupid, fappid, fentitynum, fpermitemid from t_perm_admingroupfunperm ");
        querySql.append(" where fentitynum = ?");
        querySql.append(" and fpermitemid = ? ");
        Object[] queryParam = new Object[]{oldEntNum, oldPermItemId};
        DataSet dataSet = DB.queryDataSet((String)"AppendPermItemAuthUpgradeUtil#queryForAdmingroupFunperm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
        return dataSet;
    }

    private static int existForAdmingroupFunperm(final Set<String> exist, DataSet dataSet, String newEntNum, String ... newPermItemIds) {
        HashSet<Object> usrgrpIds = new HashSet<Object>(8);
        HashSet<Object> bizAppIds = new HashSet<Object>(8);
        int count = 0;
        for (Row row : dataSet) {
            usrgrpIds.add(row.get("fusergroupid"));
            bizAppIds.add(row.get("fappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fusergroupid, fappid, fentitynum, fpermitemid from t_perm_admingroupfunperm", new Object[0]);
        existSql.append(" where fentitynum = ?", new Object[]{newEntNum});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(usrgrpIds)) {
            existSql.appendIn(" and  fusergroupid ", usrgrpIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fusergroupid") + "_" + rs.getObject("fappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
                }
                return exist;
            }
        });
        return count;
    }

    private static void insertForAdmingroupFunperm(Set<String> exist, DataSet dataSet, int count, String newEntNum, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_admingroupfunperm");
        insertSql.append(" (fid, fusergroupid, fappid, fpermitemid, fentitynum)");
        insertSql.append(" VALUES(?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_admingroupfunperm", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fusergroupid") + "_" + row.get("fappid") + "_" + newEntNum + "_" + newPermItemId;
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fusergroupid"), row.get("fappid"), newPermItemId, newEntNum};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private static void addOperLog(String procInfo, OPDescMultiLangEnumBridge descBridge) {
        AppLogInfo appLogInfo = OperationLogUtil.createLogInfo();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        appLogInfo.setUserID(userId);
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(TimeServiceHelper.now());
        if (OperationLogUtil.isUseOpLog()) {
            OperationLogUtil.setOpName(appLogInfo, new OpNameMultiLangEnumBridge("\u3010\u8ffd\u52a0\u6743\u9650\u9879\u6388\u6743\u3011\u5347\u7ea7", "AppendPermItemAuthUpgradeUtil_2", "bos-permission-cache", "Permission upgrade"));
            OperationLogUtil.setOpDesc(appLogInfo, procInfo, descBridge);
        }
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }
}

