/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import org.apache.commons.lang3.StringUtils;

public class AssoStorageMemUtil {
    public static final String assoMembInModel = "assoMembInModel";
    public static final List<String> ENTITY_NAMES = Arrays.asList("bcm_accountmembertree", "bcm_icmembertree", "bcm_userdefinedmembertree", "bcm_processmembertree", "bcm_audittrialmembertree", "bcm_mycompanymembertree", "bcm_rulemembertree");

    public static Map<String, List<Object>> getDataTypeByMem(DynamicObject dynamicObject) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
        String datatype = dynamicObject.getString("datatype");
        List<Object> defaultType = Arrays.asList("0", "1");
        String numerType = "2";
        String textType = "3";
        String dateType = "4";
        String rateType = "5";
        QFilter qf = new QFilter("dimension", "=", (Object)dynamicObject.getLong("dimension"));
        DynamicObjectCollection enumItems = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id, datatype", (QFilter[])qf.toArray());
        Map<Long, String> euId2Dts = enumItems.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("datatype"), (v1, v2) -> v1));
        HashMap dt2Ids = new HashMap(16);
        enumItems.forEach(x -> {
            List ids = dt2Ids.computeIfAbsent(x.getString("datatype"), k -> new ArrayList(10));
            ids.add(x.getLong("id"));
        });
        if (DataTypeEnum.ENUMTP.index.equals(datatype)) {
            datatype = euId2Dts.get(dynamicObject.getLong("enumitem"));
        }
        if (defaultType.contains(datatype)) {
            map.put("datatype", defaultType);
            map.put("edatatype", (List<Object>)dt2Ids.get("1"));
        } else if (DataTypeEnum.UNCURRENCY.index.equals(datatype)) {
            map.put("datatype", Collections.singletonList(numerType));
            map.put("edatatype", (List<Object>)dt2Ids.get(numerType));
        } else if (DataTypeEnum.TXT.index.equals(datatype)) {
            map.put("datatype", Collections.singletonList(textType));
            map.put("edatatype", (List<Object>)dt2Ids.get(textType));
        } else if (DataTypeEnum.DATETP.index.equals(datatype)) {
            map.put("datatype", Collections.singletonList(dateType));
            map.put("edatatype", (List<Object>)dt2Ids.get(dateType));
        } else if (DataTypeEnum.PROPORTION.index.equals(datatype)) {
            map.put("datatype", Collections.singletonList(rateType));
            map.put("edatatype", (List<Object>)dt2Ids.get(rateType));
        }
        return map;
    }

    public static Table<String, String, String> getAllAssoMembers(String modelNum) {
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        return AssoStorageMemUtil.getAllAssoMembers(modelId);
    }

    public static Table<String, String, String> getAllAssoMembersExcludeOrg(String modelNum, String org) {
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Table<String, String, String> assoMemMap = AssoStorageMemUtil.getAllAssoMembers(modelId);
        if (!StringUtils.isEmpty((CharSequence)org)) {
            String orgRealNum;
            Pair isOpen2ExtOrgs = (Pair)ThreadCache.get((Object)"isOpen2ExtOrgs", () -> ConfigServiceHelper.getCfgWithExpOrg(modelId, "CM043"));
            if (ConfigServiceHelper.resolverConfigParam(isOpen2ExtOrgs.p1) && ((Set)isOpen2ExtOrgs.p2).contains(orgRealNum = (String)ThreadCache.get((Object)("on" + org), () -> MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)org).getNumber()))) {
                HashBasedTable newAssoMemMap = HashBasedTable.create();
                if (assoMemMap.row((Object)DimTypesEnum.MYCOMPANY.getNumber()) != null) {
                    for (Map.Entry entry : assoMemMap.row((Object)DimTypesEnum.MYCOMPANY.getNumber()).entrySet()) {
                        newAssoMemMap.put((Object)DimTypesEnum.MYCOMPANY.getNumber(), entry.getKey(), entry.getValue());
                    }
                }
                return newAssoMemMap;
            }
        }
        return assoMemMap;
    }

    public static Table<String, String, String> getAllAssoMembers(long modelId) {
        HashBasedTable assoMemMap = HashBasedTable.create();
        if (!ConfigServiceHelper.getBoolParam(modelId, "CM043")) {
            return assoMemMap;
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("membermodel", "in", ENTITY_NAMES);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,membermodel", (QFilter[])qf.toArray());
        if (CollectionUtils.isEmpty((Collection)dims)) {
            return assoMemMap;
        }
        dims.forEach(arg_0 -> AssoStorageMemUtil.lambda$getAllAssoMembers$8(modelId, (Table)assoMemMap, arg_0));
        return assoMemMap;
    }

    public static Map<String, String> getAssoByDim(long modelId, long dimId, String entityName) {
        return (Map)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("getAssoByDim_" + modelId + "_" + dimId), () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("dimension", "=", (Object)dimId));
            filter.and(new QFilter("assostoremem", "!=", (Object)0L));
            DynamicObjectCollection docs = QueryServiceHelper.query((String)entityName, (String)"number,assostoremem.number", (QFilter[])filter.toArray());
            HashMap assoMaps = new HashMap(docs.size());
            docs.forEach(d -> assoMaps.put(d.getString("number"), d.getString("assostoremem.number")));
            return assoMaps;
        });
    }

    private static /* synthetic */ void lambda$getAllAssoMembers$8(long modelId, Table assoMemMap, DynamicObject dim) {
        Map<String, String> assoMaps = AssoStorageMemUtil.getAssoByDim(modelId, dim.getLong("id"), dim.getString("membermodel"));
        assoMaps.forEach((k, v) -> {
            if (StringUtils.isNotEmpty((CharSequence)k) && StringUtils.isNotEmpty((CharSequence)v)) {
                assoMemMap.put((Object)dim.getString("number"), k, v);
            }
        });
    }
}

