/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.function.Consumer;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;

public class BcmDLockUtil {
    public static long reportEntityWaitTime = 5000L;
    public static String OPENREPORT = "BDU.OR";
    public static String CAN = "BDU.CAN";
    public static String OPENREPORTWHENSAVE = "BDU.ORWS";

    public static void lockReportEntity(Object modelId, Object sceneId, Object yearId, Object periodId, Object currencyId, Object entityId, Consumer<DLock> operation) {
        String reportLock = BcmDLockUtil.getReportLockKey(modelId, sceneId, yearId, periodId, currencyId, entityId);
        DLock lock = DLock.create((String)reportLock).fastMode();
        if (lock.tryLock(reportEntityWaitTime)) {
            try {
                operation.accept(lock);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static String getReportLockKey(Object modelId, Object sceneId, Object yearId, Object periodId, Object currencyId, Object entityId) {
        return String.format("bcm/reportLock/%s/%s/%s/%s/%s/%s", modelId, sceneId, yearId, periodId, currencyId, entityId);
    }

    public static String getSolutionLockKey(Object modelId, Object solution) {
        return String.format("bcm/solutionLock/%s/%s ", modelId, solution);
    }

    public static void lockOpenReport(String key) {
        AppCacheServiceHelper.put(OPENREPORT + key, true);
    }

    public static boolean tryOpenReport(String key) {
        return AppCacheServiceHelper.get(OPENREPORT + key) == null;
    }

    public static void canUnlockOpenReport(String key) {
        AppCacheServiceHelper.put(CAN + OPENREPORT + key, true);
    }

    public static void unLockOpenReport(String key) {
        AppCacheServiceHelper.remove(OPENREPORT + key);
    }

    public static void lockOpenReportWhenSave(String key) {
        AppCacheServiceHelper.put(OPENREPORTWHENSAVE + key, true);
    }

    public static boolean tryOpenReportWhenSave(String key) {
        return AppCacheServiceHelper.get(OPENREPORTWHENSAVE + key) == null;
    }

    public static void unLockOpenReportWhenSave(String key) {
        AppCacheServiceHelper.remove(OPENREPORTWHENSAVE + key);
    }
}

