/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BcmDMLServiceHelper {
    private static final Log log = LogFactory.getLog(BcmDMLServiceHelper.class);
    private static final int DEFAULT_SIZE = 2000;
    private static final int EMPTY_VALUE = 0;

    public static void batchSave(List<DynamicObject> dys) {
        BcmDMLServiceHelper.batchSave(dys, 0);
    }

    public static void batchDelete(String entityName, List<Object> ids, String filterFiled) {
        BcmDMLServiceHelper.batchDelete(entityName, ids, filterFiled, 0);
    }

    public static void batchSave(List<DynamicObject> dys, int expectedSize) {
        if (CollectionUtils.isEmpty(dys)) {
            return;
        }
        int size = expectedSize > 0 ? expectedSize : 2000;
        int times = dys.size() / size + 1;
        try (TXHandle tx = TX.required();){
            try {
                for (int i = 0; i < times; ++i) {
                    List<DynamicObject> newDysList = dys.subList(i * size, Math.min((i + 1) * size, dys.size()));
                    if (CollectionUtils.isEmpty(newDysList)) {
                        break;
                    }
                    SaveServiceHelper.save((DynamicObject[])newDysList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static <T> void batchDelete(String entityName, List<T> dys, String filterFiled, int expectedSize) {
        if (CollectionUtils.isEmpty(dys)) {
            return;
        }
        int size = expectedSize > 0 ? expectedSize : 2000;
        int times = dys.size() / size + 1;
        try (TXHandle tx = TX.required();){
            try {
                for (int i = 0; i < times; ++i) {
                    List<T> newDysList = dys.subList(i * size, Math.min((i + 1) * size, dys.size()));
                    if (CollectionUtils.isEmpty(newDysList)) {
                        break;
                    }
                    DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(filterFiled, "in", newDysList)});
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

