/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.thread.IHook;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.DefaultPageDimSettingUtil;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PageDimSelectTypeEnum;
import kd.fi.bcm.common.exception.NotificationException;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.exception.EvalException;
import org.apache.commons.collections.CollectionUtils;

public class DataCollectUtil {
    public static void saveDataCollects(List<DynamicObject> list) {
        if (!list.isEmpty()) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(10);
            for (DynamicObject dynamicObject : list) {
                if (dynamicObject.getLong("id") == 0L) {
                    newList.add(dynamicObject);
                    continue;
                }
                updateList.add(dynamicObject);
            }
            if (newList.size() > 0) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)newList.get(0)).getDataEntityType(), (Object[])newList.toArray());
            }
            if (updateList.size() > 0) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateList.get(0)).getDataEntityType(), (Object[])updateList.toArray());
            }
        }
    }

    public static Map<String, String> getTemplateVewPage(long templateId) {
        TemplateModel model = TemplateServiceHelper.getTemplateModelById(templateId);
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (model != null) {
            List<PageDimensionEntry> pageDimension;
            List<ViewPointDimensionEntry> viewDimension = model.getViewPointDimensionEntries();
            if (!viewDimension.isEmpty()) {
                for (ViewPointDimensionEntry dimEntry : viewDimension) {
                    if (null == dimEntry.getMember()) continue;
                    String memNum = dimEntry.getMember().getNumber();
                    map.put(dimEntry.getDimension().getNumber(), memNum);
                }
            }
            if (!(pageDimension = model.getPageDimensionEntries()).isEmpty()) {
                for (PageDimensionEntry dimEntry : pageDimension) {
                    String dimnum = dimEntry.getDimension().getNumber();
                    map.put(dimnum, null);
                    if (!DimTypesEnum.CHANGETYPE.getNumber().equals(dimnum) || dimEntry.getMembers().size() <= 0) continue;
                    String memNum = dimEntry.getMembers().get(0).getNumber();
                    map.put(dimnum, memNum);
                }
            }
        }
        return map;
    }

    public static Map<Long, Map<String, String>> collectPageSelect(String modelNum, String orgNum, List<Long> allExcuteTempIds) {
        HashMap<Long, Map<String, String>> comMemMaps = new HashMap<Long, Map<String, String>>(16);
        Map dimShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
        Map<String, String> dimNum2shortNum = dimShortNumber2NumberMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getValue(), e -> (String)e.getKey()));
        long orgId = MemberReader.findEntityMemberByNum((String)modelNum, (String)orgNum).getId();
        DynamicObjectCollection pageDimSetting = DefaultPageDimSettingUtil.getPageDimSetting(allExcuteTempIds, Sets.newHashSet((Object[])new Long[]{orgId}), null, PageDimSelectTypeEnum.PAGEDIM.index);
        HashMap tempPageSelectMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty((Collection)pageDimSetting)) {
            boolean isExitOrgSetting = pageDimSetting.stream().anyMatch(e -> e.getLong("org.id") != 0L);
            pageDimSetting.forEach(dy -> {
                long templateId = dy.getLong("template.id");
                if (!isExitOrgSetting || isExitOrgSetting && dy.getLong("org.id") != 0L) {
                    if (tempPageSelectMap.get(templateId) == null) {
                        tempPageSelectMap.put(templateId, new ArrayList(16));
                    }
                    ((List)tempPageSelectMap.get(templateId)).add(dy);
                }
            });
        }
        for (long templateId : allExcuteTempIds) {
            Map<String, String> map = DataCollectUtil.getTemplateVewPage(templateId);
            HashMap<String, String> orgTemMap = new HashMap<String, String>(map);
            if (CollectionUtils.isNotEmpty((Collection)((Collection)tempPageSelectMap.get(templateId)))) {
                for (DynamicObject dy2 : (List)tempPageSelectMap.get(templateId)) {
                    if (dy2.getString("member") == null) continue;
                    String dimnum = dy2.getString("dimension.number");
                    String memnum = DataCollectUtil.getDefautMem(modelNum, dimnum, dy2.getLong("member")).getNumber();
                    orgTemMap.put(dimnum, memnum);
                }
            } else {
                Set set = orgTemMap.entrySet();
                for (Map.Entry entry : set) {
                    if (entry.getValue() != null) continue;
                    if (DimTypesEnum.PROCESS.getNumber().equals(entry.getKey())) {
                        orgTemMap.put((String)entry.getKey(), "EIRpt");
                        continue;
                    }
                    if (DimTypesEnum.AUDITTRIAL.getNumber().equals(entry.getKey())) {
                        orgTemMap.put((String)entry.getKey(), "EntityInput");
                        continue;
                    }
                    if (DimTypesEnum.MULTIGAAP.getNumber().equals(entry.getKey())) {
                        orgTemMap.put((String)entry.getKey(), "PRCGAAP");
                        continue;
                    }
                    if (DimTypesEnum.DATASORT.getNumber().equals(entry.getKey())) {
                        orgTemMap.put((String)entry.getKey(), "Actual");
                        continue;
                    }
                    if (DimTypesEnum.CURRENCY.getNumber().equals(entry.getKey())) {
                        orgTemMap.put((String)entry.getKey(), "DC");
                        continue;
                    }
                    if (DimTypesEnum.INTERCOMPANY.getNumber().equals(entry.getKey())) {
                        orgTemMap.put((String)entry.getKey(), "ICNone");
                        continue;
                    }
                    if (!DimEntityNumEnum.getEntieyNumByNumber((String)((String)entry.getKey())).equalsIgnoreCase("bcm_userdefinedmembertree")) continue;
                    orgTemMap.put((String)entry.getKey(), dimNum2shortNum.get(entry.getKey()) + "None");
                }
            }
            comMemMaps.put(templateId, orgTemMap);
        }
        return comMemMaps;
    }

    public static IDNumberTreeNode getDefautMem(String modelnumber, String dimnum, long memId) {
        if (DimTypesEnum.CURRENCY.getNumber().equals(dimnum) && memId == 0L) {
            return MemberReader.findMemberByNumber((String)modelnumber, (String)dimnum, (String)"DC");
        }
        if (DimTypesEnum.PROCESS.getNumber().equals(dimnum)) {
            return MemberReader.findMemberByNumber((String)modelnumber, (String)dimnum, (String)"EIRpt");
        }
        if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimnum)) {
            return MemberReader.findMemberByNumber((String)modelnumber, (String)dimnum, (String)"EntityInput");
        }
        return MemberReader.findMemberById((String)modelnumber, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dimnum), (Long)memId);
    }

    public static String getErrorMsg(Exception res) {
        String msg = res.getMessage() != null && res.getMessage().contains("KDBizException") || res instanceof KDBizException || res instanceof EvalException || res instanceof NotificationException ? res.getMessage() : ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)res, (int)10);
        return msg;
    }

    public static void setCaculateStatus(char status, long modelId, long scenarioId, long fyId, long periodId, long orgId, long templateId, long group) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("scenario", "=", (Object)scenarioId);
        qfBuilder.add("fy", "=", (Object)fyId);
        qfBuilder.add("period", "=", (Object)periodId);
        qfBuilder.add("org", "=", (Object)orgId);
        qfBuilder.add("template.id", "=", (Object)templateId);
        DynamicObject collect = BusinessDataServiceHelper.loadSingle((String)"bcm_datacollect", (String)"collectstatus,modifydate,modifier,starttime,group", (QFilter[])qfBuilder.toArray());
        if (collect != null) {
            collect.set("collectstatus", (Object)Character.valueOf(status));
            collect.set("modifydate", (Object)TimeServiceHelper.now());
            collect.set("modifier", (Object)RequestContext.get().getUserId());
            collect.set("group", (Object)group);
            if (status == DataCollectRecordEnum.EXCUTING.index) {
                collect.set("starttime", (Object)TimeServiceHelper.now());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{collect});
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datacollect");
            dynamicObject.set("org", (Object)orgId);
            dynamicObject.set("template", (Object)templateId);
            dynamicObject.set("scenario", (Object)scenarioId);
            dynamicObject.set("fy", (Object)fyId);
            dynamicObject.set("period", (Object)periodId);
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
            dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
            dynamicObject.set("collectstatus", (Object)Character.valueOf(status));
            dynamicObject.set("group", (Object)group);
            if (status == DataCollectRecordEnum.EXCUTING.index) {
                dynamicObject.set("starttime", (Object)TimeServiceHelper.now());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void dealScopePeriodByCommonDim(String orignPeriod, IHook supplier, Consumer<List<String>> consumer, Consumer<String> consumer2) {
        if (orignPeriod.contains(",")) {
            String[] periods = orignPeriod.split(",");
            if (periods.length < 2) {
                if (consumer2 != null) {
                    consumer2.accept(orignPeriod);
                }
                return;
            }
            if (periods.length != 2) {
                if (supplier != null) {
                    supplier.doHook();
                }
                return;
            }
            List<String> periodList = Arrays.asList(periods);
            if (consumer != null) {
                consumer.accept(periodList);
            }
        } else if (consumer2 != null) {
            consumer2.accept(orignPeriod);
        }
    }

    public static List<Formula> getCanParamFloatFormulas() {
        ArrayList<Formula> formulas = new ArrayList<Formula>(10);
        FormulaConfig.getInstance().getFormulaList().stream().filter(f -> Boolean.parseBoolean((String)f.get("isSupportFloat"))).map(f -> (String)f.get("number")).forEach(f -> formulas.add(ResourcesLoaderUtil.getFormulaByNumber(f)));
        return formulas;
    }

    public static List<String> getCanParamFloatFormulaNums() {
        List formulaNums = (List)ThreadCache.get((Object)"isSupportFloat", () -> FormulaConfig.getInstance().getFormulaList().stream().filter(f -> Boolean.parseBoolean((String)f.get("isSupportFloat"))).map(f -> ((String)f.get("number")).toLowerCase()).collect(Collectors.toList()));
        return formulaNums;
    }

    public static Set<String> getCanBatchFormulaNums() {
        Set<String> formulas = FormulaConfig.getInstance().getFormulaList().stream().filter(formula -> Boolean.parseBoolean((String)formula.get("isSupportedBatch")) || Boolean.parseBoolean((String)formula.get("isSupportFloat"))).map(formula -> ((String)formula.get("number")).toLowerCase()).collect(Collectors.toSet());
        return formulas;
    }

    public static List<String> getFormualParamNumsByFormula(String formula) {
        List<String> params = FormulaConfig.getInstance().getFormulaParamMap().get(formula);
        return params;
    }

    public static Map<String, List> datacollectscreenById(Long planId) {
        List mulcatalog;
        List multemplate;
        List mulentity;
        DynamicObject plan = QueryServiceHelper.queryOne((String)"bcm_datacollectplan", (String)"mulentity, multemplate, mulcatalog, execstatus, model", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)planId)});
        ArrayList<String> numberList = new ArrayList<String>(10);
        ArrayList<Long> orgIdList = new ArrayList<Long>(10);
        ArrayList<String> templateClassNameList = new ArrayList<String>(10);
        ArrayList<Long> templateClassIdList = new ArrayList<Long>(10);
        ArrayList<String> templateList = new ArrayList<String>(10);
        List<Object> tempNumberList = new ArrayList(10);
        ArrayList<Long> templateIdList = new ArrayList<Long>(10);
        List execStatus = new ArrayList(5);
        if (StringUtils.isNotEmpty((String)plan.getString("mulentity")) && (mulentity = (List)JSON.parseObject((String)plan.getString("mulentity"), List.class)).size() > 0) {
            DynamicObjectCollection entitys = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)mulentity)});
            DataCollectUtil.collectPropertys(numberList, orgIdList, entitys, "number");
        }
        if (StringUtils.isNotEmpty((String)plan.getString("multemplate")) && (multemplate = (List)JSON.parseObject((String)plan.getString("multemplate"), List.class)).size() > 0) {
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)multemplate)});
            tempNumberList = templates.stream().map(t -> t.getString("number")).collect(Collectors.toList());
            DataCollectUtil.collectPropertys(templateList, templateIdList, templates, "name");
        }
        if (StringUtils.isNotEmpty((String)plan.getString("mulcatalog")) && (mulcatalog = (List)JSON.parseObject((String)plan.getString("mulcatalog"), List.class)).size() > 0) {
            long modelId = plan.getLong("model");
            QFilter qFilter = new QFilter("id", "in", (Object)mulcatalog);
            DynamicObjectCollection templateCatelog = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id, longnumber", (QFilter[])qFilter.toArray());
            QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
            QFBuilder qfBuilder = new QFBuilder("1", "=", (Object)1);
            boolean isfirst = true;
            for (DynamicObject catelog : templateCatelog) {
                if (isfirst) {
                    qfBuilder.and(new QFilter("longnumber", "like", (Object)(catelog.getString("longnumber") + ".%")).or("longnumber", "=", (Object)catelog.getString("longnumber")));
                    isfirst = false;
                    continue;
                }
                qfBuilder.or(new QFilter("longnumber", "like", (Object)(catelog.getString("longnumber") + ".%")).or("longnumber", "=", (Object)catelog.getString("longnumber")));
            }
            qf.and(qfBuilder);
            DynamicObjectCollection catalogDys = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,name", (QFilter[])qf.toArray());
            DataCollectUtil.collectPropertys(templateClassNameList, templateClassIdList, catalogDys, "name");
        }
        if (StringUtils.isNotEmpty((String)plan.getString("execstatus"))) {
            execStatus = (List)JSON.parseObject((String)plan.getString("execstatus"), List.class);
        }
        HashMap<String, List> result = new HashMap<String, List>(7);
        result.put("orgNums", numberList);
        result.put("orgIds", orgIdList);
        result.put("catalogNames", templateClassNameList);
        result.put("catalogIds", templateClassIdList);
        result.put("templateNums", templateList);
        result.put("templateIds", templateIdList);
        result.put("templateNumbers", tempNumberList);
        result.put("status", execStatus);
        boolean check = orgIdList.size() == 0 && templateClassIdList.size() == 0 && templateIdList.size() == 0 && execStatus.size() == 0;
        result.put("check", Collections.singletonList(check));
        return result;
    }

    private static void collectPropertys(List<String> numberList, List<Long> idList, DynamicObjectCollection dys, String property) {
        for (DynamicObject value : dys) {
            numberList.add(value.getString(property));
            idList.add(value.getLong("id"));
        }
    }

    public static Set<String> getNotPermNumsCache(Long modelId, String dimNum) {
        return (Set)ThreadCache.get((Object)(modelId + "notPermEntityNums"), () -> DataCollectUtil.getNotPermNums(modelId, dimNum));
    }

    public static Set<String> getNotPermNums(Long modelId, String dimNum) {
        Long entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        String entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter noPermFilter = PermissionServiceImpl.getInstance(modelId).getNoPermFilter(entityDimId, entityNum, "id");
        qFilter.and(noPermFilter);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)entityNum, (String)"number", (QFilter[])qFilter.toArray());
        Set<String> nums = dys.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        return nums;
    }

    public static Set<String> getNotPermNumsByNums(Long modelId, String dimNum, Collection<String> numbers) {
        Long entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        String entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        Set<String> noPermNumbers = PermissionServiceImpl.getInstance(modelId).matchNoPermMembersByNum(entityDimId, entityNum, numbers);
        return noPermNumbers;
    }

    public static Set<String> getReadOrWritePermMembersByNums(Long modelId, String dimNum, Collection<String> numbers) {
        Long entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        String entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        Set<String> readOrWritePermMembers = PermissionServiceImpl.getInstance(modelId).matchReadOrWritePermMembersByNum(entityDimId, entityNum, numbers);
        return readOrWritePermMembers;
    }
}

