/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.io.IOException;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;

public class DataMutextHelper {
    private static final String PAGECACHE_LOCKED = "pageCache_locked";

    public static void releaseLock(IFormView view, String entityNum, String opkey) {
        String lockedKey;
        Map<String, String> lockInfo;
        if (StringUtils.isNotBlank((CharSequence)view.getPageCache().get(PAGECACHE_LOCKED)) && (lockInfo = DataMutextHelper.getLockInfo(lockedKey = view.getPageCache().get(PAGECACHE_LOCKED), entityNum, opkey)) != null && lockInfo.get("userid").equals(RequestContext.getOrCreate().getUserId())) {
            DataMutextHelper.release(lockedKey, entityNum, opkey);
        }
        view.getPageCache().remove(PAGECACHE_LOCKED);
    }

    public static boolean requestMutex(IFormView view, String dataKey, String entityNum, String opKey) {
        boolean lockSucess = DataMutextHelper.request(dataKey, entityNum, opKey, Boolean.FALSE);
        if (!lockSucess) {
            Map<String, String> lockInfo = DataMutextHelper.getLockInfo(dataKey, entityNum, opKey);
            if (lockInfo != null) {
                String tips = String.format(ResManager.loadKDString((String)"\u5df2\u88ab %s \u9501\u5b9a\uff0c\u53ea\u80fd\u67e5\u770b\u3002", (String)"ExchangeRateMaintainPlugin_67", (String)"fi-bcm-business", (Object[])new Object[0]), UserServiceHelper.getUsernameByUserid(lockInfo.get("userid")));
                view.showTipNotification(tips, Integer.valueOf(3000));
            }
        } else {
            view.getPageCache().put(PAGECACHE_LOCKED, dataKey);
        }
        return lockSucess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean request(String id, String entityNum, String opKey, Boolean isStrict) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.require(id, "op_" + opKey, entityNum, opKey, isStrict.booleanValue());
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getLockInfo(String id, String entityKey, String opKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Map map = dataMutex.getLockInfo(id, "op_" + opKey, entityKey);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean release(String id, String entityKey, String operationKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.release(id, entityKey, operationKey);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }
}

