/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.collect.ArrayListMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.enums.CslSchemeScopeEnum;
import org.apache.commons.collections.CollectionUtils;

public class DataQueryAnalyticsHelper {
    public static Set<Long> getHavePermSchemeIds(long modelId, long userId) {
        if (modelId == 0L || userId == 0L) {
            return null;
        }
        HashMap<Long, Integer> permMap = new HashMap<Long, Integer>();
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection schemeDys = QueryServiceHelper.query((String)"bcm_analyticsscheme_base", (String)"id, number, permrange, creator", (QFilter[])qf.toArray());
        Map<Long, DynamicObject> scheMap = schemeDys.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
        boolean adminUserBol = DataQueryAnalyticsHelper.ifUserHasRootPermByModelFromDb(userId, modelId);
        if (adminUserBol) {
            return scheMap.keySet();
        }
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch("bcm_analyticsscheme_base", String.valueOf(modelId), String.valueOf(userId));
        DataQueryAnalyticsHelper.permClassHandler(scheMap.keySet(), permMap, map);
        Set<Long> schemIds = scheMap.keySet();
        for (DynamicObject schemeDy : schemeDys) {
            Integer perm = (Integer)permMap.get(schemeDy.getLong("id"));
            if ((!CslSchemeScopeEnum.isOneSelfScope((String)schemeDy.getString("permrange")) || userId == schemeDy.getLong("creator")) && (perm == null || perm != 3)) continue;
            schemIds.remove(schemeDy.getLong("id"));
        }
        return schemIds;
    }

    public static Set<Long> getHavePermSchemeIdsOfWrite(long modelId, long userId) {
        if (modelId == 0L || userId == 0L) {
            return null;
        }
        HashMap<Long, Integer> permMap = new HashMap<Long, Integer>();
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection schemeDys = QueryServiceHelper.query((String)"bcm_analyticsscheme_base", (String)"id, number, permrange, creator", (QFilter[])qf.toArray());
        Map<Long, DynamicObject> scheMap = schemeDys.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
        boolean adminUserBol = DataQueryAnalyticsHelper.ifUserHasRootPermByModelFromDb(userId, modelId);
        if (adminUserBol) {
            return scheMap.keySet();
        }
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch("bcm_analyticsscheme_base", String.valueOf(modelId), String.valueOf(userId));
        DataQueryAnalyticsHelper.permClassHandler(scheMap.keySet(), permMap, map);
        Set<Long> schemIds = scheMap.keySet();
        for (DynamicObject schemeDy : schemeDys) {
            Integer perm = (Integer)permMap.get(schemeDy.getLong("id"));
            if ((!CslSchemeScopeEnum.isOneSelfScope((String)schemeDy.getString("permrange")) || userId == schemeDy.getLong("creator")) && (perm == null || perm != 3 && perm != 2)) continue;
            schemIds.remove(schemeDy.getLong("id"));
        }
        return schemIds;
    }

    private static void permClassHandler(Set<Long> allOrgIds, Map<Long, Integer> memberPerm, ArrayListMultimap<String, Long> map) {
        for (String key : map.keySet()) {
            List ids = map.get((Object)key);
            if ("1".equals(key)) {
                ids.stream().forEach(id -> {
                    Integer value;
                    if (allOrgIds.contains(id) && ((value = (Integer)memberPerm.get(id)) == null || value < 3)) {
                        memberPerm.put((Long)id, 3);
                    }
                });
                continue;
            }
            if ("2".equals(key)) {
                ids.stream().forEach(id -> {
                    Integer value;
                    if (allOrgIds.contains(id) && ((value = (Integer)memberPerm.get(id)) == null || value < 2)) {
                        memberPerm.put((Long)id, 2);
                    }
                });
                continue;
            }
            if (!"3".equals(key)) continue;
            ids.stream().forEach(id -> {
                Integer value;
                if (allOrgIds.contains(id) && (value = (Integer)memberPerm.get(id)) == null) {
                    memberPerm.put((Long)id, 1);
                }
            });
        }
    }

    public static boolean ifUserHasRootPermByModelFromDb(long userId, long modelId) {
        String isGalaxySystem = System.getProperty("isGalaxySystem");
        if (isGalaxySystem != null && isGalaxySystem.equalsIgnoreCase("true")) {
            return false;
        }
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter filter1 = new QFilter("model", "=", (Object)modelId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MemberPermSpreadLogic.ifUserHasRootPermByModel", (String)"bcm_modelperm", (String)"id,modelpermentry.eusers.id", (QFilter[])new QFilter[]{filter1}, null);){
            for (Row row : ds) {
                if (!groupIds.contains(row.getLong("modelpermentry.eusers.id"))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static boolean isHavePermOfSchemeOfWrite(long schemeId, long modelId, long userId) {
        if (schemeId == 0L || modelId == 0L || userId == 0L) {
            return Boolean.FALSE;
        }
        Set<Long> havePermSchemeIds = DataQueryAnalyticsHelper.getHavePermSchemeIdsOfWrite(modelId, userId);
        return havePermSchemeIds.contains(schemeId);
    }

    public static Map<Long, Boolean> isHavePermOfBatchSchemeOfWrite(Set<Long> schemeIds, long modelId, long userId) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(16);
        if (CollectionUtils.isEmpty(schemeIds) || modelId == 0L || userId == 0L) {
            return map;
        }
        Set<Long> havePermSchemeIds = DataQueryAnalyticsHelper.getHavePermSchemeIdsOfWrite(modelId, userId);
        for (Long schemeId : schemeIds) {
            if (havePermSchemeIds.contains(schemeId)) {
                map.put(schemeId, Boolean.TRUE);
                continue;
            }
            map.put(schemeId, Boolean.FALSE);
        }
        return map;
    }
}

