/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.PageDimSelectTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class DefaultPageDimSettingUtil {
    public static boolean isChangeforPageSetting(TemplateModel tm) {
        QFilter qFilter;
        DynamicObjectCollection objects;
        if (tm.isSaveByDim() && CollectionUtils.isNotEmpty((Collection)(objects = QueryServiceHelper.query((String)"bcm_pageselect", (String)"org.id,template.id,member,dimension.number", (QFilter[])new QFilter[]{qFilter = new QFilter("template", "=", (Object)tm.getId())}, (String)"id")))) {
            List<PageDimPropEntry> pagePropEntries;
            HashMap map = new HashMap(16);
            objects.forEach(e -> {
                String dimNum = e.getString("dimension.number");
                if (Objects.isNull(map.get(dimNum))) {
                    map.put(dimNum, new HashSet(16));
                }
                ((Set)map.get(dimNum)).add(e.getLong("member"));
            });
            List<PageDimensionEntry> pageDimensionEntries = tm.getPageDimensionEntries();
            HashSet ids = new HashSet(16);
            if (CollectionUtils.isNotEmpty(pageDimensionEntries)) {
                for (PageDimensionEntry p : pageDimensionEntries) {
                    List<Member> pMembers;
                    String dimNum = p.getDimension().getNumber();
                    if (Objects.isNull(map.get(dimNum)) || !CollectionUtils.isNotEmpty(pMembers = p.getMembers())) continue;
                    String entityName = DimensionServiceHelper.getDimMembEntityNumByDimNum(p.getDimension().getNumber());
                    ids.clear();
                    pMembers.forEach(e -> new MembRangeItem(entityName, (Long)e.getId(), e.getNumber(), e.getScope(), false, (Object)tm.getModelId()).matchItems(c -> ids.add(c.getId())));
                    if (ids.containsAll((Collection)map.get(dimNum))) continue;
                    return true;
                }
            }
            if (CollectionUtils.isNotEmpty(pagePropEntries = tm.getPagePropEntries())) {
                for (PageDimPropEntry p : pagePropEntries) {
                    List<MembProperty> allMembProperties;
                    String dimNum = p.getDimension().getNumber();
                    if (Objects.isNull(map.get(dimNum)) || !CollectionUtils.isNotEmpty(allMembProperties = p.getAllMembProperties())) continue;
                    ids.clear();
                    String entityName = DimensionServiceHelper.getDimMembEntityNumByDimNum(p.getDimension().getNumber());
                    allMembProperties.forEach(e -> new MembRangeItem(entityName, (Long)e.getId(), e.getNumber(), e.getScope(), true, (Object)tm.getModelId()).matchItems(c -> ids.add(c.getId())));
                    if (ids.containsAll((Collection)map.get(dimNum))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static DynamicObjectCollection getPageDimSetting(Collection<Long> templateIds, Collection<Long> orgidList, QFilter curFilter, char type) {
        QFilter filter = new QFilter("template", "in", templateIds);
        HashSet<Long> orgSet = new HashSet<Long>(orgidList);
        orgSet.add(0L);
        filter.and("org", "in", orgSet);
        filter.and("type", "=", (Object)Character.valueOf(type));
        if (!Objects.isNull(curFilter)) {
            filter.and(curFilter);
        }
        return QueryServiceHelper.query((String)"bcm_pageselect", (String)"org.id,template.id,member,dimension.number", (QFilter[])filter.toArray(), (String)"id");
    }

    public static Map<String, Long> getFilterDimSetting(Long modelId, Long templateId, Long orgId, QFilter curFilter) {
        QFilter filter = new QFilter("template", "=", (Object)templateId);
        HashSet<Long> orgSet = new HashSet<Long>(2);
        orgSet.add(0L);
        orgSet.add(orgId);
        filter.and("org", "in", orgSet);
        filter.and("type", "=", (Object)Character.valueOf('1'));
        if (!Objects.isNull(curFilter)) {
            filter.and(curFilter);
        }
        DynamicObjectCollection filterDimSetting = QueryServiceHelper.query((String)"bcm_pageselect", (String)"member,dimension.number", (QFilter[])filter.toArray());
        HashMap<String, Long> result = new HashMap<String, Long>(10);
        if (CollectionUtils.isEmpty((Collection)filterDimSetting)) {
            TemplateModel templateModel = TemplateServiceHelper.getTemplateModelById(templateId);
            for (FilterDimensionEntry filterDimensionEntry : templateModel.getFilterDimensionEntries()) {
                ArrayList ids = new ArrayList(16);
                for (Member member : filterDimensionEntry.getMembers()) {
                    new MembRangeItem(member.getDimension().getMemberEntityNumber(), (Long)member.getId(), member.getNumber(), member.getScope(), false, (Object)modelId).matchItems(c -> ids.add(c.getId()));
                }
                if (ids.isEmpty()) continue;
                result.put(filterDimensionEntry.getDimension().getNumber(), (Long)ids.get(0));
            }
        } else {
            for (DynamicObject setting : filterDimSetting) {
                result.put(setting.getString("dimension.number"), setting.getLong("member"));
            }
        }
        return result;
    }

    public static Map<Long, Set<Long>> getOrgIdAndNotEc(String cube, Collection<Long> orgIds, Collection<Long> templatIds) {
        HashMap<Long, Set<Long>> orgAndTemplates = new HashMap<Long, Set<Long>>(16);
        if (CollectionUtils.isEmpty(orgIds)) {
            return orgAndTemplates;
        }
        Long dcId = MemberReader.findCurrencyMemberByNum((String)cube, (String)"DC").getId();
        Long ecId = MemberReader.findCurrencyMemberByNum((String)cube, (String)"EC").getId();
        QFilter curFilter = new QFilter("member", "not in", (Object)new long[]{ecId, dcId});
        curFilter.and("dimension.number", "=", (Object)"Currency");
        DynamicObjectCollection pageDimSetting = DefaultPageDimSettingUtil.getPageDimSetting(templatIds, orgIds, curFilter, PageDimSelectTypeEnum.PAGEDIM.index);
        if (CollectionUtils.isEmpty((Collection)pageDimSetting)) {
            return orgAndTemplates;
        }
        HashMap map = new HashMap(16);
        ArrayList dyos = new ArrayList(pageDimSetting.size());
        pageDimSetting.forEach(e -> {
            if (e.getLong("member") != 0L) {
                if (e.getLong("org.id") == 0L) {
                    map.put(e.getLong("template.id"), e.getLong("member"));
                } else {
                    dyos.add(e);
                }
            }
        });
        HashMap orgAndCurrency = new HashMap(16);
        orgIds.forEach(id -> {
            IDNumberTreeNode currencyNode;
            IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((String)cube, (Long)id);
            if (treeNode != IDNumberTreeNode.NotFoundTreeNode && (currencyNode = MemberReader.findCurrencyMemberByNum((String)cube, (String)treeNode.getCurrency())) != IDNumberTreeNode.NotFoundTreeNode) {
                orgAndCurrency.put(id, currencyNode.getId());
            }
        });
        for (DynamicObject pageSelect : dyos) {
            Long currencyMemberId = pageSelect.getLong("member");
            Long orgId = pageSelect.getLong("org.id");
            orgIds.remove(orgId);
            if (orgAndCurrency.get(orgId) == null || currencyMemberId.equals(orgAndCurrency.get(orgId))) continue;
            if (orgAndTemplates.containsKey(orgId)) {
                ((Set)orgAndTemplates.get(orgId)).add(pageSelect.getLong("template.id"));
                continue;
            }
            HashSet<Long> templates = new HashSet<Long>();
            templates.add(pageSelect.getLong("template.id"));
            orgAndTemplates.put(orgId, templates);
        }
        if (!orgIds.isEmpty()) {
            orgIds.forEach(id -> {
                HashSet idSet = new HashSet(16);
                Long currencyId = (Long)orgAndCurrency.get(id);
                if (Objects.isNull(currencyId)) {
                    return;
                }
                templatIds.forEach(templatId -> {
                    if (map.get(templatId) != null && !currencyId.equals(map.get(templatId))) {
                        idSet.add(templatId);
                    }
                });
                if (!idSet.isEmpty()) {
                    orgAndTemplates.put((Long)id, idSet);
                }
            });
        }
        return orgAndTemplates;
    }

    public static Map<String, Object> getAllselectPagesByCondition(String modelNumber, List<Long> templateIds, Set<Long> orgidList, boolean isExcel) {
        HashMap<String, Object> tempOrgMap = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(templateIds) || CollectionUtils.isEmpty(orgidList)) {
            return tempOrgMap;
        }
        DynamicObjectCollection pageDimSetting = DefaultPageDimSettingUtil.getPageDimSetting(templateIds, orgidList, null, PageDimSelectTypeEnum.PAGEDIM.index);
        if (CollectionUtils.isNotEmpty((Collection)pageDimSetting)) {
            long orgId = 0L;
            for (DynamicObject dy : pageDimSetting) {
                orgId = dy.getLong("org.id");
                long tempId = dy.getLong("template.id");
                long memId = dy.getLong("member");
                String dimnum = dy.getString("dimension.number");
                IDNumberTreeNode treeNode = DataCollectUtil.getDefautMem(modelNumber, dimnum, memId);
                String key = tempId + "_" + orgId;
                if (isExcel) {
                    if (tempOrgMap.get(key) == null) {
                        tempOrgMap.put(key, new ArrayList(16));
                    }
                    ((List)tempOrgMap.get(key)).add(treeNode);
                    continue;
                }
                String name = treeNode.getName();
                if (tempOrgMap.containsKey(key)) {
                    tempOrgMap.put(key, tempOrgMap.get(key) + "," + name);
                    continue;
                }
                tempOrgMap.put(key, name);
            }
        }
        return tempOrgMap;
    }
}

