/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.DimensionNode;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class DimMemberSortUtil {
    private static WatchLogger LOG = BcmLogFactory.getWatchLogInstance(DimMemberSortUtil.class);
    private static AtomicInteger dseq = new AtomicInteger();

    public static void updateMemberSeqByDim(Long modelId, Long cslschemeId, Long dimId, String entityName) {
        if (dimId == 0L) {
            throw new KDBizException("DimMemberSortUtil.updateMemberSeqByDim() dimId = 0");
        }
        try (TXHandle tx = TX.required((String)"delete_and_save_all_sort_members");){
            try {
                DimMemberSortUtil.upadteDimChangeTime(modelId, cslschemeId, dimId, "refreshtime");
                QFilter qf = new QFilter("dimid", "=", (Object)dimId);
                if ("bcm_entitymembertree".equals(entityName)) {
                    if (cslschemeId == null || cslschemeId == 0L) {
                        throw new KDBizException("cslschemeid is null: updateMemberSeqByDim");
                    }
                    qf.and("cslschemeid", "=", (Object)cslschemeId);
                }
                DeleteServiceHelper.delete((String)"bcm_memberorder", (QFilter[])qf.toArray());
                DimMemberSortUtil.sortByDim(modelId, dimId, cslschemeId, entityName);
            }
            catch (Exception e) {
                LOG.error("update member dseq error:" + e.getMessage(), (Throwable)e);
                tx.markRollback();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)("update member dseq error: " + e.getMessage())), new Object[0]);
            }
        }
    }

    public static void upadteDimChangeTime(Long modelId, Long cslschemeId, Long dimId, String fieldName) {
        DynamicObject dy;
        if (dimId == 0L || modelId == 0L) {
            return;
        }
        DynamicObject dimDy = MemberReader.getDimensionDynById((long)dimId);
        if ("bcm_dimension_ext".equals(dimDy.getDynamicObjectType().getName())) {
            return;
        }
        String entityName = dimDy.getString("membermodel");
        Date date = new Date();
        QFilter qf = new QFilter("dimid", "=", (Object)dimId);
        if ("bcm_entitymembertree".equals(entityName)) {
            if (cslschemeId == null || cslschemeId == 0L) {
                throw new KDBizException("cslschemeid is null: upadteDimChangeTime");
            }
            qf.and("cslschemeid", "=", (Object)cslschemeId);
        }
        if ((dy = BusinessDataServiceHelper.loadSingle((String)"bcm_dimchangeschedule", (String)fieldName, (QFilter[])qf.toArray())) == null) {
            dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimchangeschedule");
            dy.set("cslschemeid", (Object)("bcm_entitymembertree".equals(entityName) ? cslschemeId : 0L));
            dy.set("dimid", (Object)dimId);
            dy.set(fieldName, (Object)date);
            dy.set("model", (Object)modelId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        } else {
            dy.set(fieldName, (Object)date);
            SaveServiceHelper.update((DynamicObject)dy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareTimeOfChangeAndRefresh(Long modelId, Long cslschemeId, Long dimId) {
        block19: {
            if (dimId == 0L || modelId == 0L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5165\u53c2\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5modelID\u201c%1$s\u201d\u548cdimID\u201c%2$s\u201d\u3002", (String)"DimMemberSortUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]), modelId, dimId));
            }
            String lockKey = String.format("%s_%s_%s_%s", modelId, dimId, cslschemeId, DimMemberSortUtil.class.getSimpleName());
            try (DLock lock = DLock.create((String)lockKey).fastMode();){
                boolean locked = lock.tryLock();
                if (locked) {
                    try {
                        DimMemberSortUtil.updateSeqOfDim(modelId, cslschemeId, dimId);
                        break block19;
                    }
                    catch (Exception e) {
                        LOG.error("sync chkCheckStatus failed...", (Throwable)e);
                        break block19;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                LOG.error("get lock failed!lockKey=" + lockKey);
            }
        }
    }

    private static void updateSeqOfDim(Long modelId, Long cslschemeId, Long dimId) {
        DynamicObject dy;
        DynamicObject dimDy = MemberReader.getDimensionDynById((long)dimId);
        if ("bcm_dimension_ext".equals(dimDy.getDynamicObjectType().getName())) {
            return;
        }
        String entityName = dimDy.getString("membermodel");
        QFilter qf = new QFilter("dimid", "=", (Object)dimId);
        if ("bcm_entitymembertree".equals(entityName)) {
            if (cslschemeId == null || cslschemeId == 0L) {
                throw new KDBizException("cslschemeid is null: updateSeqOfDim()");
            }
            qf.and("cslschemeid", "=", (Object)cslschemeId);
        }
        if ((dy = QueryServiceHelper.queryOne((String)"bcm_dimchangeschedule", (String)"changetime, refreshtime", (QFilter[])qf.toArray())) == null) {
            DimMemberSortUtil.updateMemberSeqByDim(modelId, cslschemeId, dimId, entityName);
            return;
        }
        Date changeTime = dy.getDate("changetime");
        Date refreshTime = dy.getDate("refreshtime");
        if (refreshTime != null && changeTime == null || changeTime != null && refreshTime != null && refreshTime.compareTo(changeTime) > 0) {
            return;
        }
        DimMemberSortUtil.updateMemberSeqByDim(modelId, cslschemeId, dimId, entityName);
    }

    public static Map<String, Integer> getMemberNumber2SequenceMap(Long modelId, String dimNum, long cslschemeId, Collection<String> nums) {
        long dimid = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        DimMemberSortUtil.compareTimeOfChangeAndRefresh(modelId, cslschemeId, dimid);
        QFilter filter = new QFilter("dimid", "=", (Object)dimid);
        if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
            filter.and("cslschemeid", "=", (Object)cslschemeId);
        }
        HashMap cacheMap = new HashMap();
        DataSet doc = QueryServiceHelper.queryDataSet((String)"bcm.getMemberNumber2SequenceMap", (String)"bcm_memberorder", (String)"number,dseq", (QFilter[])new QFilter[]{filter}, null);
        doc.forEach(d -> {
            String num = d.getString("number");
            if (nums.contains(num)) {
                cacheMap.put(num, d.getInteger("dseq"));
            }
        });
        doc.close();
        return Collections.unmodifiableMap(cacheMap);
    }

    private static void sortByDim(Long modelId, Long dimId, Long cslschemeId, String entityName) {
        DynamicObjectCollection members;
        String selectMemberFields = "id, number, parent, copyfrom, longnumber, storagetype, aggoprt, isleaf, modifytime, dseq";
        QFBuilder memberFilters = new QFBuilder();
        memberFilters.add("model", "=", (Object)modelId);
        memberFilters.add("dimension", "=", (Object)dimId);
        memberFilters.add("status", "=", (Object)"C");
        if ("bcm_entitymembertree".equals(entityName)) {
            memberFilters.add("cslscheme", "=", (Object)cslschemeId);
        }
        if (!"bcm_entitymembertree".equals(entityName)) {
            memberFilters.add("storagetype", "!=", (Object)"3");
        }
        if ((members = QueryServiceHelper.query((String)entityName, (String)selectMemberFields, (QFilter[])memberFilters.toArray(), (String)"dseq")).size() == 0) {
            return;
        }
        DimensionTree<String, DimensionNode> tree = DimensionNode.createDimTreeWithShareRef((DynamicObject[])members.toArray((Object[])new DynamicObject[0]));
        ArrayList<DynamicObject> allMems = new ArrayList<DynamicObject>(16);
        AtomicInteger dseq = new AtomicInteger(1);
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_memberorder");
        DimensionNode member = tree.getData();
        dy.set("memberid", (Object)member.getId());
        dy.set("number", (Object)member.getNumber());
        dy.set("dseq", (Object)dseq.get());
        dy.set("membertype", (Object)entityName);
        dy.set("dimid", (Object)dimId);
        dy.set("model", (Object)modelId);
        dy.set("cslschemeid", (Object)("bcm_entitymembertree".equals(entityName) ? cslschemeId : 0L));
        allMems.add(dy);
        List<DimensionTree<String, DimensionNode>> children = tree.getChildren();
        DimMemberSortUtil.constructData(allMems, children, dseq);
        for (DynamicObject mem : allMems) {
            mem.set("membertype", (Object)entityName);
            mem.set("dimid", (Object)dimId);
            mem.set("model", (Object)modelId);
            mem.set("cslschemeid", (Object)("bcm_entitymembertree".equals(entityName) ? cslschemeId : 0L));
        }
        DynamicObjectType dynamicObjectType = ((DynamicObject)allMems.get(0)).getDynamicObjectType();
        BatchProcessHelper.batchConsume(allMems, (int)1000, list -> BusinessDataWriter.save((IDataEntityType)dynamicObjectType, (Object[])list.toArray()));
    }

    private static void constructData(List<DynamicObject> allMems, List<DimensionTree<String, DimensionNode>> tree, AtomicInteger dseq) {
        for (DimensionTree<String, DimensionNode> dimensionTree : tree) {
            dseq.getAndIncrement();
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_memberorder");
            DimensionNode member = dimensionTree.getData();
            dy.set("memberid", (Object)member.getId());
            dy.set("number", (Object)member.getNumber());
            dy.set("dseq", (Object)dseq.get());
            allMems.add(dy);
            List<DimensionTree<String, DimensionNode>> children = dimensionTree.getChildren();
            DimMemberSortUtil.constructData(allMems, children, dseq);
        }
    }
}

