/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.report.ReportContextProvider;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class EffectCombChecker {
    private DynamicObjectCollection atDoc;
    private DynamicObjectCollection bpDoc;
    private Set<String> bpInputNums;
    private Set<String> atInputNums;
    private Set<String> atCWPNums;
    private long modelId;
    private Set<String> TCFChildren;
    private DynamicObjectCollection specialCTDoc;
    private Set<String> specialCTNumbers;
    private List<String> ownLogicCTMembers;

    public List<String> getOwnLogicCTMembers() {
        if (this.ownLogicCTMembers == null) {
            this.ownLogicCTMembers = Lists.newArrayList((Object[])new String[]{"BFLY", "BOP"});
        }
        return this.ownLogicCTMembers;
    }

    private DynamicObjectCollection getSpecialCTDoc() {
        if (this.specialCTDoc == null) {
            this.specialCTDoc = (DynamicObjectCollection)ThreadCache.get((Object)("getSpecialCTDoc->" + this.modelId), () -> {
                QFilter qFilter = new QFilter("model.id", "=", (Object)this.modelId);
                qFilter.and("changeway", "=", (Object)ChangewayEnum.EARLYYEARADJUST.index);
                qFilter.and("number", "!=", (Object)"BFLY");
                qFilter.and("number", "!=", (Object)"BBOY01");
                return QueryServiceHelper.query((String)"bcm_changetypemembertree", (String)"number,changeway", (QFilter[])qFilter.toArray());
            });
        }
        return this.specialCTDoc;
    }

    private DynamicObjectCollection getAtDoc() {
        if (this.atDoc == null) {
            this.atDoc = (DynamicObjectCollection)ThreadCache.get((Object)("getAtDoc->" + this.modelId), () -> QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"number,datasource", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.modelId)}));
        }
        return this.atDoc;
    }

    private DynamicObjectCollection getBpDoc() {
        if (this.bpDoc == null) {
            this.bpDoc = ReportContextProvider.getDataSourceBp(this.modelId);
        }
        return this.bpDoc;
    }

    public Set<String> getSpecialCTNumbers() {
        if (this.specialCTNumbers == null) {
            this.specialCTNumbers = this.getSpecialCTDoc().stream().map(m -> m.getString("number")).collect(Collectors.toSet());
        }
        return this.specialCTNumbers;
    }

    public Set<String> getAtInputNums() {
        if (this.atInputNums == null) {
            this.atInputNums = (Set)ThreadCache.get((Object)("getAtInputNums->" + this.modelId), () -> this.getAtDoc().stream().filter(d -> d.getString("datasource").contains(DataSourceEnum.REPORTENTRY.getOIndex())).map(m -> m.getString("number")).collect(Collectors.toSet()));
        }
        return this.atInputNums;
    }

    private Set<String> getBpInputNums() {
        if (this.bpInputNums == null) {
            this.bpInputNums = this.getBpDoc().stream().filter(d -> d.getString("datasource").contains(DataSourceEnum.REPORTENTRY.getOIndex())).map(m -> m.getString("number")).collect(Collectors.toSet());
        }
        return this.bpInputNums;
    }

    public Set<String> getAtCWPNums() {
        if (this.atCWPNums == null) {
            this.atCWPNums = this.getAtDoc().stream().filter(d -> d.getString("datasource").contains(DataSourceEnum.TABLEADJUSTMENT.getOIndex())).map(m -> m.getString("number")).collect(Collectors.toSet());
        }
        return this.atCWPNums;
    }

    public EffectCombChecker(long modelId) {
        this.modelId = modelId;
    }

    public boolean checkCWP(String pbNum, String atNum) {
        boolean existAuditTrailDimension;
        return "ERAdj".equals(pbNum) && ((existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((long)this.modelId)) && this.getAtCWPNums().contains(atNum) || !existAuditTrailDimension);
    }

    public boolean checkWPforRpt(String pbNum, String atNum) {
        boolean existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((long)this.modelId);
        if ("EIRpt".equals(pbNum)) {
            if (existAuditTrailDimension && "CWP".equals(atNum)) {
                return true;
            }
            if (!existAuditTrailDimension) {
                return true;
            }
        }
        return false;
    }

    public boolean checkBpCanWrite(boolean isleaf, String number) {
        if (isleaf && ("CSTE".equals(number) || "SRPT".equals(number))) {
            return false;
        }
        if (this.getTCFChildren().contains(number)) {
            return false;
        }
        return this.getBpInputNums().contains(number);
    }

    private Set<String> getTCFChildren() {
        if (this.TCFChildren == null) {
            this.TCFChildren = new HashSet<String>();
            IDNumberTreeNode pro = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.modelId), (String)DimTypesEnum.PROCESS.getNumber(), (String)"TCF");
            if (pro != null) {
                pro.getChildren().forEach(c -> this.TCFChildren.add(c.getNumber()));
            }
        }
        return this.TCFChildren;
    }

    public boolean checkAtCanWrite(String number) {
        return this.getAtInputNums().contains(number);
    }
}

