/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import org.apache.commons.collections4.CollectionUtils;

public class MessageServiceUtil {
    public static MessageInfo getBasicMessageInfo(String messagetype, String notifytype, String title, String content, List<Long> receivers) {
        MessageInfo message = new MessageInfo();
        message.setType(messagetype);
        message.setNotifyType(notifytype);
        message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        message.setSenderName(RequestContext.get().getUserName());
        message.setTitle(title);
        message.setContent(content);
        message.setUserIds(receivers);
        return message;
    }

    public static MessageInfo getNoticeMessageInfo(String messagetype, String noticetype, String title, String content, List<Long> receivers) {
        MessageInfo message = MessageServiceUtil.getBasicMessageInfo(messagetype, noticetype, title, content, receivers);
        HashMap param = new HashMap(1);
        HashMap<String, Number> innerparam = new HashMap<String, Number>(2);
        innerparam.put("showType", 2);
        innerparam.put("timeOut", 1800000L);
        param.put("systemNotice", innerparam);
        message.setParams(param);
        return message;
    }

    public static MessageInfo getNoticeMessageInfo(String title, String content, List<Long> receivers) {
        return MessageServiceUtil.getNoticeMessageInfo("notice", "sysnotice", title, content, receivers);
    }

    public static void sendMessageByNotice(String title, String content, List<Long> receivers) {
        if (StringUtils.isEmpty((String)content) || CollectionUtils.isEmpty(receivers)) {
            return;
        }
        MessageCenterServiceHelper.sendMessage((MessageInfo)MessageServiceUtil.getNoticeMessageInfo(title, content, receivers));
    }
}

