/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.base.Joiner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.trace.OlapComTraceUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class OperationLogUtil {
    public static final String BIZAPPID = "cm";
    private static final String PRESETNAME = "presetname";
    private static final String ISSHOW = "isshow";
    private static final String WEB = "web";
    private static final String API = "api";
    private static boolean useOpLog;
    private static Class<?> multiLangEnumBridgeClass;
    private static Class<?> OpLogAppInfoClass;

    public static boolean isUseOpLog() {
        return useOpLog;
    }

    public static Object getIfNewBridge(MultiLangEnumBridge bridge) {
        if (!useOpLog) {
            return bridge;
        }
        try {
            Object multiLangEnumBridge = multiLangEnumBridgeClass.newInstance();
            Method setDescription = multiLangEnumBridgeClass.getMethod("setDescription", String.class);
            setDescription.invoke(multiLangEnumBridge, bridge.getDescription());
            Method setResourceID = multiLangEnumBridgeClass.getMethod("setResourceID", String.class);
            setResourceID.invoke(multiLangEnumBridge, bridge.getResourceID());
            Method setSystemType = multiLangEnumBridgeClass.getMethod("setSystemType", String.class);
            setSystemType.invoke(multiLangEnumBridge, bridge.getSystemType());
            return multiLangEnumBridge;
        }
        catch (Exception e) {
            return bridge;
        }
    }

    public static AppLogInfo buildLogInfo(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge, Long modelId, String bizEntityNumber) {
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo();
        OperationLogUtil.buildLogInfo(logInfo, modelId, bizEntityNumber, opNameBridge, opDescBridge);
        return logInfo;
    }

    @Deprecated
    public static AppLogInfo buildLogInfo(String opName, String opDescription, Long modelId, String bizEntityNumber) {
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo();
        OperationLogUtil.buildLogInfo(logInfo, modelId, bizEntityNumber, new OpNameMultiLangEnumBridge(opName, "", "", ""), new OPDescMultiLangEnumBridge(opDescription, "", "", null));
        return logInfo;
    }

    public static void buildLogInfo(AppLogInfo logInfo, Long modelId, String bizEntityNumber, OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        OperationLogUtil.setAppId(null, logInfo);
        logInfo.setBizObjID(bizEntityNumber);
        String jointDesc = opDescBridge.getDescription();
        if (opDescBridge.getArgs() != null && opDescBridge.getArgs().length > 0) {
            try {
                jointDesc = String.format(ResManager.loadKDString((String)opDescBridge.getDescription(), (String)opDescBridge.getResourceID(), (String)opDescBridge.getSystemType(), (Object[])new Object[0]), opDescBridge.getArgs());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String modelNumber = "";
        if (null != modelId && 0L != modelId && StringUtils.isNotEmpty((String)(modelNumber = MemberReader.findModelSNumberById((Object)modelId)))) {
            jointDesc = modelNumber + " " + jointDesc;
        }
        OperationLogUtil.setOpName(logInfo, opNameBridge);
        OperationLogUtil.setOpDesc(logInfo, jointDesc, opDescBridge);
        if (useOpLog) {
            try {
                if (StringUtils.isNotEmpty((String)modelNumber)) {
                    Method setKeyWord = logInfo.getClass().getMethod("setKeyWord", String.class);
                    setKeyWord.invoke((Object)logInfo, modelNumber);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        OlapComTraceUtil.setTraceLog((AppLogInfo)logInfo);
        if (OlapComTraceUtil.isTrace()) {
            OlapTraceServiceHelper.setTraceLog((AppLogInfo)logInfo);
        }
    }

    public static void setOpDesc(AppLogInfo logInfo, String opDescription, OPDescMultiLangEnumBridge opDescBridge) {
        logInfo.setOpDescription(opDescription);
        if (useOpLog && opDescBridge != null && StringUtils.isNotEmpty((String)opDescBridge.getResourceID())) {
            try {
                Method setOpDesc = logInfo.getClass().getMethod("setOpDesc", multiLangEnumBridgeClass, String[].class);
                setOpDesc.invoke((Object)logInfo, OperationLogUtil.getIfNewBridge((MultiLangEnumBridge)opDescBridge), opDescBridge.getArgs());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setOpName(AppLogInfo logInfo, OpNameMultiLangEnumBridge opNameBridge) {
        if (opNameBridge != null) {
            if (useOpLog && StringUtils.isNotEmpty((String)opNameBridge.getResourceID())) {
                try {
                    Method setOpName = logInfo.getClass().getMethod("setOpName", String.class, multiLangEnumBridgeClass);
                    setOpName.invoke((Object)logInfo, opNameBridge.getOpKey(), OperationLogUtil.getIfNewBridge((MultiLangEnumBridge)opNameBridge));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else {
                logInfo.setOpName(opNameBridge.getDescription());
            }
        }
    }

    public static AppLogInfo buildLogInfo() {
        RequestContext rc = RequestContext.get();
        AppLogInfo logInfo = OperationLogUtil.createLogInfo();
        logInfo.setUserID(Long.valueOf(rc.getCurrUserId()));
        logInfo.setOrgID(Long.valueOf(rc.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(rc.getClient());
        logInfo.setClientIP(rc.getLoginIP());
        logInfo.setClientName(rc.getClient());
        return logInfo;
    }

    public static AppLogInfo createLogInfo() {
        AppLogInfo logInfo = new AppLogInfo();
        if (useOpLog) {
            try {
                logInfo = (AppLogInfo)OpLogAppInfoClass.newInstance();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return logInfo;
    }

    private static void changeClientType(AppLogInfo logInfo) {
        if (API.equals(logInfo.getClientType())) {
            logInfo.setClientType(WEB);
            logInfo.setClientName(ResManager.loadKDString((String)"EPM\u5ba2\u6237\u7aef", (String)"OperationActionHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        OperationLogUtil.changeClientType(logInfo, false);
    }

    private static void changeClientType(AppLogInfo logInfo, boolean isEPM) {
        if (API.equals(logInfo.getClientType())) {
            logInfo.setClientType(WEB);
            logInfo.setClientName(isEPM ? ResManager.loadKDString((String)"EPM\u5ba2\u6237\u7aef", (String)"OperationActionHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]) : "OpenAPI");
        }
    }

    public static void batchWriteOperationLog(IFormView view, String opName, List<String> opDescriptions, Long modelId) {
        String bizEntityNumber = view.getModel().getDataEntityType().getName();
        if (CollectionUtils.isNotEmpty(opDescriptions)) {
            ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(opDescriptions.size());
            for (String opDescription : opDescriptions) {
                AppLogInfo logInfo = OperationLogUtil.buildLogInfo(opName, opDescription, modelId, bizEntityNumber);
                OperationLogUtil.setAppId(view, logInfo);
                OperationLogUtil.changeClientType(logInfo);
                appLogInfoList.add(logInfo);
            }
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addBatchLog(appLogInfoList);
        }
    }

    public static void batchWriteOperationLog(String opName, List<String> opDescriptions, Long modelId, String bizEntityNumber) {
        OperationLogUtil.batchWriteOperationLog(opName, opDescriptions, modelId, bizEntityNumber, true);
    }

    @Deprecated
    public static void batchWriteOperationLog(String opName, List<String> opDescriptions, Long modelId, String bizEntityNumber, boolean isEPM) {
        if (CollectionUtils.isNotEmpty(opDescriptions)) {
            ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(opDescriptions.size());
            for (String opDescription : opDescriptions) {
                AppLogInfo logInfo = OperationLogUtil.buildLogInfo(opName, opDescription, modelId, bizEntityNumber);
                OperationLogUtil.changeClientType(logInfo, isEPM);
                appLogInfoList.add(logInfo);
            }
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addBatchLog(appLogInfoList);
        }
    }

    public static void batchWriteOperationMutiLangLog(OpNameMultiLangEnumBridge opName, List<OPDescMultiLangEnumBridge> opDescriptions, Long modelId, String bizEntityNumber, boolean isEPM) {
        if (CollectionUtils.isNotEmpty(opDescriptions)) {
            ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(opDescriptions.size());
            for (OPDescMultiLangEnumBridge opDescription : opDescriptions) {
                AppLogInfo logInfo = OperationLogUtil.buildLogInfo(opName, opDescription, modelId, bizEntityNumber);
                OperationLogUtil.changeClientType(logInfo, isEPM);
                appLogInfoList.add(logInfo);
            }
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addBatchLog(appLogInfoList);
        }
    }

    public static void writeOperationLog(String opName, String opDescription, Long modelId, String bizEntityNumber) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo(opName, opDescription, modelId, bizEntityNumber);
        OperationLogUtil.changeClientType(logInfo);
        logService.addLog(logInfo);
    }

    @Deprecated
    public static void writeOperationLog(IFormView view, String opName, String opDescription, Long modelId) {
        String bizEntityNumber = view.getModel().getDataEntityType().getName();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo(opName, opDescription, modelId, bizEntityNumber);
        OperationLogUtil.setAppId(view, logInfo);
        OperationLogUtil.changeClientType(logInfo);
        logService.addLog(logInfo);
    }

    private static void setAppId(IFormView view, AppLogInfo logInfo) {
        String appId;
        if (Objects.nonNull(view) && StringUtils.isNotEmpty((String)(appId = view.getFormShowParameter().getAppId()))) {
            logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)appId).getId());
            return;
        }
        if (StringUtils.isNotEmpty((String)logInfo.getBizAppID())) {
            return;
        }
        appId = BIZAPPID;
        Object cacheAppId = ThreadCache.get((Object)"current_app_id");
        if (Objects.nonNull(cacheAppId)) {
            appId = (String)cacheAppId;
        }
        logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)appId).getId());
    }

    public static void writeOperationLog(AppLogInfo logInfo) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        OperationLogUtil.changeClientType(logInfo);
        logService.addLog(logInfo);
    }

    public static void writeConfigLog(DynamicObjectCollection entry, IPageCache pageCache, IFormView view, long modelId, boolean isOpen) {
        if (entry != null && entry.size() > 0 && view.getParentView() != null) {
            ArrayList<String> openList = new ArrayList<String>(entry.size());
            ArrayList<String> closeList = new ArrayList<String>(entry.size());
            String pageId = view.getPageId();
            for (DynamicObject row : entry) {
                String persetname = row.getString(PRESETNAME);
                String originStatus = pageCache.get(persetname + pageId);
                pageCache.remove(persetname + pageId);
                if (!StringUtils.isNotEmpty((String)originStatus) || row.getString(ISSHOW).equals(originStatus)) continue;
                if (row.getBoolean(ISSHOW)) {
                    openList.add(persetname);
                    continue;
                }
                closeList.add(persetname);
            }
            if (!openList.isEmpty()) {
                String openResult = String.format("%s %s , %s;%s%s", view.getModel().getDataEntity().getString("number"), Joiner.on((String)" ").join(openList), isOpen ? OpItemEnum.ISOPEN.getName() : OpItemEnum.ISSHOW.getName(), OpItemEnum.ENABLE.getName(), ResultStatusEnum.SUCCESS.getName());
                OperationLogUtil.writeOperationLog(view.getParentView(), isOpen ? OpItemEnum.ISOPEN.getName() : OpItemEnum.ISSHOW.getName(), openResult, modelId);
            }
            if (!closeList.isEmpty()) {
                String closeResult = String.format("%s %s , %s;%s%s", view.getModel().getDataEntity().getString("number"), Joiner.on((String)" ").join(closeList), isOpen ? OpItemEnum.ISOPEN.getName() : OpItemEnum.ISSHOW.getName(), OpItemEnum.DISABLE.getName(), ResultStatusEnum.SUCCESS.getName());
                OperationLogUtil.writeOperationLog(view.getParentView(), isOpen ? OpItemEnum.ISOPEN.getName() : OpItemEnum.ISSHOW.getName(), closeResult, modelId);
            }
        }
    }

    static {
        try {
            multiLangEnumBridgeClass = Class.forName("kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge");
            OpLogAppInfoClass = Class.forName("kd.bos.log.api.OpLogAppInfo");
            useOpLog = true;
        }
        catch (Exception ex) {
            useOpLog = false;
        }
    }
}

