/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.function.Consumer;
import kd.bos.context.OperationContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;

public class PlatUtil {
    public static String getOpMethod() {
        return OperationContext.get().getOpMethod();
    }

    public static void executeWithTXNew(Consumer<TXHandle> consumer) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                consumer.accept(txHandle);
            }
            catch (Throwable t) {
                txHandle.markRollback();
                throw t;
            }
        }
    }

    public static void executeWithTX(Consumer<TXHandle> consumer) {
        try (TXHandle txHandle = TX.required();){
            try {
                consumer.accept(txHandle);
            }
            catch (Throwable t) {
                txHandle.markRollback();
                throw t;
            }
        }
    }

    public static void executeIgoredExc(Consumer<Throwable> consumer) {
        try {
            consumer.accept(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryDLock(String key, String desc, boolean reentrant, int lockTime, Consumer<DLock> consumer) {
        block15: {
            try (DLock dc = reentrant ? DLock.createReentrant((String)key, (String)desc) : DLock.create((String)key, (String)desc);){
                if (!dc.tryLock((long)lockTime)) break block15;
                try {
                    consumer.accept(dc);
                }
                finally {
                    dc.unlock();
                }
            }
        }
    }
}

