/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.Arrays;
import java.util.List;

public class ProcessUtils {
    private static final List<String> zeroProcess = Arrays.asList("ERpt", "EIRpt", "ERAdj");
    private static final List<String> firstProcess = Arrays.asList("Rpt", "IRpt", "RAdj");
    private static final List<String> secondProcess = Arrays.asList("CCTotal", "CCADJ", "CC", "EJE", "PRPT", "CADJ", "ARPT", "ADJ", "TARPT", "TADJ", "TRpt");
    private static final List<String> threeProcess = Arrays.asList("CT", "CSTE", "SRPT", "ADJT", "SADJ", "SCADJ", "SCCADJ", "DADJ", "EJET", "SEJE", "DEJE");

    public static int getLevel(String process) {
        int level = -1;
        if (zeroProcess.contains(process)) {
            level = 0;
        } else if (firstProcess.contains(process)) {
            level = 1;
        } else if (secondProcess.contains(process)) {
            level = 2;
        } else if (threeProcess.contains(process)) {
            level = 3;
        }
        return level;
    }

    public static String getCurrenyTag(String process) {
        String result = "EC";
        int level = ProcessUtils.getLevel(process);
        if (level == 0 || level == 3) {
            result = "EC";
        } else if (level == 1 || level == 2) {
            result = "PC";
        }
        return result;
    }

    public static String getRealProcess(String bpNum) {
        if (zeroProcess.contains(bpNum)) {
            return firstProcess.get(zeroProcess.indexOf(bpNum));
        }
        return bpNum;
    }
}

