/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.register.ExternalFormulaLoader;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import org.apache.commons.io.IOUtils;

public class ResourcesLoaderUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringFromResources(String path) {
        try (InputStream in = ResourcesLoaderUtil.class.getClassLoader().getResourceAsStream(path);){
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"ResourcesLoaderUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static List<Map> getMapListFromResources(String path) {
        String str = ResourcesLoaderUtil.getStringFromResources(path);
        return JSON.parseArray((String)str, Map.class);
    }

    public static Formula getFormulaFromResources(String path) {
        String lowerCase = path.toLowerCase(Locale.ENGLISH);
        String str = ResourcesLoaderUtil.getStringFromResources(lowerCase);
        return (Formula)JSON.parseObject((String)str, Formula.class, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static Formula getFormulaByNumber(String formulaNumber) {
        Formula formula = (Formula)GlobalCacheServiceHelper.getOrLoadNodeFixKey((String)("formula-" + formulaNumber), () -> {
            Formula formula2 = FormulaConfig.getInstance().isInternalFormula(formulaNumber) || "bn".equalsIgnoreCase(formulaNumber) ? ResourcesLoaderUtil.getFormulaFromResources("bcmformula/" + formulaNumber + ".json") : ResourcesLoaderUtil.getExternalFormula(formulaNumber);
            return formula2;
        });
        return formula;
    }

    public static Formula getExternalFormula(String formulaName) {
        Map formula = ExternalFormulaLoader.getInstance().getFormulaConfig(formulaName);
        return (Formula)JSON.parseObject((String)JSON.toJSONString((Object)formula), Formula.class);
    }
}

