/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.template.model.FilterDimMember;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;
import kd.fi.bcm.spread.util.DynamicUtils;

public class SpreadMemUtil {
    public static List<Map<String, Set<String>>> analysisMemberFromSheet(SpreadManager sm, TemplateModel model, String ... selectDim) {
        List<Map<String, Set<String>>> mapList = DynamicUtils.isDynamicReport((SpreadManager)sm) ? SpreadMemUtil.analysisDynamicReport(sm, model, selectDim) : SpreadMemUtil.analysisFixReport(sm, model, selectDim);
        if (mapList != null && !mapList.isEmpty()) {
            mapList.forEach(map -> map.forEach((k, v) -> {
                v = v.stream().filter(mem -> !SystemVarsEnum.CURRENT.getNumber().equals(mem)).collect(Collectors.toSet());
                map.put(k, v);
            }));
        }
        return mapList;
    }

    private static List<Map<String, Set<String>>> analysisFixReport(SpreadManager sm, TemplateModel model, String ... selectDim) {
        ArrayList<Map<String, Set<String>>> list = new ArrayList<Map<String, Set<String>>>(10);
        for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
            Map<String, Set<String>> map = SpreadMemUtil.getNormalMap(sm, ps, model, selectDim);
            list.add(map);
        }
        return list;
    }

    private static Map<String, Set<String>> getNormalMap(SpreadManager sm, PositionInfo ps, TemplateModel model, String ... selectDim) {
        HashSet<String> numbers;
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        HashMap linkMap = new HashMap(16);
        Tuple t = sm.getAreaManager().getRowAndColDomainByPosition(ps);
        List<String> select = Arrays.asList(selectDim);
        for (IDimension iDimension : ((RowDimDomain)t.k).getDimensions()) {
            if (select.size() > 0 && !select.contains(iDimension.getNumber())) continue;
            numbers = new HashSet<String>(16);
            for (IDimMember iDimMember : iDimension.getMembers()) {
                numbers.add(iDimMember.getNumber());
            }
            map.put(iDimension.getNumber(), numbers);
        }
        for (IDimension iDimension : ((ColumnDimDomain)t.v).getDimensions()) {
            if (select.size() > 0 && !select.contains(iDimension.getNumber())) continue;
            numbers = new HashSet(16);
            for (IDimMember iDimMember : iDimension.getMembers()) {
                numbers.add(iDimMember.getNumber());
            }
            map.put(iDimension.getNumber(), numbers);
        }
        for (ViewPointDimensionEntry viewPointDimensionEntry : model.getViewPointDimensionEntries()) {
            if (select.size() > 0 && !select.contains(viewPointDimensionEntry.getDimension().getNumber())) continue;
            map.put(viewPointDimensionEntry.getDimension().getNumber(), Sets.newHashSet((Object[])new String[]{viewPointDimensionEntry.getMember().getNumber()}));
        }
        for (PageDimensionEntry pageDimensionEntry : model.getPageDimensionEntries()) {
            if (select.size() > 0 && !select.contains(pageDimensionEntry.getDimension().getNumber())) continue;
            numbers = new HashSet(16);
            for (Member member : pageDimensionEntry.getMembers()) {
                numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange(pageDimensionEntry.getDimension().getMemberEntityNumber(), member.getId(), member.getNumber(), member.getScope(), String.valueOf(model.getModelId()), DetailTypeEnum.OTHERS));
            }
            map.put(pageDimensionEntry.getDimension().getNumber(), numbers);
        }
        for (PageDimPropEntry pageDimPropEntry : model.getPagePropEntries()) {
            if (select.size() > 0 && !select.contains(pageDimPropEntry.getDimension().getNumber())) continue;
            numbers = new HashSet(16);
            for (MembProperty membProperty : pageDimPropEntry.getAllMembProperties()) {
                numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number(pageDimPropEntry.getDimension().getMemberEntityNumber(), membProperty.getId(), membProperty.getNumber(), membProperty.getScope(), String.valueOf(model.getModelId()), DetailTypeEnum.OTHERS));
            }
            map.put(pageDimPropEntry.getDimension().getNumber(), numbers);
        }
        for (FilterDimensionEntry filterDimensionEntry : model.getFilterDimensionEntries()) {
            List<FilterDimMember> members = filterDimensionEntry.getMembers();
            numbers = new HashSet(16);
            for (FilterDimMember m : members) {
                numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange(m.getDimension().getMemberEntityNumber(), m.getId(), m.getNumber(), 50, String.valueOf(model.getModelId()), DetailTypeEnum.OTHERS));
            }
            linkMap.put(filterDimensionEntry.getDimension().getNumber(), numbers);
        }
        for (Map.Entry entry : linkMap.entrySet()) {
            Set linkMem = (Set)entry.getValue();
            map.put((String)entry.getKey(), linkMem);
        }
        return map;
    }

    private static List<Map<String, Set<String>>> analysisDynamicReport(SpreadManager sm, TemplateModel model, String ... selectDim) {
        ArrayList<Map<String, Set<String>>> list = new ArrayList<Map<String, Set<String>>>(10);
        List<String> select = Arrays.asList(selectDim);
        ArrayList<String> unScope = new ArrayList<String>();
        for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
            if (ps.getExtendInfo() != null) continue;
            unScope.clear();
            Map<String, Set<String>> map = SpreadMemUtil.getNormalMap(sm, ps, model, selectDim);
            for (BasePointInfo bp : ps.getBasePoints()) {
                for (BasePointInnerLineInfo info : bp.getBasePointInnerLineInfo()) {
                    if (select.size() > 0 && !select.contains(info.getDimension().getNumber())) continue;
                    ArrayList<Object> numbers = new ArrayList<Object>();
                    List scope = info.getDynaMembScopes();
                    if (scope.size() == 0) {
                        if (info.isFloated()) {
                            String modelNumber = MemberReader.findModelNumberById((Object)model.getModelId());
                            IDNumberTreeNode memberNode = MemberReader.findMemberByNumber((String)modelNumber, (String)info.getDimension().getNumber(), (String)info.getDimension().getNumber());
                            Set numberSet = memberNode.getAllChildren().stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
                            numbers.addAll(numberSet);
                            Set<String> li = map.get(info.getDimension().getNumber());
                            if (li == null) {
                                li = new HashSet<String>();
                            }
                            li.addAll(numbers);
                            map.put(info.getDimension().getNumber(), li);
                            continue;
                        }
                        unScope.add(info.getDimension().getNumber());
                        continue;
                    }
                    for (DynaMembScopeInfo scinfo : scope) {
                        if (scinfo.isCustom()) {
                            numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number(scinfo.getMember().getDimension().getUqCode(), ((DimMember)scinfo.getMember()).getId(), scinfo.getMember().getNumber(), scinfo.getRangeId(), String.valueOf(model.getModelId()), DetailTypeEnum.OTHERS));
                            continue;
                        }
                        numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange(scinfo.getMember().getDimension().getUqCode(), ((DimMember)scinfo.getMember()).getId(), ((DimMember)scinfo.getMember()).getNumber(), scinfo.getRangeId(), String.valueOf(model.getModelId()), DetailTypeEnum.OTHERS));
                    }
                    Set<String> li = map.get(info.getDimension().getNumber());
                    if (li == null) {
                        li = new HashSet<String>();
                    }
                    li.addAll(numbers);
                    map.put(info.getDimension().getNumber(), li);
                }
            }
            for (String s : unScope) {
                map.remove(s);
            }
            list.add(map);
        }
        return list;
    }

    public static SpreadManager getSpreadManager(long id) {
        Row row;
        String spreadSerial = null;
        String tmpdata = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_reportentity", (String)"data", (QFilter[])new QFilter("id", "=", (Object)id).toArray(), null);){
            if (ds.hasNext()) {
                row = ds.next();
                spreadSerial = row.getString("data");
            }
        }
        if (StringUtils.isEmpty(spreadSerial)) {
            ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_reportlistentity", (String)"template.rptdata", (QFilter[])new QFilter("id", "=", (Object)id).toArray(), null);
            var5_4 = null;
            try {
                if (ds.hasNext()) {
                    row = ds.next();
                    tmpdata = row.getString("template.rptdata");
                }
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var5_4 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var5_4.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            spreadSerial = tmpdata;
        }
        return JsonSerializerUtil.toSpreadManager((String)spreadSerial);
    }

    public static String getMemFromFilter(SpreadManager spread, String dimnum) {
        ArrayList pageAndViewDim = new ArrayList(spread.getFilter().getPageDomain().getDimensions());
        pageAndViewDim.addAll(spread.getFilter().getViewPointDomain().getDimensions());
        for (IDimension dim : pageAndViewDim) {
            if (!dim.getNumber().equals(dimnum)) continue;
            return ((IDimMember)dim.getMembers().get(0)).getNumber();
        }
        return null;
    }

    public static SpreadManager querySpreadManager(Long templateid) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_templateentity", (String)"rptdata", (QFilter[])new QFilter("id", "=", (Object)templateid).toArray(), null);){
            if (ds.hasNext()) {
                SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)ds.next().getString("rptdata"));
                return spreadManager;
            }
        }
        return null;
    }

    public static Pair<Set<String>, Set<String>> getFixAndFloatDimByPositionInfo(PositionInfo pos) {
        if (pos.getBasePoints().isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u533a\u57df\u201c%s\u201d\u4e3a\u975e\u6d6e\u52a8\u533a\u57df\u3002", (String)"SpreadMemUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]), pos.getAreaRange()));
        }
        Set floatDims = ((BasePointInfo)pos.getBasePoints().get(0)).getBasePointInnerLineInfo().stream().map(line -> line.getDimension().getNumber()).collect(Collectors.toSet());
        Set fixDims = ((List)((BasePointInfo)pos.getBasePoints().get(0)).getFixMemberPosition().values().stream().findFirst().get()).stream().map(m -> m.getDimension().getNumber()).collect(Collectors.toSet());
        return Pair.onePair(fixDims, floatDims);
    }
}

