/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.collect.DisBitSet;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.template.DisEffectWayEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;

public class TemplateDistributionOrgUtil {
    private static final String TEMPLATE_DIS_SELECTFIELDS = "id,template,entity,memrangdecombo,definedproperty,definedpropertyvalue,effectway";

    public static Set<String> getOrgDisTemplateSet(Object modelId, Long orgId) {
        HashSet<String> templateIds = new HashSet<String>(16);
        Set<Long> disTemplateByOrg = TemplateDistributionOrgUtil.getDisTemplateByOrg(modelId, orgId);
        if (!disTemplateByOrg.isEmpty()) {
            disTemplateByOrg.forEach(k -> templateIds.add(Long.toString(k)));
        }
        return templateIds;
    }

    public static Set<Long> getDisTemplateByOrg(Object modelId, Long orgId) {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        Map<Long, Set<Long>> template2OrgMapOfDispense = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(LongUtil.toLong((Object)modelId));
        template2OrgMapOfDispense.forEach((k, v) -> {
            if (v.contains(orgId)) {
                templateIds.add((Long)k);
            }
        });
        return templateIds;
    }

    public static Set<Long> getOrgIdsByTemplateDis(Object modelId, Long templateId) {
        Set<Long> orgSet = new HashSet<Long>(16);
        Map<Long, Set<Long>> template2OrgMapOfDispense = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(LongUtil.toLong((Object)modelId));
        if (template2OrgMapOfDispense.get(templateId) != null) {
            orgSet = template2OrgMapOfDispense.get(templateId);
        }
        return orgSet;
    }

    public static Map<Long, Set<Long>> getOrgDisTemplateMap(Object modelId, Set<Long> orgIds) {
        HashMap<Long, Set<Long>> orgDisTempl = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> template2OrgMapOfDispense = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(LongUtil.toLong((Object)modelId));
        if (!template2OrgMapOfDispense.isEmpty() && !orgIds.isEmpty()) {
            template2OrgMapOfDispense.forEach((k, v) -> orgIds.forEach(orgId -> {
                if (orgDisTempl.get(orgId) == null) {
                    orgDisTempl.put((Long)orgId, new HashSet(16));
                }
                if (v.contains(orgId)) {
                    Set templates = (Set)orgDisTempl.get(orgId);
                    templates.add(k);
                }
            }));
        }
        return orgDisTempl;
    }

    public static Map<Long, Set<Long>> getTemplate2OrgMapOfDispense(Long modelId) {
        if (modelId == null) {
            return new HashMap<Long, Set<Long>>();
        }
        Map<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String cache = AppCacheServiceHelper.getTemplateDispenseCache(modelNum);
        if (StringUtils.isNotEmpty((String)cache)) {
            if (DisBitSet.isByteSerialized((String)cache)) {
                try {
                    map = new DisBitSet(cache, Long.class, Long.class).toMap();
                }
                catch (Exception e) {
                    map = null;
                }
            } else {
                return (Map)ObjectSerialUtil.deSerializedBytes((String)cache);
            }
        }
        if (map == null || map.isEmpty()) {
            map = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(modelId, null);
            DisBitSet ds = new DisBitSet(map);
            AppCacheServiceHelper.cacheTemplateDispenseCache(modelNum, ds.toByteSerialized());
        }
        return map;
    }

    public static Map<Long, Set<Long>> getTemplate2OrgMapOfDispense(Long modelId, Set<Long> templateIds, Set<Long> dispenseOrgIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Map localCache = (Map)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("template_dis_cache_" + modelNum), () -> {
            String serial = AppCacheServiceHelper.getTemplateDispenseCacheByPart(modelNum);
            if (DisBitSet.isByteSerialized((String)serial)) {
                try {
                    return new DisBitSet(serial, Long.class, Long.class).toMap();
                }
                catch (Exception e) {
                    serial = null;
                }
            }
            if (StringUtils.isNotEmpty((String)serial)) {
                return (Map)ObjectSerialUtil.parseObject((String)serial, (TypeReference)new TypeReference<Map<Long, Set<Long>>>(){}, (Feature[])new Feature[0]);
            }
            return TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(modelId, templateIds);
        });
        templateIds.forEach(id -> {
            Set allOrgSet = (Set)localCache.get(id);
            if (allOrgSet != null) {
                map.put((Long)id, (Set<Long>)(dispenseOrgIds.isEmpty() ? new HashSet(allOrgSet) : dispenseOrgIds.stream().filter(p -> allOrgSet.contains(p)).collect(Collectors.toSet())));
            }
        });
        templateIds.removeAll(localCache.keySet());
        if (!templateIds.isEmpty()) {
            Map<Long, Set<Long>> diffMap = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(modelId, templateIds);
            templateIds.forEach(id -> {
                if (diffMap.containsKey(id)) {
                    Set allOrgSet = (Set)diffMap.get(id);
                    map.put((Long)id, (Set<Long>)(dispenseOrgIds.isEmpty() ? new HashSet(allOrgSet) : dispenseOrgIds.stream().filter(p -> allOrgSet.contains(p)).collect(Collectors.toSet())));
                }
            });
            templateIds.forEach(e -> localCache.compute(e, (k, v) -> diffMap.containsKey(e) ? (Set)diffMap.get(e) : new HashSet(0)));
            DisBitSet ds = new DisBitSet(localCache);
            AppCacheServiceHelper.cacheTemplateDispenseCacheByPart(modelNum, ds.toByteSerialized());
            GlobalCacheServiceHelper.replaceCache((CacheTypeEnum)CacheTypeEnum.CommonCache, (String)("template_dis_cache_" + modelNum), (Object)localCache);
        }
        return map;
    }

    private static Set<Long> queryRateEntity(long modelId) {
        return (Set)ThreadCache.get((Object)String.join((CharSequence)"|", "queryRateEntity", modelId + ""), () -> {
            HashSet<Long> rateOrgs = new HashSet<Long>(16);
            IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"RateEntity");
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                rateOrgs.add(node.getId());
                rateOrgs.addAll(node.getAllChildrenIds());
                if (node.getParent() != null) {
                    rateOrgs.add(node.getParent().getId());
                }
            }
            return rateOrgs;
        });
    }

    public static Map<Long, Set<Long>> getTemplate2OrgMapOfDispense(Long modelId, Set<Long> templateIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        HashMultimap<Long, MembRangeItem> dispenses = TemplateDistributionOrgUtil.getTemplateDispenseMap(modelId, templateIds);
        Set<Long> rateOrgs = TemplateDistributionOrgUtil.queryRateEntity(modelId);
        dispenses.entries().forEach(e -> {
            Set temp = map.computeIfAbsent((Long)e.getKey(), c -> new HashSet());
            MembRangeItem membRangeItem = (MembRangeItem)e.getValue();
            if (membRangeItem.isApply()) {
                temp.addAll((Collection)ThreadCache.get((Object)membRangeItem.genKey(null), () -> {
                    HashSet ids = new HashSet();
                    membRangeItem.matchItems(c -> ids.add((Long)c.id));
                    ids.removeAll(rateOrgs);
                    return MemberReader.change2BaseMember((long)modelId, (String)"bcm_entitymembertree", ids);
                }));
            }
        });
        dispenses.entries().forEach(e -> {
            MembRangeItem membRangeItem;
            Set temp = map.computeIfAbsent((Long)e.getKey(), c -> new HashSet());
            if (!temp.isEmpty() && !(membRangeItem = (MembRangeItem)e.getValue()).isApply()) {
                temp.removeAll((Collection)ThreadCache.get((Object)membRangeItem.genKey(null), () -> {
                    HashSet ids = new HashSet();
                    membRangeItem.matchItems(c -> ids.add((Long)c.id));
                    return MemberReader.change2BaseMember((long)modelId, (String)"bcm_entitymembertree", ids);
                }));
            }
        });
        return map;
    }

    public static HashMultimap<Long, MembRangeItem> getTemplateDispenseMap(Long modelId, Set<Long> templateIds) {
        DynamicObject[] coll;
        HashMultimap dispenses = HashMultimap.create();
        for (DynamicObject dis : coll = TemplateDistributionOrgUtil.queryDistributeCollectionByTemplate(templateIds, modelId.toString())) {
            DynamicObject dyna = dis.getDynamicObject("entity");
            if (dyna != null) {
                long org = dyna.getLong("id");
                dispenses.put((Object)dis.getLong("template.id"), (Object)new MembRangeItem("bcm_entitymembertree", org, dyna.getString("longnumber"), dyna.getString("number"), RangeEnum.getRangeByVal((int)dis.getInt("memrangdecombo")), false, modelId, DisEffectWayEnum.isApply((int)dis.getInt("effectway"))));
                continue;
            }
            dyna = dis.getDynamicObject("definedpropertyvalue");
            if (dyna == null) continue;
            dispenses.put((Object)dis.getLong("template.id"), (Object)new MembRangeItem("bcm_entitymembertree", dyna.getLong("id"), dyna.getString("longnumber"), dyna.getString("number"), RangeEnum.getRangeByVal((int)dis.getInt("memrangdecombo")), true, modelId, DisEffectWayEnum.isApply((int)dis.getInt("effectway"))));
        }
        return dispenses;
    }

    private static DynamicObject[] queryDistributeCollectionByTemplate(Collection<Long> tempalteIds, Object modelid) {
        QFilter filter1 = new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong(modelid));
        if (tempalteIds != null) {
            filter1.and(new QFilter("template", "in", tempalteIds));
        }
        return BusinessDataServiceHelper.loadFromCache((String)"bcm_distributionentity", (String)TEMPLATE_DIS_SELECTFIELDS, (QFilter[])filter1.toArray()).values().toArray(new DynamicObject[0]);
    }

    public static Set<Long> getDispenseTemplateIds(Object modelId) {
        Collection collection = BusinessDataServiceHelper.loadFromCache((String)"bcm_distributionentity", (String)"template.id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId))}).values();
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(16);
        collection.forEach(dyo -> ids.add(dyo.getLong("template.id")));
        return ids;
    }

    public static void updateOldDistribuition(long modelId) {
        String sql = "select feffectway from t_bcm_distribution where fmodel = ? and feffectway not in (?,?)";
        try (TXHandle tx = TX.required();){
            try {
                DataSet dataSet = DB.queryDataSet((String)"version", (DBRoute)BCMConstant.DBROUTE, (String)sql, (Object[])new Object[]{modelId, DisEffectWayEnum.APPLY.getIndex() + "", DisEffectWayEnum.EXCEPETION.getIndex() + ""});
                if (dataSet.hasNext()) {
                    sql = "update t_bcm_distribution set feffectway = ? where fmodel = ? and feffectway not in (?,?)";
                    DB.update((DBRoute)BCMConstant.DBROUTE, (String)sql, (Object[])new Object[]{DisEffectWayEnum.APPLY.getIndex() + "", modelId, DisEffectWayEnum.APPLY.getIndex() + "", DisEffectWayEnum.EXCEPETION.getIndex() + ""});
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
    }
}

