/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.cache.MembPermCacheManager;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.reportlist.cache.ReportRedisCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntry;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class TemplateRangeService {
    private static boolean isDoCollect = false;

    public static boolean isInnerRange(String entity, TemplateModel template, Object cpId, Object defId) {
        Object defCpId = defId;
        RangeStatus status = new RangeStatus();
        TemplateRangeService.handleViewPointRange(status, entity, template, cpId, defCpId);
        TemplateRangeService.handlePageDimRange(status, entity, template, cpId, defCpId);
        TemplateRangeService.handlePagePropRange(status, entity, template, cpId, defCpId);
        TemplateRangeService.handleInnerRowOrColRange(status, entity, template);
        return status.isInner;
    }

    public static boolean isInnerRangeNotAnalyCY(String entity, TemplateModel template, Object cpId, Object defId) {
        RangeStatus status = new RangeStatus();
        TemplateRangeService.handleViewPointRange(status, entity, template, defId, null);
        TemplateRangeService.handlePageDimRange(status, entity, template, defId, null);
        TemplateRangeService.handlePagePropRange(status, entity, template, defId, null);
        TemplateRangeService.handleInnerRowOrColRange(status, entity, template);
        return status.isInner;
    }

    public static boolean isInnerRange(String entity, TemplateModel template, Object cpId, boolean isCollect) {
        isDoCollect = isCollect;
        RangeStatus status = new RangeStatus();
        TemplateRangeService.handleViewPointRange(status, entity, template, cpId, null);
        TemplateRangeService.handlePageDimRange(status, entity, template, cpId, null);
        TemplateRangeService.handlePagePropRange(status, entity, template, cpId, null);
        TemplateRangeService.handleInnerRowOrColRange(status, entity, template);
        return status.isInner;
    }

    public static boolean isInnerRange(String entity, TemplateModel template, Object cpId) {
        RangeStatus status = new RangeStatus();
        TemplateRangeService.handleViewPointRange(status, entity, template, cpId, null);
        TemplateRangeService.handlePageDimRange(status, entity, template, cpId, null);
        TemplateRangeService.handlePagePropRange(status, entity, template, cpId, null);
        TemplateRangeService.handleInnerRowOrColRange(status, entity, template);
        return status.isInner;
    }

    public static boolean isInnerRangeBatch(String entity, TemplateModel template, Set<Long> cpIds) {
        return cpIds.stream().anyMatch(cpId -> {
            RangeStatus status = new RangeStatus();
            TemplateRangeService.handleViewPointRange(status, entity, template, cpId, null);
            TemplateRangeService.handlePageDimRange(status, entity, template, cpId, null);
            TemplateRangeService.handlePagePropRange(status, entity, template, cpId, null);
            TemplateRangeService.handleInnerRowOrColRange(status, entity, template);
            return status.isInner;
        });
    }

    public static boolean isViewInnerRange(String entity, TemplateModel template, Object cpId) {
        RangeStatus status = new RangeStatus();
        List<ViewPointDimensionEntry> list = template.getViewPointDimensionEntries();
        boolean isEnityInView = false;
        for (ViewPointDimensionEntry e : list) {
            if (!e.getDimension().getMemberEntityNumber().equals(entity)) continue;
            isEnityInView = true;
            break;
        }
        if (isEnityInView) {
            TemplateRangeService.handleViewPointRange(status, entity, template, cpId, null);
        } else {
            status.isInner = true;
        }
        return status.isInner;
    }

    public static boolean isInnerPageRange(String entity, TemplateModel template, Object cpId) {
        RangeStatus status = new RangeStatus();
        TemplateRangeService.handlePageDimRange(status, entity, template, cpId, null);
        TemplateRangeService.handlePagePropRange(status, entity, template, cpId, null);
        return status.isInner;
    }

    public static Set<String> findMembsBySpecificDim(String dimNum, TemplateModel template) {
        HashSet<String> membs = new HashSet<String>();
        block0: for (AreaRangeEntry areaRangeEntry : template.getAreaRangeEntries()) {
            for (RowDimensionEntry rowDimensionEntry : areaRangeEntry.getRowDimEntries()) {
                if (!rowDimensionEntry.getDimension().getNumber().equals(dimNum)) continue;
                rowDimensionEntry.getMembers().forEach(m -> membs.add(m.getNumber()));
                break;
            }
            for (ColDimensionEntry colDimensionEntry : areaRangeEntry.getColDimEntries()) {
                if (!colDimensionEntry.getDimension().getNumber().equals(dimNum)) continue;
                colDimensionEntry.getMembers().forEach(m -> membs.add(m.getNumber()));
                continue block0;
            }
        }
        for (ViewPointDimensionEntry viewPointDimensionEntry : template.getViewPointDimensionEntries()) {
            if (!viewPointDimensionEntry.getDimension().getNumber().equals(dimNum)) continue;
            membs.add(viewPointDimensionEntry.getMember().getNumber());
            return membs;
        }
        for (PageDimensionEntry pageDimensionEntry : template.getPageDimensionEntries()) {
            if (!pageDimensionEntry.getDimension().getNumber().equals(dimNum)) continue;
            pageDimensionEntry.getMembers().forEach(m -> new MembRangeItem(pageDimensionEntry.getDimension().getMemberEntityNumber(), (Long)m.getId(), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, (Object)template.getModelId()).matchItems(c -> membs.add(c.number)));
        }
        for (PageDimPropEntry pageDimPropEntry : template.getPagePropEntries()) {
            if (!pageDimPropEntry.getDimension().getNumber().equals(dimNum)) continue;
            pageDimPropEntry.getAllMembProperties().forEach(p -> new MembRangeItem(pageDimPropEntry.getDimension().getMemberEntityNumber(), (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, (Object)template.getModelId()).matchItems(c -> membs.add(c.number)));
        }
        return membs;
    }

    public static void handleInnerRowOrColRange(RangeStatus status, String entity, TemplateModel template) {
        boolean isNotInPageOrViewDim;
        if (status.isInner) {
            return;
        }
        boolean bl = isNotInPageOrViewDim = template.getViewPointDimensionEntries().stream().noneMatch(p -> p.getDimension().getMemberEntityNumber().equals(entity)) && template.getPageDimensionEntries().stream().noneMatch(p -> p.getDimension().getMemberEntityNumber().equals(entity)) && template.getPagePropEntries().stream().noneMatch(p -> p.getDimension().getMemberEntityNumber().equals(entity));
        if (!status.isInner && isNotInPageOrViewDim) {
            status.isInner = true;
        }
    }

    public static void handleViewPointRange(RangeStatus status, String entity, TemplateModel template, Object cpId, Object defCpId) {
        if (status.isInner) {
            return;
        }
        List<ViewPointDimensionEntry> list = template.getViewPointDimensionEntries();
        for (ViewPointDimensionEntry e : list) {
            if (!e.getDimension().getMemberEntityNumber().equals(entity) || !cpId.equals(e.getMember().getId())) continue;
            status.isInner = true;
            break;
        }
    }

    public static boolean handleViewPointRange(String entity, TemplateModel template) {
        for (ViewPointDimensionEntry entry : template.getViewPointDimensionEntries()) {
            if (!entry.getDimension().getMemberEntityNumber().equals(entity)) continue;
            return true;
        }
        return false;
    }

    public static void handlePageDimRange(RangeStatus status, String entity, TemplateModel template, Object cpId, Object defCpId) {
        if (status.isInner) {
            return;
        }
        template.getPageDimensionEntries().stream().anyMatch(e -> {
            if (e.getDimension().getMemberEntityNumber().equals(entity)) {
                e.getMembers().stream().anyMatch(m -> {
                    if (defCpId != null) {
                        boolean isMatchedDe = new MembRangeItem(entity, (Long)m.getId(), m.getNumber(), m.getScope(), false, (Object)template.getModelId()).isMatched(defCpId);
                        boolean isMatched = new MembRangeItem(entity, (Long)m.getId(), m.getNumber(), m.getScope(), false, (Object)template.getModelId()).isMatched(cpId);
                        if (isMatched || isMatchedDe) {
                            status.isInner = true;
                        }
                        return status.isInner;
                    }
                    boolean isMatched = new MembRangeItem(entity, (Long)m.getId(), m.getNumber(), m.getScope(), false, (Object)template.getModelId()).isMatched(cpId);
                    if (isMatched) {
                        status.isInner = true;
                    }
                    return status.isInner;
                });
            }
            return status.isInner;
        });
    }

    public static void handleFilterDimRange(RangeStatus status, String entity, TemplateModel template, Object cpId, Object defCpId) {
        if (status.isInner) {
            return;
        }
        boolean isHasOrg = template.getFilterDimensionEntries().stream().anyMatch(e -> e.getDimension().getMemberEntityNumber().equals(entity));
        if (!isHasOrg) {
            status.isInner = true;
            return;
        }
        template.getFilterDimensionEntries().stream().anyMatch(e -> {
            if (e.getDimension().getMemberEntityNumber().equals(entity)) {
                e.getMembers().stream().anyMatch(m -> {
                    if (defCpId != null) {
                        boolean isMatchedDe = new MembRangeItem(entity, (Long)m.getId(), m.getNumber(), m.getScope(), false, (Object)template.getModelId()).isMatched(defCpId);
                        boolean isMatched = new MembRangeItem(entity, (Long)m.getId(), m.getNumber(), m.getScope(), false, (Object)template.getModelId()).isMatched(cpId);
                        if (isMatched || isMatchedDe) {
                            status.isInner = true;
                        }
                        return status.isInner;
                    }
                    boolean isMatched = new MembRangeItem(entity, (Long)m.getId(), m.getNumber(), m.getScope(), false, (Object)template.getModelId()).isMatched(cpId);
                    if (isMatched) {
                        status.isInner = true;
                    }
                    return status.isInner;
                });
            }
            return status.isInner;
        });
    }

    public static void handlePagePropRange(RangeStatus status, String entity, TemplateModel template, Object cpId, Object defCpId) {
        if (status.isInner) {
            return;
        }
        template.getPagePropEntries().stream().anyMatch(e -> {
            if (e.getDimension().getMemberEntityNumber().equals(entity)) {
                e.getAllMembProperties().stream().anyMatch(p -> {
                    if (defCpId != null) {
                        boolean isMatchedDe = new MembRangeItem(entity, (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, (Object)template.getModelId()).isMatched(defCpId);
                        boolean isMatch = new MembRangeItem(entity, (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, (Object)template.getModelId()).isMatched(cpId);
                        if (isMatch || isMatchedDe) {
                            status.isInner = true;
                        }
                        return status.isInner;
                    }
                    boolean isMatch = new MembRangeItem(entity, (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, (Object)template.getModelId()).isMatched(cpId);
                    if (isMatch) {
                        status.isInner = true;
                    }
                    return status.isInner;
                });
            }
            return status.isInner;
        });
    }

    public static void handleFilterPropRange(RangeStatus status, String entity, TemplateModel template, Object cpId, Object defCpId) {
        if (status.isInner) {
            return;
        }
        boolean isHasOrg = template.getFilterDimensionEntries().stream().anyMatch(e -> e.getDimension().getMemberEntityNumber().equals(entity));
        if (!isHasOrg) {
            status.isInner = true;
            return;
        }
        template.getFilterDimensionEntries().stream().anyMatch(e -> {
            if (e.getDimension().getMemberEntityNumber().equals(entity)) {
                e.getMembers().stream().anyMatch(p -> {
                    if (p.isCustom()) {
                        if (defCpId != null) {
                            boolean isMatchedDe = new MembRangeItem(entity, (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, (Object)template.getModelId()).isMatched(defCpId);
                            boolean isMatch = new MembRangeItem(entity, (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, (Object)template.getModelId()).isMatched(cpId);
                            if (isMatch || isMatchedDe) {
                                status.isInner = true;
                            }
                            return status.isInner;
                        }
                        boolean isMatch = new MembRangeItem(entity, (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, (Object)template.getModelId()).isMatched(cpId);
                        if (isMatch) {
                            status.isInner = true;
                        }
                        return status.isInner;
                    }
                    return status.isInner;
                });
            }
            return status.isInner;
        });
    }

    public static List<TemplateModel> getWholeTemplateModels(Collection<?> ids) {
        Pair<List<TemplateModel>, Collection<Object>> pairs = TemplateServiceHelper.getTemplateModelsFromCache(ids);
        List templateModels = (List)pairs.p1;
        ((Collection)pairs.p2).forEach(id -> templateModels.add(TemplateServiceHelper.getTemplateModelById(id)));
        return templateModels;
    }

    public static List<TemplateModel> getTemplateModels(Collection<?> ids, long modelId, boolean isExcludeNoFormulaTemplate, boolean isOnlyWeaveTmpl) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<TemplateModel>(16);
        }
        if (isExcludeNoFormulaTemplate) {
            // empty if block
        }
        Set tmIds = ids.stream().map(i -> LongUtil.toLong((Object)i)).collect(Collectors.toSet());
        return ReportRedisCache.queryTemplateModelFromCache(tmIds, modelId, isOnlyWeaveTmpl);
    }

    public static DynamicObjectCollection getHavePermOrgSetWithShare(Object modelId) {
        DynamicObjectCollection orgs = TemplateRangeService.getHavePermOrgSet(modelId);
        List numbers = orgs.stream().map(e -> e.getString("number")).collect(Collectors.toList());
        DynamicObjectCollection allOrgsWithShare = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,copyfrom,longnumber", (QFilter[])new QFBuilder().add("number", "in", numbers).add("model", "=", (Object)LongUtil.toLong((Object)modelId)).toArray());
        return allOrgsWithShare;
    }

    public static DynamicObjectCollection getHavePermAllDataOrgSetWithShare(Object modelId, boolean isleaf) {
        DynamicObjectCollection orgs = TemplateRangeService.getHavePermOrgSet(modelId, isleaf);
        List numbers = orgs.stream().map(e -> e.getString("number")).collect(Collectors.toList());
        DynamicObjectCollection allData = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,isleaf,copyfrom,longNumber,bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate, namechangerds.namerds,namechangerds.nameeffdate,namechangerds.nameexpdate", (QFilter[])new QFBuilder().add("number", "in", numbers).add("model", "=", (Object)LongUtil.toLong((Object)modelId)).toArray(), (String)"dseq, bizchangerds.seq, namechangerds.seq");
        return allData;
    }

    public static DynamicObjectCollection getHavePermOrgSet(Object modelId) {
        return TemplateRangeService.getHavePermOrgSet(modelId, true);
    }

    public static DynamicObjectCollection getHavePermOrgSet(Object modelId, boolean isleaf) {
        Long dimId = MemberReader.getDimensionIdByNum((long)LongUtil.toLong((Object)modelId), (String)"Entity");
        QFilter qf = PermissionServiceImpl.getInstance(LongUtil.toLong((Object)modelId)).getWritePermFilter(dimId, "bcm_entitymembertree", "id");
        qf.and("model", "=", (Object)LongUtil.toLong((Object)modelId));
        qf.and("isleaf", "=", (Object)(isleaf ? "1" : "0"));
        qf.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        qf.and("parent", "!=", (Object)0L);
        qf.and("isexchangerate", "=", (Object)false);
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,longnumber", (QFilter[])qf.toArray(), (String)"id asc");
    }

    public static DynamicObjectCollection getHavePermOrgSet_task(Object modelId) {
        MembPermCacheManager membPermCacheManager = new MembPermCacheManager(modelId);
        Pair<Integer, Set<Long>> perms = membPermCacheManager.getMembPermInfo(DimTypesEnum.ENTITY.getNumber());
        QFBuilder qfb = new QFBuilder().add("model", "=", modelId);
        qfb.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        qfb.add("parent", "!=", (Object)0L);
        qfb.add("isexchangerate", "=", (Object)false);
        boolean isManager = MemberPermHelper.getLimitedModelListByUser().contains(modelId);
        if (isManager) {
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,isleaf", (QFilter[])qfb.toArray(), (String)"longnumber asc,level asc");
            return orgs;
        }
        DynamicObjectCollection orgs = (Integer)perms.p1 == 0 ? (((Set)perms.p2).isEmpty() ? new DynamicObjectCollection() : QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,isleaf", (QFilter[])qfb.add("id", "in", (Object)((Set)perms.p2).toArray()).toArray(), (String)"longnumber asc,level asc")) : (((Set)perms.p2).isEmpty() ? QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,isleaf", (QFilter[])qfb.toArray(), (String)"longnumber asc,level asc") : QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,isleaf", (QFilter[])qfb.add("id", "not in", (Object)((Set)perms.p2).toArray()).toArray(), (String)"longnumber asc,level asc"));
        return orgs;
    }

    public static Set<Long> getAllTemplateIdByModel(Object modelId) {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(16);
        for (DynamicObject e : QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", modelId).and("isfintemplate", "=", (Object)"1")})) {
            ids.add(e.getLong("id"));
        }
        return ids;
    }

    public static List<TemplateModel> getCompleteTemplateModels(Collection<?> ids) {
        DynamicObjectCollection memColl;
        ArrayList<TemplateModel> templates = new ArrayList<TemplateModel>(10);
        DynamicObject[] dynas = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"));
        HashMap<String, Set> idMap = new HashMap<String, Set>(10);
        HashMap<String, Set> idViewPointMap = new HashMap<String, Set>(10);
        for (DynamicObject dyna : dynas) {
            Object entry2;
            DynamicObjectCollection entries = dyna.getDynamicObjectCollection("pagemembentry");
            for (Object entry2 : entries) {
                DynamicObject dim = entry2.getDynamicObject("pagedimension");
                Long memId = entry2.getLong("pagemembid");
                Set memIds = idMap.computeIfAbsent(dim.getString("membermodel"), key -> new HashSet());
                memIds.add(memId);
            }
            DynamicObjectCollection viePointEntries = dyna.getDynamicObjectCollection("viewpointmembentry");
            entry2 = viePointEntries.iterator();
            while (entry2.hasNext()) {
                DynamicObject entry3 = (DynamicObject)entry2.next();
                DynamicObject dim = entry3.getDynamicObject("viewdimension");
                Long memId = entry3.getLong("viewmembid");
                Set memIds = idViewPointMap.computeIfAbsent(dim.getString("membermodel"), key -> new HashSet());
                memIds.add(memId);
            }
        }
        HashMap<String, DynamicObject> memMap = new HashMap<String, DynamicObject>(10);
        HashMap<String, DynamicObject> viewPointMap = new HashMap<String, DynamicObject>(10);
        String selectFields = "id,name,number";
        for (Map.Entry entry : idMap.entrySet()) {
            memColl = QueryServiceHelper.query((String)((String)entry.getKey()), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            for (DynamicObject obj : memColl) {
                memMap.put((String)entry.getKey() + "|" + obj.getLong("id"), obj);
            }
        }
        for (Map.Entry entry : idViewPointMap.entrySet()) {
            memColl = QueryServiceHelper.query((String)((String)entry.getKey()), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            for (DynamicObject obj : memColl) {
                viewPointMap.put((String)entry.getKey() + "|" + obj.getLong("id"), obj);
            }
        }
        ThreadCache.put((Object)"dim-mem", memMap);
        ThreadCache.put((Object)"dim-mem-viewpoint", viewPointMap);
        for (DynamicObject d : dynas) {
            TemplateModel t = new TemplateModel();
            t.loadDynaObj2Model(d);
            t.setUsage(d.getString("usage"));
            templates.add(t);
        }
        ThreadCache.remove((Object)"dim-mem");
        ThreadCache.remove((Object)"dim-mem-viewpoint");
        return templates;
    }

    public static Map<Long, Set<Long>> queryDistributeCollectionByModelIdForExcel(Object modelId, Set<Long> orgIds) {
        Collection<DynamicObject> templateCollections = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)"id, number, versionnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", modelId), new QFilter("status", "=", (Object)"1")}).values();
        TemplateUtil.filterVersionTemplateTree(templateCollections);
        Set<Long> templateCollectionsIds = templateCollections.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        Map<Long, Long> baseOrgIdMap = TreeStructureServiceHelper.getEntityBaseMemberIds(orgIds);
        orgIds = new HashSet<Long>(baseOrgIdMap.values());
        return TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)modelId, templateCollectionsIds, orgIds);
    }

    public static class RangeStatus {
        private boolean isInner = false;

        public boolean isInner() {
            return this.isInner;
        }
    }
}

