/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TemplateStartPeriodUtil {
    public static List<DynamicObject> getPeriodForMRpt(long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)"MRpt");
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> dyos = new ArrayList<DynamicObject>();
        for (DynamicObject dot : col) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            DynamicObjectCollection sceneperiod = dot.getDynamicObjectCollection("sceneperiod");
            sceneperiod.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
            if (ids.isEmpty()) continue;
            TemplateStartPeriodUtil.queryPeriods(ids).forEach(e -> dyos.add((DynamicObject)e));
        }
        return dyos;
    }

    public static boolean isRangeForStartPeriod(long modelId, Date firstDate, Date lastDate, DynamicObject tempDyo, DynamicObject periodDyo, Map<Long, DynamicObject> periodTempMap) {
        Date effectivedate = tempDyo.getDate("effectivedate");
        if (effectivedate == null) {
            return true;
        }
        Date expiringdate = tempDyo.getDate("expiringdate");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            effectivedate = sdf2.parse(sdf2.format(effectivedate));
            if (expiringdate != null) {
                expiringdate = sdf2.parse(sdf2.format(expiringdate));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        boolean flag = false;
        if (effectivedate.getTime() <= firstDate.getTime() && (expiringdate == null || expiringdate.getTime() >= firstDate.getTime())) {
            flag = true;
        } else if (effectivedate.getTime() >= firstDate.getTime() && effectivedate.getTime() <= lastDate.getTime()) {
            flag = true;
        }
        if (flag) {
            LocalDateTime localEffectivedate = TemplateStartPeriodUtil.dateToLocalDateTime(effectivedate);
            LocalDateTime localFirstDate = TemplateStartPeriodUtil.dateToLocalDateTime(firstDate);
            if (localEffectivedate.getYear() == localFirstDate.getYear() && localEffectivedate.getMonthValue() == localFirstDate.getMonthValue()) {
                DynamicObject startPeriodDyo;
                if (periodTempMap == null) {
                    periodTempMap = TemplateStartPeriodUtil.getAllTempStartPeriods(modelId);
                }
                if ((startPeriodDyo = periodTempMap.get(tempDyo.getLong("id"))) instanceof DynamicObject) {
                    if (startPeriodDyo.getInt("dseq") > periodDyo.getInt("dseq")) {
                        return periodDyo.getInt("effday") > startPeriodDyo.getInt("effday");
                    }
                    if (localEffectivedate.getMonthValue() == 12 && "M_M13".equals(startPeriodDyo.getString("number"))) {
                        return "M_M13".equals(periodDyo.getString("number"));
                    }
                }
            }
        }
        return flag;
    }

    public static boolean isEffectStartPeriod(LocalDateTime effectDate, LocalDateTime expiringdate, DynamicObject object) {
        int day = effectDate.getDayOfMonth();
        int month = effectDate.getMonthValue();
        int effMonth = object.getInt("effmonth");
        int effDay = object.getInt("effday");
        int expMonth = object.getInt("expmonth");
        int expDay = object.getInt("expday");
        if (month == effMonth && month == expMonth && day >= effDay && day <= expDay) {
            if (expiringdate != null) {
                int expirMonth = expiringdate.getMonthValue();
                if (month != expirMonth) {
                    return true;
                }
                int expirDay = expiringdate.getDayOfMonth();
                return expirMonth == effMonth && expirMonth == expMonth && expirDay >= effDay && expirDay <= expDay;
            }
            return true;
        }
        return false;
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = date.toInstant().atZone(zoneId);
        return zonedDateTime.toLocalDateTime();
    }

    public static long getTempStartPeriod(long templateId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_temp_startperiod", (String)"startperiod.id", (QFilter[])new QFilter("template", "=", (Object)templateId).toArray());
        long id = 0L;
        if (object != null) {
            id = object.getLong("startperiod.id");
        }
        return id;
    }

    private static Map<Long, DynamicObject> getAllTempStartPeriods(long modelId) {
        return (Map)ThreadCache.get((Object)String.join((CharSequence)"|", "getAllTempStartPeriods", modelId + ""), () -> {
            HashMap<Long, Long> periodTempMap = new HashMap<Long, Long>(16);
            HashMap periodDyoTempMap = new HashMap(16);
            ArrayList<Long> ids = new ArrayList<Long>(16);
            QueryServiceHelper.query((String)"bcm_temp_startperiod", (String)"template.id,startperiod.id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}).stream().forEach(c -> {
                periodTempMap.put(c.getLong("template.id"), c.getLong("startperiod.id"));
                ids.add(c.getLong("startperiod.id"));
            });
            if (!ids.isEmpty()) {
                Map<Long, DynamicObject> map = TemplateStartPeriodUtil.queryPeriods(ids).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
                periodTempMap.forEach((k, v) -> {
                    DynamicObject object = (DynamicObject)map.get(v);
                    if (object instanceof DynamicObject) {
                        periodDyoTempMap.put(k, object);
                    }
                });
            }
            return periodDyoTempMap;
        });
    }

    public static DynamicObjectCollection queryPeriods(List<Long> periods) {
        return QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number,effmonth,effday,expmonth,expday,dseq", (QFilter[])new QFilter[]{new QFilter("id", "in", periods)}, (String)"dseq");
    }
}

