/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.reportlist.cache.ReportRedisCache;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.ReportEditStatus;
import kd.fi.bcm.business.template.model.RightVersionTemplateParams;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateStartPeriodUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.report.ReportType;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TemplateUtil {
    private static final Log log = LogFactory.getLog(TemplateUtil.class);
    private static final int SAVESIZE = 5000;

    public static void moveReportTemplate(long model, Set<Object> reportNumbers, String newnodeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)model);
        qfBuilder.add("number", "in", reportNumbers);
        qfBuilder.add("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)"id,templatecatalog", (QFilter[])qfBuilder.toArray());
        ArrayList ids = new ArrayList(dos.length);
        Arrays.stream(dos).forEach(p -> {
            p.set("templatecatalog", (Object)newnodeId);
            ids.add(p.getLong("id"));
        });
        SaveServiceHelper.save((DynamicObject[])dos);
        TemplateServiceHelper.removeTemplateModelCacheByIds(model, ids.toArray());
    }

    public static void moveInvTemplate(long model, Set<Object> reportNumbers, String newnodeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("billno", "in", reportNumbers);
        qfBuilder.add("model", "=", (Object)model);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_invelimtemplate", (String)"templatecatalog,name,billno", (QFilter[])qfBuilder.toArray());
        Arrays.stream(dos).forEach(p -> p.set("templatecatalog", (Object)newnodeId));
        SaveServiceHelper.save((DynamicObject[])dos);
        String opName = ResManager.loadKDString((String)"\u79fb\u52a8", (String)"TemplateUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        List<String> opDesc = Arrays.asList(dos).stream().map(d -> String.format(ResManager.loadKDString((String)"%1$s \u79fb\u52a8\u6210\u529f", (String)"TemplateUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]), d.getString("billno") + " " + d.getString("name"))).collect(Collectors.toList());
        OperationLogUtil.batchWriteOperationLog(opName, opDesc, model, "bcm_invelimtemplate");
    }

    public static void moveAnalysisHelperTemplate(long model, ListSelectedRowCollection selectedRows, String newNodeId) {
        Object[] reportIds = selectedRows.getPrimaryKeyValues();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)model);
        qfBuilder.add("id", "in", (Object)reportIds);
        DynamicObject modelObject = BusinessDataServiceHelper.loadSingle((Object)model, (String)"bcm_model");
        DynamicObject catalogObject = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)newNodeId), (String)"bcm_anaysiscatalog");
        String opName = ResManager.loadKDString((String)"\u79fb\u52a8", (String)"TemplateUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        try (TXHandle tx = TX.requiresNew();){
            try {
                DynamicObject[] analysisHelper = BusinessDataServiceHelper.load((String)"bcm_analysishelper", (String)"id,templatecatalog", (QFilter[])qfBuilder.toArray());
                Arrays.stream(analysisHelper).forEach(p -> p.set("templatecatalog", (Object)newNodeId));
                SaveServiceHelper.save((DynamicObject[])analysisHelper);
                List<String> opDesc = selectedRows.stream().map(selectedRow -> String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s %4$s \u79fb\u52a8\u5230 %5$s %6$s \u6210\u529f\u3002", (String)"TemplateUtil_3", (String)"fi-bcm-business", (Object[])new Object[0]), modelObject.getString("shownumber"), modelObject.getString("name"), selectedRow.getNumber(), selectedRow.getName(), catalogObject.getString("number"), catalogObject.getString("name"))).collect(Collectors.toList());
                OperationLogUtil.batchWriteOperationLog(opName, opDesc, null, "bcm_analysishelper");
            }
            catch (Exception e) {
                tx.markRollback();
                List<String> opDesc = selectedRows.stream().map(selectedRow -> String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s %4$s \u79fb\u52a8\u5230 %5$s %6$s \u5931\u8d25\u3002", (String)"TemplateUtil_4", (String)"fi-bcm-business", (Object[])new Object[0]), modelObject.getString("shownumber"), modelObject.getString("name"), selectedRow.getNumber(), selectedRow.getName(), catalogObject.getString("number"), catalogObject.getString("name"))).collect(Collectors.toList());
                OperationLogUtil.batchWriteOperationLog(opName, opDesc, null, "bcm_analysishelper");
                throw new KDBizException(e.toString());
            }
        }
    }

    public static void moveChangCaseTemplate(long model, Set<Object> reportNumbers, String newnodeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("number", "in", reportNumbers);
        qfBuilder.add("model", "=", (Object)model);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_invchangecaseentity", (String)"templatecatalog,name,number", (QFilter[])qfBuilder.toArray());
        Arrays.stream(dos).forEach(p -> p.set("templatecatalog", (Object)newnodeId));
        SaveServiceHelper.save((DynamicObject[])dos);
        String opName = ResManager.loadKDString((String)"\u79fb\u52a8", (String)"TemplateUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        List<String> opDesc = Arrays.asList(dos).stream().map(d -> String.format(ResManager.loadKDString((String)"%1$s \u79fb\u52a8\u6210\u529f", (String)"TemplateUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]), d.getString("number") + " " + d.getString("name"))).collect(Collectors.toList());
        OperationLogUtil.batchWriteOperationLog(opName, opDesc, model, "bcm_invchangecaseentity");
    }

    public static TemplateModel getTempModel(Object id) {
        return TemplateUtil.getTemplateModel(id);
    }

    public static DynamicObjectCollection getTempByNumber(Collection<String> tempNums, long modelId, String selProps) {
        QFilter modelQF = new QFilter("model", "=", (Object)modelId);
        QFilter numQF = new QFilter("number", "in", tempNums);
        QFilter tmpTypeQF = new QFilter("templatetype", "in", (Object)Lists.newArrayList((Object[])new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())}));
        return QueryServiceHelper.query((String)"bcm_templateentity", (String)selProps, (QFilter[])new QFilter[]{modelQF, numQF, tmpTypeQF});
    }

    public static boolean isProcessInPageDim(List<PageDimensionEntry> pageDimensionEntries) {
        ArrayList list = new ArrayList();
        pageDimensionEntries.forEach(pageDimensionEntry -> list.add(pageDimensionEntry.getDimension().getNumber()));
        return list.contains(DimTypesEnum.PROCESS.getNumber());
    }

    public static void filterVersionTemplateTree(Collection<DynamicObject> templateColls) {
        HashSet passes = new HashSet();
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        Map<String, List<DynamicObject>> templateGroups = templateColls.stream().collect(Collectors.groupingBy(arg_0 -> TemplateUtil.lambda$filterVersionTemplateTree$9((Table)form2key2DTProps, arg_0)));
        templateGroups.forEach((arg_0, arg_1) -> TemplateUtil.lambda$filterVersionTemplateTree$10(passes, (Table)form2key2DTProps, arg_0, arg_1));
        templateColls.removeIf(arg_0 -> TemplateUtil.lambda$filterVersionTemplateTree$11(passes, (Table)form2key2DTProps, arg_0));
    }

    public static List<Long> getTemplateIds(Long modelId, Long templatecatalogId) {
        DynamicObject cataLog = QueryServiceHelper.queryOne((String)"bcm_templatecatalog", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templatecatalogId)});
        if (cataLog == null) {
            return new ArrayList<Long>();
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("longnumber", "like", (Object)(cataLog.getString("longnumber") + ".%"));
        qf.or("longnumber", "=", (Object)cataLog.getString("longnumber"));
        Set cataLogIds = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id", (QFilter[])qf.toArray()).stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        return QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFBuilder("templatecatalog", "in", cataLogIds).toArray()).stream().map(t -> t.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getTemplateIds(Long templateId) {
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        if (template == null) {
            return new ArrayList<Long>();
        }
        return QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFBuilder("group", "=", (Object)template.getLong("group")).toArray()).stream().map(t -> t.getLong("id")).collect(Collectors.toList());
    }

    public static Map<String, Long> getTemplateNumbersByIds(Set<Long> templateIds) {
        HashMap<String, Long> number2Id = new HashMap<String, Long>();
        QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFBuilder("id", "in", templateIds).toArray()).forEach(dy -> number2Id.put(dy.getString("number"), dy.getLong("id")));
        return number2Id;
    }

    public static Set<Long> getExistReportIds(DynamicObjectCollection reportColls, Map<String, Long> number2Id) {
        HashSet<Long> existReport = new HashSet<Long>();
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        reportColls.forEach(arg_0 -> TemplateUtil.lambda$getExistReportIds$16((Table)form2key2DTProps, number2Id, existReport, arg_0));
        return existReport;
    }

    public static IDataEntityProperty getDTProperty(Table<String, String, IDataEntityProperty> form2key2DTProps, String form, String key, DynamicObject obj) {
        IDataEntityProperty property = (IDataEntityProperty)form2key2DTProps.get((Object)form, (Object)key);
        if (property == null) {
            property = (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)key);
            form2key2DTProps.put((Object)form, (Object)key, (Object)property);
        }
        return property;
    }

    public static Map<Long, Long> getRightTplIdByVersioned(Long modelId, Long yearId, Long periodId, Set<Long> templateIds, boolean includeEnable) {
        HashMap<Long, Long> source2Right = new HashMap<Long, Long>();
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter(periodId);
        String yearNum = MemberReader.findMemberById((long)modelId, (String)"bcm_fymembertree", (Long)yearId).getNumber();
        Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, yearNum, periodDo);
        Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo);
        if (firstDate == null || lastDate == null) {
            return source2Right;
        }
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        HashMap group2SourceId = new HashMap();
        QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,group", (QFilter[])new QFBuilder("id", "in", templateIds).toArray()).forEach(arg_0 -> TemplateUtil.lambda$getRightTplIdByVersioned$17(group2SourceId, (Table)form2key2DTProps, arg_0));
        QFBuilder builder = new QFBuilder("group", "in", group2SourceId.keySet());
        if (!includeEnable) {
            builder.add("status", "=", (Object)"1");
        }
        form2key2DTProps.clear();
        Map<Long, List<DynamicObject>> templateGroups = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,group,effectivedate, expiringdate,versionnumber", (QFilter[])builder.toArray(), (String)"group, versionnumber").stream().collect(Collectors.groupingBy(arg_0 -> TemplateUtil.lambda$getRightTplIdByVersioned$18((Table)form2key2DTProps, arg_0)));
        templateGroups.forEach((arg_0, arg_1) -> TemplateUtil.lambda$getRightTplIdByVersioned$19((Table)form2key2DTProps, source2Right, modelId, firstDate, lastDate, periodDo, group2SourceId, arg_0, arg_1));
        return source2Right;
    }

    public static Table<Long, Long, Long> getRightTplIdByVBatchPeriod(Long modelId, Long yearId, Collection<Long> periodIds, Collection<Long> templateIds, boolean includeEnable) {
        HashBasedTable source2Right = HashBasedTable.create();
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        HashMap group2SourceId = new HashMap();
        QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,group", (QFilter[])new QFBuilder("id", "in", templateIds).toArray()).forEach(t -> group2SourceId.put(t.getLong("group"), t.getLong("id")));
        QFBuilder builder = new QFBuilder("group", "in", group2SourceId.keySet());
        if (!includeEnable) {
            builder.add("status", "=", (Object)"1");
        }
        Map<Long, List<DynamicObject>> templateGroups = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, group, effectivedate, expiringdate,versionnumber", (QFilter[])builder.toArray(), (String)"group, versionnumber").stream().collect(Collectors.groupingBy(e -> e.getLong("group")));
        DynamicObject[] periodDos = EntityVersioningUtil.getSPeriods(periodIds);
        String yearNum = MemberReader.findMemberById((long)modelId, (String)"bcm_fymembertree", (Long)yearId).getNumber();
        for (DynamicObject periodDo : periodDos) {
            Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, yearNum, periodDo);
            Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo);
            if (firstDate == null || lastDate == null) continue;
            templateGroups.forEach((arg_0, arg_1) -> TemplateUtil.lambda$getRightTplIdByVBatchPeriod$22((Table)source2Right, periodDo, modelId, firstDate, lastDate, group2SourceId, arg_0, arg_1));
        }
        return source2Right;
    }

    public static Map<Long, Long> getRightTplIdByVersioned(Long modelId, Long yearId, Long periodId, Set<Long> templateIds) {
        return TemplateUtil.getRightTplIdByVersioned(modelId, yearId, periodId, templateIds, false);
    }

    public static Map<Long, List<DynamicObject>> getAllInPeriodTmpl(Set<Long> templateIds) {
        HashMap group2SourceId = new HashMap();
        QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,group", (QFilter[])new QFBuilder("id", "in", templateIds).toArray()).forEach(t -> group2SourceId.put(t.getLong("group"), t.getLong("id")));
        Map<Long, List<DynamicObject>> templateGroups = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, group, effectivedate, expiringdate,versionnumber", (QFilter[])new QFBuilder("group", "in", group2SourceId.keySet()).add("status", "=", (Object)"1").toArray(), (String)"group, versionnumber").stream().collect(Collectors.groupingBy(e -> e.getLong("group")));
        HashMap<Long, List<DynamicObject>> srctempGroups = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : templateGroups.entrySet()) {
            srctempGroups.put((Long)group2SourceId.get(entry.getKey()), entry.getValue());
        }
        return srctempGroups;
    }

    public static Map<Long, String> batchFindTemplateNameByIds(List<Long> templateIds) {
        HashMap<Long, String> id2NameMap = new HashMap<Long, String>();
        QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name", (QFilter[])new QFBuilder("id", "in", templateIds).toArray()).forEach(dy -> id2NameMap.put(dy.getLong("id"), dy.getString("name")));
        return id2NameMap;
    }

    public static void addFilterForUserAuth(Set<Long> tempIds, Long modelId, Long userId) {
    }

    public static void setUserAuth(Long modelId, Long userId, Set<String> hasAuthTmpNums, Set<String> notHasAuthTmpNums, QFilter qf) {
    }

    public static void setGroupAuth(Long modelId, Long userId, Set<String> groupHasAuthTempNums, Set<String> groupNotHasAuthTempNums, QFilter qf) {
    }

    public static boolean isFilter(String tempNum, boolean isdefaulthasauth, Set<String> notHasAuthTmpNums, Set<String> groupNotHasAuthTempNums, Set<String> allTempNums) {
        return isdefaulthasauth ? notHasAuthTmpNums.contains(tempNum) || groupNotHasAuthTempNums.contains(tempNum) : notHasAuthTmpNums.contains(tempNum) || groupNotHasAuthTempNums.contains(tempNum) || !allTempNums.contains(tempNum);
    }

    public static void addFilterForUserAuth(QFilter qFilter, Long modelId, Long userId) {
    }

    public static void addFilterForOrgDis(QFilter qFilter, Long modelId, Long orgId) {
        Set<Long> tempIds = TemplateUtil.getTempDisOrgs(modelId, orgId);
        qFilter.and(new QFilter("id", "in", tempIds));
    }

    public static Set<Long> getTempDisOrgs(Long modelId, Long orgId) {
        return TemplateDistributionOrgUtil.getDisTemplateByOrg(modelId, orgId);
    }

    public static Set<Long> getTempDisOrgs(Long modelId, Long orgId, boolean includeSameNumOrg) {
        if (!includeSameNumOrg) {
            return TemplateUtil.getTempDisOrgs(modelId, orgId);
        }
        HashSet<Long> tempIds = new HashSet<Long>(16);
        IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
            QFBuilder builder = new QFBuilder("model", "=", (Object)modelId);
            builder.add("number", "=", (Object)treeNode.getNumber());
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])builder.toArray());
            Set orgIds = orgs.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            Map<Long, Set<Long>> temp2OrgIds = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(modelId);
            for (Map.Entry<Long, Set<Long>> tOrgEntry : temp2OrgIds.entrySet()) {
                for (Long id : orgIds) {
                    if (!tOrgEntry.getValue().contains(id)) continue;
                    tempIds.add(tOrgEntry.getKey());
                }
            }
        }
        return tempIds;
    }

    public static Map<String, Boolean> getMaxVersionDefault(Set<Long> groups) {
        QFilter qFilter = new QFilter("group", "in", groups);
        qFilter.and(new QFilter("status", "=", (Object)"1"));
        DynamicObjectCollection temps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,isdefaulthasauth", (QFilter[])new QFilter[]{qFilter}, (String)"number desc,versionnumber asc");
        HashMap<String, Boolean> numAndDefault = new HashMap<String, Boolean>(16);
        if (CollectionUtils.isNotEmpty((Collection)temps)) {
            numAndDefault = new HashMap(temps.size());
            for (DynamicObject temp : temps) {
                numAndDefault.put(temp.getString("number"), temp.getBoolean("isdefaulthasauth"));
            }
        }
        return numAndDefault;
    }

    public static boolean isAllDimInRC(TemplateModel templateModel) {
        return templateModel.getViewPointDimensionEntries().size() == 0 && templateModel.getPageDimensionEntries().size() == 0 && templateModel.getPagePropEntries().size() == 0 && templateModel.getFilterDimensionEntries().size() == 0;
    }

    public static Map<String, Boolean> getIsFilterMap(Collection<TemplateModel> templates, Long modelId, Long userId) {
        List<String> tempNums = templates.stream().map(t -> t.getNumber()).collect(Collectors.toList());
        QFilter qf = new QFilter("template.number", "in", tempNums);
        QFilter groupQf = new QFilter("template.number", "in", tempNums);
        HashSet<String> hasAuthTmpNums = new HashSet<String>(16);
        HashSet<String> notHasAuthTmpNums = new HashSet<String>(16);
        TemplateUtil.setUserAuth(modelId, userId, hasAuthTmpNums, notHasAuthTmpNums, qf);
        HashSet<String> groupHasAuthTempNums = new HashSet<String>(16);
        HashSet<String> groupNotHasAuthTempNums = new HashSet<String>(16);
        TemplateUtil.setGroupAuth(modelId, userId, groupHasAuthTempNums, groupNotHasAuthTempNums, groupQf);
        HashSet<String> allTempNums = new HashSet<String>(hasAuthTmpNums);
        allTempNums.addAll(notHasAuthTmpNums);
        allTempNums.addAll(groupHasAuthTempNums);
        allTempNums.addAll(groupNotHasAuthTempNums);
        Set<Long> groups = templates.stream().map(TemplateModel::getGroup).collect(Collectors.toSet());
        Map<String, Boolean> maxVersionDefault = TemplateUtil.getMaxVersionDefault(groups);
        HashMap result = Maps.newHashMap();
        tempNums.forEach(n -> {
            if (maxVersionDefault.get(n) != null) {
                boolean isDefaultHasAuth = (Boolean)maxVersionDefault.get(n);
                boolean isFilter = TemplateUtil.isFilter(n, isDefaultHasAuth, notHasAuthTmpNums, groupNotHasAuthTempNums, allTempNums);
                result.put(n, isFilter);
            }
        });
        return result;
    }

    public static PositionInfo getPositionInfo(SpreadManager spmodel, int r, int c) {
        PositionInfo base = null;
        String position = ExcelUtils.xy2Pos((int)c, (int)r);
        for (PositionInfo positionInfo : spmodel.getAreaManager().getPostionInfoSet()) {
            String spreadArea = positionInfo.getAreaRange();
            if (!SpreadAreaUtil.isInArea((String)(position + ":" + position), (String)spreadArea)) continue;
            base = positionInfo;
            break;
        }
        return base;
    }

    public static boolean isExtEntity(SpreadManager spmodel, int r, int c) {
        int headrow;
        PositionInfo po = TemplateUtil.getPositionInfo(spmodel, r, c);
        if (po != null && (headrow = ExcelUtils.pos2Y((String)po.getAreaRange().split(":")[0]) - 1) >= 0) {
            return DimTypesEnum.ENTITY.getNumber().equals(spmodel.getBook().getSheet(0).getCell(headrow, c).getUserObject("ext_col"));
        }
        return false;
    }

    public static void updateTemplateMemberInfos(Collection<Long> templateIds) {
        for (Long id : templateIds) {
            ThreadPoolService.runInUpdateTemplateLinkInfoThread(() -> {
                TemplateModel template = TemplateUtil.getTempModel(id);
                SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
                TemplateUtil.saveTemplateMemberInfo(template, sm);
            });
        }
    }

    public static void saveTemplateMemberInfo(TemplateModel template, SpreadManager sm) {
        try {
            if (!template.isSaveByDim()) {
                return;
            }
            if (template.getAreaRangeEntries().isEmpty()) {
                return;
            }
            int type = template.getTemplateType();
            if (type != TemplateTypeEnum.FIX.getType() && type != TemplateTypeEnum.DYNA.getType()) {
                return;
            }
            PositionInfo positionInfo = sm.getFirstUnExtendInfo();
            if (positionInfo == null) {
                return;
            }
            long templateId = template.getId();
            QFilter filter = new QFilter("template", "=", (Object)templateId);
            DynamicObject memberInfo = BusinessDataServiceHelper.loadSingle((String)"bcm_templatemember", (String)"memberInfoId,pageviewdim,pageviewmember,rowcolinfo,rowcolinfo.dimension,rowcolinfo.member,rowcolinfo.isfloat", (QFilter[])filter.toArray());
            boolean isNew = false;
            if (memberInfo == null) {
                memberInfo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templatemember");
                memberInfo.set("modelid", (Object)template.getModelId());
                memberInfo.set("template", (Object)templateId);
                memberInfo.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                isNew = true;
            }
            long memberInfoId = memberInfo.getLong("id");
            StringBuilder pageViewDim = new StringBuilder();
            StringBuilder pageViewMember = new StringBuilder();
            template.getViewPointDimensionEntries().forEach(e -> {
                pageViewDim.append(e.getDimension().getNumber()).append("|");
                pageViewMember.append(e.getMember().getNumber()).append("|");
            });
            template.getPageDimensionEntries().forEach(e -> {
                pageViewDim.append(e.getDimension().getNumber()).append("|");
                List<Member> members = e.getMembers();
                if (members.isEmpty()) {
                    pageViewMember.append("null@");
                }
                members.forEach(m -> {
                    if (m.getScope() != 10) {
                        pageViewMember.append(m.getNumber()).append("#").append(m.getScope());
                    } else {
                        pageViewMember.append(m.getNumber());
                    }
                    pageViewMember.append("@");
                });
                pageViewMember.deleteCharAt(pageViewMember.length() - 1);
                pageViewMember.append("|");
            });
            String dimString = pageViewDim.length() == 0 ? null : pageViewDim.substring(0, pageViewDim.length() - 1);
            String member = pageViewMember.length() == 0 ? null : pageViewMember.substring(0, pageViewMember.length() - 1);
            memberInfo.set("pageviewdim", (Object)dimString);
            memberInfo.set("pageviewmember", (Object)member);
            Object[] param = isNew ? new Object[]{memberInfoId, template.getModelId(), templateId, dimString, member} : new Object[]{dimString, member, memberInfoId};
            DynamicObjectCollection entrys = memberInfo.getDynamicObjectCollection("rowcolinfo");
            entrys.clear();
            StringBuilder rowColDim = new StringBuilder();
            for (AreaRangeEntry rangeEntry : template.getAreaRangeEntries()) {
                if (!rangeEntry.getAreaRange().equals(positionInfo.getAreaRange())) continue;
                rangeEntry.getRowDimEntries().forEach(row -> rowColDim.append(row.getDimension().getNumber()).append("|"));
                rangeEntry.getColDimEntries().forEach(col -> rowColDim.append(col.getDimension().getNumber()).append("|"));
                break;
            }
            String dim = rowColDim.substring(0, rowColDim.length() - 1);
            ArrayList members = new ArrayList(10);
            Sheet sheet = sm.getBook().getSheet(0);
            StringBuilder temp = new StringBuilder();
            sheet.iteratorCells(c -> {
                if (c.isMdDataDomain() && c.getUserObject("KEY_DIM_FLAG") != null) {
                    temp.setLength(0);
                    List dimMembers = (List)c.getUserObject("KEY_DIM_FLAG");
                    dimMembers.forEach(m -> temp.append(m).append("#"));
                    members.add(temp.substring(0, temp.length() - 1));
                }
            });
            members.forEach(m -> {
                DynamicObject entry = entrys.addNew();
                entry.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                entry.set("dimension", (Object)dim);
                entry.set("member", m);
            });
            if (type == TemplateTypeEnum.DYNA.getType()) {
                DynamicObject entry = entrys.addNew();
                entry.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                entry.set("dimension", (Object)dim);
                entry.set("isfloat", (Object)1);
            }
            if (entrys.size() > 5000) {
                int start = 0;
                int end = 5000;
                int part = entrys.size() / 5000;
                if (entrys.size() % 5000 != 0) {
                    ++part;
                }
                TemplateUtil.deleteOldEntry(memberInfoId);
                int i = 0;
                while (i < part) {
                    if (end > entrys.size()) {
                        end = entrys.size();
                    }
                    List saveList = entrys.subList(start, end);
                    BusinessDataWriter.save((IDataEntityType)entrys.getDynamicObjectType(), (Object[])saveList.toArray(new DynamicObject[0]));
                    ArrayList<Object[]> params = new ArrayList<Object[]>(5000);
                    saveList.forEach(obj -> {
                        Object[] p = new Object[]{memberInfoId, obj.getLong("id")};
                        params.add(p);
                    });
                    TemplateUtil.updateFid(params);
                    ++i;
                    start += 5000;
                    end += 5000;
                }
                if (isNew) {
                    TemplateUtil.saveMemberInfo(param);
                } else {
                    TemplateUtil.updateMemberInfo(param);
                }
            } else {
                BusinessDataWriter.save((IDataEntityType)memberInfo.getDataEntityType(), (Object[])new Object[]{memberInfo});
            }
        }
        catch (Exception e2) {
            log.error("TemplateUtil-saveTemplateMemberInfo: " + template.getNumber(), (Throwable)e2);
        }
    }

    private static void updateFid(List<Object[]> params) {
        String updateSql = "update t_bcm_template_areamember set fid = ? where fentryid = ?";
        if (params != null && params.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql, params);
        }
    }

    private static void deleteOldEntry(Long fid) {
        String deleteSql = "delete from t_bcm_template_areamember where fid = " + fid;
        DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)deleteSql);
    }

    private static void saveMemberInfo(Object[] param) {
        String sql = "insert into t_bcm_template_basemember (fid,fmodelid,ftemplateid,fpageviewdim,fpageviewmember) values (?,?,?,?,?)";
        if (param != null && param.length > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])param);
        }
    }

    private static void updateMemberInfo(Object[] param) {
        String sql = "update t_bcm_template_basemember set fpageviewdim = ?,fpageviewmember = ? where fid = ?";
        if (param != null && param.length > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])param);
        }
    }

    public static String getDimName(Long modelId, String dimNum) {
        Map map = MemberReader.getDimDyoByModelId((long)modelId);
        DynamicObject object = (DynamicObject)map.get(dimNum);
        String name = dimNum;
        if (!Objects.nonNull(object)) {
            throw new KDBizException(String.format("getDimName_dimNum \u3010%s\u3011 not exit", dimNum));
        }
        name = object.getString("name");
        return name;
    }

    public static QFilter getTemplatePageMemberFilter(String dimNum, long dimId, TemplateModel tm) {
        QFilter hasPermFilter;
        long modelId = tm.getModelId();
        QFilter modelFilter = new QFilter("model", "=", (Object)tm.getModelId());
        boolean isHit = false;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        String entityName = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        for (PageDimensionEntry pde : tm.getPageDimensionEntries()) {
            if (!pde.getDimension().getNumber().equals(dimNum)) continue;
            for (Member member : pde.getMembers()) {
                qFilters.add(new MembRangeItem(entityName, (Long)member.getId(), member.getNumber(), member.getScope(), false, (Object)modelId).buildFilterByScope());
                isHit = true;
            }
        }
        if (!isHit) {
            for (PageDimPropEntry pagePropEntry : tm.getPagePropEntries()) {
                if (!pagePropEntry.getDimension().getNumber().equals(dimNum)) continue;
                for (MembProperty membProperty : pagePropEntry.getAllMembProperties()) {
                    qFilters.add(new MembRangeItem(entityName, (Long)membProperty.getId(), membProperty.getNumber(), membProperty.getScope(), true, (Object)modelId).buildFilterByScope());
                }
            }
        }
        for (FilterDimensionEntry filterDimensionEntry : tm.getFilterDimensionEntries()) {
            if (!filterDimensionEntry.getDimension().getNumber().equals(dimNum)) continue;
            for (Member member : filterDimensionEntry.getMembers()) {
                qFilters.add(new MembRangeItem(entityName, (Long)member.getId(), member.getNumber(), member.getScope(), false, (Object)modelId).buildFilterByScope());
            }
        }
        if (CollectionUtils.isNotEmpty(qFilters)) {
            QFilter memFilter = null;
            for (QFilter qFilter : qFilters) {
                if (memFilter == null) {
                    memFilter = qFilter;
                    continue;
                }
                memFilter.or(qFilter);
            }
            if (memFilter != null) {
                modelFilter.and(memFilter);
            }
        }
        if (!MemberPermHelper.isModelManager(modelId) && (hasPermFilter = PermissionServiceImpl.getInstance(modelId).getReadOrWritePermFilter(dimId, entityName, "id")) != null) {
            modelFilter.and(hasPermFilter);
        }
        return modelFilter;
    }

    public static List<TemplateModel> batchGetTemplateModel(List<Long> templateIds, Long modelId, boolean isSimpleModel) {
        ArrayList<TemplateModel> templateModelList = new ArrayList<TemplateModel>(16);
        HashMap queryTemplateMap = new HashMap(16);
        if (!templateIds.isEmpty()) {
            ArrayList<Long> notCacheId = new ArrayList<Long>(16);
            AtomicBoolean flag = new AtomicBoolean(true);
            if (isSimpleModel) {
                queryTemplateMap.putAll((Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad("queryTemplateList" + modelId, () -> {
                    HashMap queryTemplateCache = new HashMap(templateIds.size());
                    TemplateUtil.queryTemplateModels(modelId, templateIds, templateModelList, true);
                    templateModelList.forEach(e -> queryTemplateCache.put(e.getId(), e));
                    flag.set(false);
                    return queryTemplateCache;
                }));
                if (flag.get()) {
                    templateIds.forEach(k -> {
                        if (!queryTemplateMap.containsKey(k)) {
                            String templateSerial = AppCacheServiceHelper.get(ReportRedisCache.getAppCacheKey(k), String.class);
                            if (kd.bos.util.StringUtils.isNotEmpty((String)templateSerial)) {
                                TemplateModel t = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
                                templateModelList.add(t);
                                queryTemplateMap.put(k, t);
                            } else {
                                notCacheId.add((Long)k);
                            }
                            flag.set(false);
                        }
                    });
                }
            } else {
                for (Long templateId : templateIds) {
                    String templateSerial;
                    String templateIdStr = templateId.toString();
                    TemplateModel tm = (TemplateModel)GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemplateModelReadCache).getIfPresent(templateIdStr);
                    if (tm == null && kd.bos.util.StringUtils.isNotEmpty((String)(templateSerial = AppCacheServiceHelper.get(templateIdStr, String.class)))) {
                        tm = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
                        GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemplateModelReadCache).put(templateIdStr, (Object)tm);
                    }
                    if (tm != null) {
                        templateModelList.add(tm);
                        continue;
                    }
                    notCacheId.add(templateId);
                }
            }
            TemplateUtil.queryTemplateModels(modelId, notCacheId, templateModelList, isSimpleModel);
            if (!flag.get()) {
                if (!notCacheId.isEmpty()) {
                    templateModelList.forEach(e -> {
                        if (notCacheId.contains(e.getId())) {
                            queryTemplateMap.put(e.getId(), e);
                        }
                    });
                }
                GlobalCacheServiceHelper.getCommonCache().replaceCache("queryTemplateList" + modelId, queryTemplateMap);
            }
        }
        return isSimpleModel ? queryTemplateMap.values().stream().filter(e -> templateIds.contains(e.getId())).collect(Collectors.toList()) : templateModelList;
    }

    public static void transferDynaObj2Model(long modelId, DynamicObject[] dynas, List<Long> notCacheId, List<TemplateModel> templateModelList, boolean isSimpleModel, boolean isNeedCache) {
        HashMap permissionClassMap = new HashMap(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("entityname", "=", (Object)"bcm_templateentity");
        qFilter.and("entityid", "in", notCacheId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass,entityid", (QFilter[])qFilter.toArray());
        if (load.length > 0) {
            Arrays.stream(load).forEach(dynamicObject -> permissionClassMap.put(dynamicObject.getLong("entityid"), dynamicObject));
        }
        HashMap<String, Set> memberMap = new HashMap<String, Set>(16);
        HashSet dpMemberIds = new HashSet(16);
        for (DynamicObject dyna : dynas) {
            Object entry2;
            DynamicObjectCollection entries = dyna.getDynamicObjectCollection("pagemembentry");
            for (Object entry2 : entries) {
                DynamicObject dim = entry2.getDynamicObject("pagedimension");
                Long memId = entry2.getLong("pagemembid");
                memberMap.computeIfAbsent(dim.getString("membermodel"), key -> new HashSet()).add(memId);
            }
            DynamicObjectCollection viePointEntries = dyna.getDynamicObjectCollection("viewpointmembentry");
            entry2 = viePointEntries.iterator();
            while (entry2.hasNext()) {
                DynamicObject entry3 = (DynamicObject)entry2.next();
                DynamicObject dim = entry3.getDynamicObject("viewdimension");
                Long memId = entry3.getLong("viewmembid");
                memberMap.computeIfAbsent(dim.getString("membermodel"), key -> new HashSet()).add(memId);
            }
            DynamicObjectCollection filtermembentry = dyna.getDynamicObjectCollection("filtermembentry");
            filtermembentry.forEach(e -> {
                if (e.getDynamicObject("filtermemproperty") != null) {
                    dpMemberIds.add(e.getLong("filtermembid"));
                }
            });
        }
        HashMap memMap = new HashMap(memberMap.size());
        String selectFields = "id,name,number";
        for (Map.Entry entry : memberMap.entrySet()) {
            Map memCollMap = BusinessDataServiceHelper.loadFromCache((String)((String)entry.getKey()), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            memCollMap.forEach((k, v) -> memMap.put((String)entry.getKey() + "|" + v.getLong("id"), v));
        }
        if (!dpMemberIds.isEmpty()) {
            selectFields = "id,name,number,propertyid";
            DynamicObject[] dpDynamicCollection = BusinessDataServiceHelper.load((String)"bcm_definedpropertyvalue", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dpMemberIds)});
            HashMap dpDyo = new HashMap(16);
            if (dpDynamicCollection != null) {
                Arrays.stream(dpDynamicCollection).forEach(dyo -> dpDyo.put(dyo.getLong("id"), dyo));
            }
            ThreadCache.put((Object)"dim_mem_dp_filtermem", dpDyo);
        }
        ThreadCache.put((Object)"template_dis_permclass", permissionClassMap);
        ThreadCache.put((Object)"template_dim_mem", memMap);
        for (DynamicObject dynamicObject2 : dynas) {
            TemplateModel templateRef;
            if (isSimpleModel) {
                templateRef = new TemplateModel();
                templateRef.loadDynaObj2SimpleModel(dynamicObject2);
                if (isNeedCache) {
                    AppCacheServiceHelper.put(ReportRedisCache.getAppCacheKey(templateRef.getId()), ObjectSerialUtil.toByteSerialized((Object)templateRef));
                }
            } else {
                templateRef = TemplateModel.genImmutableModel(dynamicObject2);
                if (isNeedCache) {
                    AppCacheServiceHelper.put(dynamicObject2.getString("id"), ObjectSerialUtil.toByteSerialized((Object)templateRef));
                    GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemplateModelReadCache).put(dynamicObject2.getString("id"), (Object)templateRef);
                }
            }
            templateModelList.add(templateRef);
        }
        ThreadCache.remove((Object)"dim_mem_dp_filtermem");
        ThreadCache.remove((Object)"template_dis_permclass");
        ThreadCache.remove((Object)"template_dim_mem");
    }

    private static void queryTemplateModels(long modelId, List<Long> notCacheId, List<TemplateModel> templateModelList, boolean isSimpleModel) {
        if (!notCacheId.isEmpty()) {
            DynamicObject[] dynas = isSimpleModel ? BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)TemplateModel.getSimpleModelSeleter(), (QFilter[])new QFilter[]{new QFilter("id", "in", notCacheId)}, (String)"createtime") : BusinessDataServiceHelper.load((Object[])notCacheId.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_templateentity"));
            TemplateUtil.transferDynaObj2Model(modelId, dynas, notCacheId, templateModelList, isSimpleModel, true);
        }
    }

    public static Map<String, DynamicObject> getMemCacheMap(String key) {
        Object o = ThreadCache.get((Object)key);
        if (o instanceof Map) {
            return (Map)o;
        }
        return (Map)ThreadCache.get((Object)"template_dim_mem");
    }

    public static String getListEntryOrderBy(boolean isTemplate) {
        return isTemplate ? "sequence,number,versionnumber desc" : "entity.longnumber,template.sequence,template.number,cycletable.sequence";
    }

    public static Set<String> fillReportStatus(RightVersionTemplateParams params, OrgTreeNode root) {
        HashSet<String> treeIds = new HashSet<String>(16);
        Set<Long> orgIds = params.getOrgIds();
        if (CollectionUtils.isEmpty(orgIds)) {
            orgIds.add(LongUtil.toLong((Object)root.getId()));
            TemplateUtil.collectOrgIds(root, orgIds);
            params.setOrgIds(orgIds);
        }
        HashMap<String, ReportEditStatus> result = new HashMap<String, ReportEditStatus>(16);
        String modelNum = MemberReader.findModelNumberById((Object)params.getModelId());
        TemplateUtil.getCommitReportCount(params).forEach((k, v) -> result.put(BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (long)k).getNumber(), (ReportEditStatus)v));
        TemplateUtil.fillReportStatusToOrgTreeNode(result, root, treeIds);
        return treeIds;
    }

    private static void fillReportStatusToOrgTreeNode(Map<String, ReportEditStatus> result, OrgTreeNode root, Set<String> treeIds) {
        ReportEditStatus editStatus = result.get(root.getNumber());
        if (editStatus != null) {
            String name = root.getName();
            String reportEditStatus = root.getReportEditStatus();
            root.setReportEditStatus(" " + editStatus.getCommitTemplates().size() + "/" + editStatus.getAllReportCount());
            name = kd.bos.util.StringUtils.isNotEmpty((String)reportEditStatus) ? name.replace(reportEditStatus, root.getReportEditStatus()) : name + root.getReportEditStatus();
            root.setName(name);
            treeIds.add(root.getId());
        }
        root.getChildren().forEach(e -> TemplateUtil.fillReportStatusToOrgTreeNode(result, (OrgTreeNode)e, treeIds));
    }

    private static void collectOrgIds(ITreeNode<Object> root, Set<Long> orgIds) {
        root.getChildren().forEach(e -> {
            orgIds.add(LongUtil.toLong((Object)e.getId()));
            if (!e.isLeaf()) {
                TemplateUtil.collectOrgIds(e, orgIds);
            }
        });
    }

    public static Map<Long, ReportEditStatus> getCommitReportCount(RightVersionTemplateParams params) {
        boolean isNeedCheckPerm;
        long modelId = params.getModelId();
        HashMap<Long, Long> curMap = new HashMap<Long, Long>(16);
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        HashMap<Long, ReportEditStatus> resultMap = new HashMap<Long, ReportEditStatus>(16);
        Set<Long> orgIds = TemplateUtil.fillOrgAndCurrencyData(params, curMap, currencyIds, resultMap);
        boolean bl = isNeedCheckPerm = !params.isUnCheckUserPerm() && !MemberPermHelper.ifUserHasRootPermByModel(params.getUserId(), Long.toString(modelId));
        if (isNeedCheckPerm && CollectionUtils.isEmpty(orgIds = TemplateUtil.filterOrgPerm(params, orgIds))) {
            return resultMap;
        }
        try {
            if ((params.getTemplateIds() == null || params.getTemplateIds().isEmpty()) && params.getStageId() != 0L) {
                HashSet<Long> selectTemplateIdSet = new HashSet<Long>(16);
                QFilter filter = new QFilter("stage", "=", (Object)params.getStageId());
                DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_distributionstage", (String)"id,template.id,templatenum", (QFilter[])filter.toArray());
                for (DynamicObject temp : doc) {
                    selectTemplateIdSet.add(temp.getLong("template.id"));
                }
                if (params.getStageId() != 0L && selectTemplateIdSet.isEmpty()) {
                    return resultMap;
                }
                params.setTemplateIds(selectTemplateIdSet);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        Map<Long, Long> paramSource2Rights = TemplateUtil.getRightTplIdByVersioned(modelId, params.getYearId(), params.getPeriodId(), params.getTemplateIds());
        HashSet<String> numbers = new HashSet<String>(16);
        HashSet<Long> allTemplateIds = new HashSet<Long>(16);
        allTemplateIds.addAll(paramSource2Rights.values());
        if (params.getTemplateIds() != null) {
            allTemplateIds.addAll(params.getTemplateIds());
        }
        Set<Long> templateIds = TemplateUtil.getAllTemplates(params, numbers, allTemplateIds);
        boolean needCheckTplDisOrg = !params.isUnCheckTplDisOrg();
        Map<Object, Object> template2OrgMapOfDispense = new HashMap(16);
        if (needCheckTplDisOrg) {
            template2OrgMapOfDispense = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(modelId, new HashSet<Long>(templateIds), orgIds);
            for (Map.Entry<Object, Object> entry : template2OrgMapOfDispense.entrySet()) {
                if (!CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
                templateIds.remove(entry.getKey());
            }
        }
        TemplateUtil.fillReportStatusToResult(orgIds, currencyIds, params, resultMap, curMap, templateIds, numbers);
        if (CollectionUtils.isEmpty(templateIds)) {
            return resultMap;
        }
        Map<Long, Long> source2Right = TemplateUtil.getRightTplIdByVersioned(modelId, params.getYearId(), params.getPeriodId(), templateIds);
        HashSet<Long> allTemps = isNeedCheckPerm ? new HashSet<Long>(templateIds) : new HashSet(16);
        templateIds = new HashSet<Long>(source2Right.values());
        if (CollectionUtils.isNotEmpty(templateIds) && CollectionUtils.isNotEmpty(allTemps)) {
            allTemps.addAll(templateIds);
        }
        if (isNeedCheckPerm && !allTemps.isEmpty()) {
            ArrayList tids = Lists.newArrayList(allTemps);
            TemplatePermCrossUtil.filterNoPermTemplateByUserPermCross(tids, modelId, params.isQuery(), params.getUserId());
            if (CollectionUtils.isEmpty((Collection)tids)) {
                resultMap.forEach((k, v) -> v.clearAllTemplates());
                return resultMap;
            }
            tids.forEach(allTemps::remove);
            if (!allTemps.isEmpty()) {
                if (CollectionUtils.isNotEmpty(templateIds)) {
                    allTemps.forEach(templateIds::remove);
                }
                resultMap.forEach((k, v) -> v.filterTemplates(allTemps));
            }
        }
        if (CollectionUtils.isEmpty(templateIds)) {
            return resultMap;
        }
        TemplateUtil.filterTemplateToResult(resultMap, template2OrgMapOfDispense, params, templateIds, curMap);
        return resultMap;
    }

    public static QFilter getReportRecordQueryFilter(Map<Long, ReportEditStatus> resultMap) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> tmpIds = new HashSet<Long>(16);
        HashSet<Long> sceneIds = new HashSet<Long>(16);
        HashSet<Long> yearIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> cyIds = new HashSet<Long>(16);
        long modelId = 0L;
        for (Map.Entry<Long, ReportEditStatus> entry : resultMap.entrySet()) {
            orgIds.add(entry.getValue().getOrgId());
            tmpIds.addAll(entry.getValue().getAllTemplates());
            sceneIds.add(entry.getValue().getScenarioId());
            yearIds.add(entry.getValue().getYearId());
            periodIds.add(entry.getValue().getPeriodId());
            cyIds.add(entry.getValue().getCurrencyId());
            modelId = entry.getValue().getModelId();
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter orgFilter = new QFilter("entity", "in", orgIds);
        QFilter sceneFilter = new QFilter("scene", "in", sceneIds);
        QFilter fyearFilter = new QFilter("fyear", "in", yearIds);
        QFilter periodFilter = new QFilter("period", "in", periodIds);
        QFilter cyFilter = new QFilter("currency", "in", cyIds);
        QFilter tmpFilter = new QFilter("template", "in", tmpIds);
        return modelFilter.and(orgFilter).and(sceneFilter).and(fyearFilter).and(periodFilter).and(cyFilter).and(tmpFilter);
    }

    public static Set<Long> getReportRecordAllTempIds(Map<Long, ReportEditStatus> resultMap) {
        HashSet<Long> tmpIds = new HashSet<Long>(16);
        for (Map.Entry<Long, ReportEditStatus> entry : resultMap.entrySet()) {
            tmpIds.addAll(entry.getValue().getAllTemplates());
        }
        return tmpIds;
    }

    private static Set<Long> getAllTemplates(RightVersionTemplateParams params, Set<String> numbers, Set<Long> rightVerTempIds) {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        QFilter qFilter = TemplatePermCrossUtil.getCommonTemplateQfilter(params.isQuery(), params.getModelId(), false);
        if (CollectionUtils.isNotEmpty(rightVerTempIds)) {
            QFilter idQfilter = new QFilter("id", "in", rightVerTempIds);
            idQfilter.and("model", "=", (Object)params.getModelId());
            idQfilter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
            QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFilter[]{idQfilter}).forEach(arg_0 -> TemplateUtil.lambda$getAllTemplates$55(numbers, (Table)form2key2DTProps, arg_0));
            qFilter.and("id", "in", rightVerTempIds);
        }
        form2key2DTProps.clear();
        QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])qFilter.toArray()).forEach(arg_0 -> TemplateUtil.lambda$getAllTemplates$56((Table)form2key2DTProps, templateIds, arg_0));
        return templateIds;
    }

    private static Set<Long> filterOrgPerm(RightVersionTemplateParams params, Set<Long> orgIds) {
        Long dimensionId = MemberReader.getDimensionIdByNum((long)params.getModelId(), (String)DimTypesEnum.ENTITY.getNumber());
        return PermissionServiceImpl.getInstance(params.getModelId()).matchReadOrWritePermMembers(dimensionId, "bcm_entitymembertree", orgIds);
    }

    private static boolean isSpecialInnerRange(List<IDNumberTreeNode> nodes, String entity, TemplateModel model) {
        boolean flag = false;
        if (!nodes.isEmpty()) {
            flag = nodes.stream().anyMatch(c -> c != IDNumberTreeNode.NotFoundTreeNode && TemplateRangeService.isInnerRange(entity, model, c.getId()));
        }
        return flag;
    }

    private static void filterTemplateToResult(Map<Long, ReportEditStatus> resultMap, Map<Long, Set<Long>> template2OrgMapOfDispense, RightVersionTemplateParams params, Set<Long> templateIds, Map<Long, Long> curMap) {
        Long yearId = params.getYearId();
        Long scenarioId = params.getScenarioId();
        Long periodId = params.getPeriodId();
        String modelNum = MemberReader.findModelNumberById((Object)params.getModelId());
        IDNumberTreeNode treeNode = BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.CURRENCY.getNumber(), (long)params.getCurrencyId());
        boolean isVarMember = Lists.newArrayList((Object[])new String[]{"DC", "EC"}).contains(treeNode.getNumber());
        ArrayList templateModels = new ArrayList(templateIds.size());
        IDNumberTreeNode currentYearNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.YEAR.getNumber(), (String)"CurrentYear");
        IDNumberTreeNode lastYearNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.YEAR.getNumber(), (String)"LastYear");
        ArrayList years = Lists.newArrayList((Object[])new IDNumberTreeNode[]{currentYearNode, lastYearNode});
        IDNumberTreeNode currentPeriodNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.PERIOD.getNumber(), (String)"CurrentPeriod");
        IDNumberTreeNode lastPeriodNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.PERIOD.getNumber(), (String)"LastPeriod");
        ArrayList periods = Lists.newArrayList((Object[])new IDNumberTreeNode[]{currentPeriodNode, lastPeriodNode});
        TemplateUtil.batchGetTemplateModel(templateIds.stream().collect(Collectors.toList()), params.getModelId(), true).forEach(o -> {
            if (TemplateModel.TplStatus.DISABLE == o.getStatus()) {
                return;
            }
            if (!params.isQuery() && TemplateModel.UsageEnum.QUERY.getStatuValue().equals(o.getUsage())) {
                return;
            }
            boolean flag = false;
            if (o.isSaveByDim()) {
                if ((TemplateRangeService.isInnerRange("bcm_fymembertree", o, (Object)yearId, true) || TemplateUtil.isSpecialInnerRange(years, "bcm_fymembertree", o)) && TemplateRangeService.isInnerRange("bcm_scenemembertree", o, (Object)scenarioId, true) && (isVarMember || !isVarMember && TemplateRangeService.isInnerRange("bcm_currencymembertree", o, (Object)treeNode.getId(), true)) && (TemplateRangeService.isInnerRange("bcm_periodmembertree", o, (Object)periodId, true) || TemplateUtil.isSpecialInnerRange(periods, "bcm_periodmembertree", o))) {
                    flag = true;
                }
            } else {
                try {
                    if (TemplateRangeService.isInnerRange("bcm_scenemembertree", o, (Object)scenarioId, true)) {
                        flag = true;
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    flag = true;
                }
            }
            if (flag) {
                templateModels.add(o);
            }
        });
        templateModels.forEach(e -> {
            boolean flag = !e.isSaveByDim() || e.getFilterDimensionEntries().isEmpty() || !e.getFilterDimensionEntries().stream().anyMatch(fd -> DimTypesEnum.ENTITY.getNumber().equals(fd.getDimension().getNumber()));
            Set orgs = (Set)template2OrgMapOfDispense.get(e.getId());
            resultMap.forEach((k, v) -> {
                boolean isInnerRange = TemplateRangeService.isViewInnerRange("bcm_entitymembertree", e, k);
                if (!isInnerRange || v.getHasRecordTemNums().contains(e.getNumber())) {
                    return;
                }
                if (CollectionUtils.isNotEmpty((Collection)orgs) && orgs.contains(k) || params.isUnCheckTplDisOrg()) {
                    boolean isContinue;
                    boolean bl = isVarMember ? TemplateRangeService.isInnerRange("bcm_currencymembertree", e, (Object)treeNode.getId(), true) || curMap.get(k) != null && TemplateRangeService.isInnerRange("bcm_currencymembertree", e, curMap.get(k), true) : (isContinue = true);
                    if (isContinue && !flag) {
                        TemplateRangeService.RangeStatus status = new TemplateRangeService.RangeStatus();
                        TemplateRangeService.handleFilterDimRange(status, "bcm_entitymembertree", e, k, null);
                        TemplateRangeService.handleFilterPropRange(status, "bcm_entitymembertree", e, k, null);
                        isContinue = status.isInner();
                    }
                    if (isContinue) {
                        v.getUnweaveTemplates().add(e.getId());
                    }
                }
            });
        });
    }

    private static void fillReportStatusToResult(Set<Long> orgIdSet, Set<Long> currencyIds, RightVersionTemplateParams params, Map<Long, ReportEditStatus> result, Map<Long, Long> curMap, Set<Long> templateIds, Set<String> numbers) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,entity.id,entity.number,template.id,template.number,currency.id,reportstatus", (QFilter[])TemplateUtil.getQfilter(orgIdSet, currencyIds, params, numbers).toArray());
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(e -> {
                ReportEditStatus reportEditStatus;
                long orgId = e.getLong("entity.id");
                if ((currencyIds.size() == 1 || curMap.get(orgId) != null && e.getLong("currency.id") == ((Long)curMap.get(orgId)).longValue()) && (reportEditStatus = (ReportEditStatus)result.get(orgId)) != null) {
                    ReportStatusEnum statusEnum = ReportStatusEnum.getStatusEnumBy((String)e.getString("reportstatus"));
                    List<Long> ids = null;
                    if (ReportStatusEnum.WEAVING == statusEnum) {
                        ids = reportEditStatus.getWeavingTemplates();
                    } else if (ReportStatusEnum.COMPLETE == statusEnum) {
                        ids = reportEditStatus.getCompleteTemplates();
                    } else if (ReportStatusEnum.COMMIT == statusEnum) {
                        ids = reportEditStatus.getCommitTemplates();
                    } else if (ReportStatusEnum.BACK == statusEnum) {
                        ids = reportEditStatus.getBackTemplates();
                    } else if (ReportStatusEnum.BACKAPPLY == statusEnum) {
                        ids = reportEditStatus.getBackapplyTemplates();
                    }
                    long templateId = e.getLong("template.id");
                    if (ids != null) {
                        ids.add(templateId);
                        reportEditStatus.getHasRecordTemNums().add(e.getString("template.number"));
                    }
                    templateIds.add(templateId);
                }
            });
        }
    }

    private static QFilter getQfilter(Set<Long> orgIdSet, Set<Long> currencyIds, RightVersionTemplateParams params, Set<String> numbers) {
        QFilter qFilter = new QFilter("model", "=", (Object)params.getModelId());
        qFilter.and("fyear", "=", (Object)params.getYearId());
        qFilter.and("period", "=", (Object)params.getPeriodId());
        qFilter.and("scene", "=", (Object)params.getScenarioId());
        qFilter.and("entity", "in", orgIdSet);
        qFilter.and("currency", "in", currencyIds);
        qFilter.and(TemplateUtil.getReportTypeFilter());
        if (CollectionUtils.isNotEmpty(numbers)) {
            qFilter.and("template.number", "in", numbers);
        }
        return qFilter;
    }

    public static QFilter getReportTypeFilter() {
        return new QFilter("reporttype", "=", (Object)ReportType.NORMAL.index).or(new QFilter("reporttype", "=", (Object)""));
    }

    private static Set<Long> fillOrgAndCurrencyData(RightVersionTemplateParams params, Map<Long, Long> curMap, Set<Long> currencyIds, Map<Long, ReportEditStatus> result) {
        long modelId = params.getModelId();
        long currencyId = params.getCurrencyId();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode curTreeNode = BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.CURRENCY.getNumber(), (long)currencyId);
        boolean isDC = Lists.newArrayList((Object[])new String[]{"DC", "EC"}).contains(curTreeNode.getNumber());
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        if (!isDC) {
            currencyIds.add(currencyId);
        }
        MemberReader.getSomeNodeByDimNum((String)DimTypesEnum.ENTITY.getNumber(), (String)modelNum, params.getOrgIds().stream().collect(Collectors.toList())).forEach(e -> {
            long id = e.getId();
            String currency = e.getCurrency();
            if (e.isShare() && e.getCopyfromId() != null) {
                IDNumberTreeNode node;
                id = e.getCopyfromId();
                if (isDC && (node = BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (long)id)) != IDNumberTreeNode.NotFoundTreeNode) {
                    currency = node.getCurrency();
                }
            }
            long curId = curTreeNode.getId();
            if (isDC) {
                IDNumberTreeNode treeNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.CURRENCY.getNumber(), (String)currency);
                if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
                    curId = treeNode.getId();
                }
                curMap.put(id, curId);
                currencyIds.add(curId);
            }
            orgIdSet.add(id);
            result.put(id, new ReportEditStatus(modelId, id, params.getScenarioId(), params.getYearId(), params.getPeriodId(), curId));
        });
        return orgIdSet;
    }

    public static Map<Long, List<Long>> getRightVersionTemplateForOrgs(RightVersionTemplateParams params) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        TemplateUtil.getCommitReportCount(params).forEach((k, v) -> result.put((Long)k, v.getAllTemplates()));
        return result;
    }

    public static TemplateModel getTemplateModel(Object templateId) {
        String templateIdStr = templateId.toString();
        TemplateModel template = (TemplateModel)GlobalCacheServiceHelper.getImmutableTemplateModelOn((String)templateIdStr, () -> {
            String templateSerial = AppCacheServiceHelper.get(templateIdStr, String.class);
            DynamicObject templateDy = null;
            TemplateModel templateRef = null;
            if (kd.bos.util.StringUtils.isEmpty((String)templateSerial)) {
                templateDy = new TemplateDataProvider().query(templateId);
                templateRef = TemplateModel.genImmutableModel(templateDy);
                AppCacheServiceHelper.put(templateIdStr, ObjectSerialUtil.toByteSerialized((Object)templateRef));
            } else {
                templateRef = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
            }
            return templateRef;
        });
        return template;
    }

    public static OperationResult moveAdjustTemplate(long modelId, long sceneId, Set<Object> adjustIds, String newnodeId) {
        if (!MemberPermHelper.getLimitedModelListByUser().contains(modelId)) {
            Long newNodeId = LongUtil.toLong((Object)newnodeId);
            ArrayListMultimap<String, Long> permClassMap = PermClassEntityHelper.getPermissionMap("bcm_templatecatalog", String.valueOf(modelId), RequestContext.get().getUserId());
            if (permClassMap.get((Object)"1").contains(newNodeId) || permClassMap.get((Object)"2").contains(newNodeId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5206\u5f55\u5206\u7c7b\u53ea\u8bfb\u6216\u65e0\u6743\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff1b", (String)"TemplateUtil_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        OperationResult op = new OperationResult();
        op.setBillCount(adjustIds.size());
        AdjustmentServiceHelper.checkAdjustByValidator(modelId, new ArrayList<Object>(adjustIds), e1 -> {
            e1.setValidateResult(op);
            e1.getCtx().setScenarioId(sceneId);
            e1.addValidator(new AdjustSceneVersionValidator());
            e1.addValidator(new AdjustCheckPermValidator());
        });
        if (!op.getSuccessPkIds().isEmpty()) {
            DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format("update t_bcm_rptadjust set fcatalogid = %s where fid in (%s)", newnodeId, String.join((CharSequence)",", (CharSequence[])op.getSuccessPkIds().stream().map(Object::toString).distinct().toArray(String[]::new))));
            SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
        }
        return op;
    }

    public static boolean isNeedShowTemplate(TemplateModel tm, boolean isFromReportWeave, Map<Long, Long> group2Id) {
        if (isFromReportWeave && TemplateModel.UsageEnum.QUERY.getStatuValue().equals(tm.getUsage())) {
            return true;
        }
        if (TemplateModel.TplStatus.DISABLE == tm.getStatus()) {
            return true;
        }
        return group2Id.get(tm.getGroup()) == null;
    }

    public static List<String> getReportDataDimNums(long modelId) {
        ArrayList dimNums = Lists.newArrayList((Object[])new String[]{DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.MULTIGAAP.getNumber(), DimTypesEnum.DATATYPE.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.INTERCOMPANY.getNumber()});
        if (MemberReader.isExistAuditTrailDimension((String)MemberReader.findModelNumberById((Object)modelId))) {
            dimNums.add(DimTypesEnum.AUDITTRIAL.getNumber());
        }
        return dimNums;
    }

    public static List<Map<String, String>> getLegalSelectOrgs(long modelId, DimPropList dimPropList, String unCheckEntity, Set<String> unCheckEntityNums, Set<String> orgDimProps) {
        List list;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        if (kd.bos.util.StringUtils.isNotEmpty((String)unCheckEntity) && CollectionUtils.isNotEmpty((Collection)(list = (List)JSON.parseObject((String)unCheckEntity, List.class)))) {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            if (dimPropList == null) {
                Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)PresetConstant.ENTITY_DIM);
                dimPropList = DimPropList.getDimPropList((long)dimensionId);
            }
            Set propList = dimPropList.getPropList();
            for (Map k : list) {
                long memberId = Long.parseLong((String)k.get("oid"));
                long pId = kd.bos.util.StringUtils.isNotEmpty((String)((String)k.get("pid"))) ? Long.parseLong((String)k.get("pid")) : 0L;
                String memNum = (String)k.get("number");
                String name = "";
                boolean isBreak = true;
                if (pId != 0L) {
                    String[] split = memNum.split(":");
                    if (split.length == 2 && propList.contains(split[0])) {
                        String cusName = dimPropList.getFieldName(split[0]);
                        IDNumberTreeNode node = TemplateUtil.getCustomPropertyValueByNumber(PresetConstant.ENTITY_DIM, split[1], modelNum);
                        if (kd.bos.util.StringUtils.isNotEmpty((String)cusName) && node != IDNumberTreeNode.NotFoundTreeNode) {
                            name = cusName + ":" + node.getName();
                            isBreak = false;
                        }
                    }
                    if (isBreak) {
                        orgDimProps.add(memNum);
                    } else {
                        k.put("rangevalue", "10");
                    }
                } else {
                    IDNumberTreeNode node = BcmThreadCache.findNodeById((String)modelNum, (String)PresetConstant.ENTITY_DIM, (long)memberId);
                    if (node == IDNumberTreeNode.NotFoundTreeNode) {
                        node = BcmThreadCache.findMemberByNum((String)modelNum, (String)PresetConstant.ENTITY_DIM, (String)memNum);
                        if (node != IDNumberTreeNode.NotFoundTreeNode) {
                            name = node.getName();
                            isBreak = false;
                        } else {
                            unCheckEntityNums.add(memNum);
                        }
                    } else {
                        name = node.getName();
                        isBreak = false;
                    }
                }
                if (isBreak) continue;
                k.put("entity", name);
                result.add(k);
            }
        }
        return result;
    }

    public static IDNumberTreeNode getCustomPropertyValueByNumber(String dimNum, String memNum, String modelNum) {
        return (IDNumberTreeNode)ThreadCache.get((Object)String.format("%s|%s|%s|%s", "CustomPropertyValue", modelNum, dimNum, memNum), () -> {
            Map nodeMap = (Map)MemberReader.getAllNodeByNumberFromCache((String)"bcm_definedpropertyvalue", (String)modelNum).get(dimNum);
            if (nodeMap == null) {
                return IDNumberTreeNode.NotFoundTreeNode;
            }
            if (nodeMap.containsKey(memNum)) {
                return (IDNumberTreeNode)nodeMap.get(memNum);
            }
            return IDNumberTreeNode.NotFoundTreeNode;
        });
    }

    public static void checkCM018Data(long modelId, long configId, String number) {
        if (ConfigEnum.CM018.getNumber().equals(number)) {
            DynamicObject configDyo = BusinessDataServiceHelper.loadSingle((Object)configId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ConfigEnum.CM018.getForm()));
            ArrayList<DynamicObject> saveDyos = new ArrayList<DynamicObject>(16);
            if (configDyo != null) {
                DynamicObjectCollection objects = configDyo.getDynamicObjectCollection("dentity");
                if (CollectionUtils.isEmpty((Collection)objects)) {
                    return;
                }
                DimPropList dimPropList = null;
                String modelNum = MemberReader.findModelNumberById((Object)modelId);
                for (int i = 0; i < objects.size(); ++i) {
                    DynamicObject object = (DynamicObject)objects.get(i);
                    long id = LongUtil.toLong((Object)object.get("oid"));
                    String memNum = object.getString("num");
                    String[] split = memNum.split(":");
                    boolean isBreak = true;
                    if (split.length == 2) {
                        Set propList;
                        if (dimPropList == null) {
                            Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)PresetConstant.ENTITY_DIM);
                            dimPropList = DimPropList.getDimPropList((long)dimensionId);
                        }
                        if ((propList = dimPropList.getPropList()).contains(split[0])) {
                            String cusName = dimPropList.getFieldName(split[0]);
                            IDNumberTreeNode node = TemplateUtil.getCustomPropertyValueByNumber(DimTypesEnum.ENTITY.getNumber(), split[1], modelNum);
                            if (StringUtils.isNotEmpty((CharSequence)cusName) && node != IDNumberTreeNode.NotFoundTreeNode) {
                                isBreak = false;
                                object.set("rangevalue", (Object)"10");
                                object.set("entity", (Object)(cusName + ":" + node.getName()));
                            }
                        }
                    } else {
                        IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)id);
                        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
                            isBreak = false;
                            object.set("entity", (Object)treeNode.getName());
                        }
                    }
                    if (isBreak) continue;
                    saveDyos.add(object);
                }
                configDyo.getDynamicObjectCollection("dentity").clear();
                if (CollectionUtils.isNotEmpty(saveDyos)) {
                    configDyo.set("dentity", saveDyos);
                }
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{configDyo}, (OperateOption)op);
            }
        }
    }

    public static String getMemberNumber(IDimMember member) {
        String dimNumber = member.getDimension().getNumber();
        if (DimTypesEnum.ENTITY.getNumber().equals(dimNumber) && member.getPar_SonNum() != null) {
            return member.getPar_SonNum();
        }
        return member.getNumber();
    }

    private static /* synthetic */ void lambda$getAllTemplates$56(Table form2key2DTProps, Set templateIds, DynamicObject e) {
        long id = e.getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "id", e));
        templateIds.add(id);
    }

    private static /* synthetic */ void lambda$getAllTemplates$55(Set numbers, Table form2key2DTProps, DynamicObject e) {
        numbers.add(e.getString(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "number", e)));
    }

    private static /* synthetic */ void lambda$getRightTplIdByVBatchPeriod$22(Table source2Right, DynamicObject periodDo, Long modelId, Date firstDate, Date lastDate, Map group2SourceId, Long group, List tpls) {
        for (DynamicObject t : tpls) {
            Long id = t.getLong("id");
            Date effectivedate = t.getDate("effectivedate");
            if (effectivedate == null) {
                source2Right.put((Object)periodDo.getLong("id"), (Object)id, (Object)id);
                continue;
            }
            if (!TemplateStartPeriodUtil.isRangeForStartPeriod(modelId, firstDate, lastDate, t, periodDo, null)) continue;
            source2Right.put((Object)periodDo.getLong("id"), group2SourceId.get(group), (Object)t.getLong("id"));
        }
    }

    private static /* synthetic */ void lambda$getRightTplIdByVersioned$19(Table form2key2DTProps, Map source2Right, Long modelId, Date firstDate, Date lastDate, DynamicObject periodDo, Map group2SourceId, Long group, List tpls) {
        for (DynamicObject t : tpls) {
            Long id = t.getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "id", t));
            Date effectivedate = t.getDate(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "effectivedate", t));
            if (effectivedate == null) {
                source2Right.put(id, id);
                continue;
            }
            if (!TemplateStartPeriodUtil.isRangeForStartPeriod(modelId, firstDate, lastDate, t, periodDo, null)) continue;
            source2Right.put(group2SourceId.get(group), t.getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "id", t)));
        }
    }

    private static /* synthetic */ Long lambda$getRightTplIdByVersioned$18(Table form2key2DTProps, DynamicObject e) {
        return e.getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "group", e));
    }

    private static /* synthetic */ void lambda$getRightTplIdByVersioned$17(Map group2SourceId, Table form2key2DTProps, DynamicObject t) {
        group2SourceId.put(t.getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "group", t)), t.getLong("id"));
    }

    private static /* synthetic */ void lambda$getExistReportIds$16(Table form2key2DTProps, Map number2Id, Set existReport, DynamicObject rpt) {
        String number = rpt.getString(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_reportentity", "template.number", rpt));
        Long id = (Long)number2Id.get(number);
        if (id != null) {
            existReport.add(rpt.getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_reportentity", "template", rpt)));
            number2Id.remove(id);
        }
    }

    private static /* synthetic */ boolean lambda$filterVersionTemplateTree$11(Set passes, Table form2key2DTProps, DynamicObject t) {
        return !passes.contains(t.getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "id", t)));
    }

    private static /* synthetic */ void lambda$filterVersionTemplateTree$10(Set passes, final Table form2key2DTProps, String number, List tmpList) {
        if (tmpList.size() == 1) {
            passes.add(((DynamicObject)tmpList.get(0)).getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "id", (DynamicObject)tmpList.get(0))));
        } else {
            tmpList.sort(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return -1 * o1.getBigDecimal(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "versionnumber", o1)).compareTo(o2.getBigDecimal(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "versionnumber", o2)));
                }
            });
            passes.add(((DynamicObject)tmpList.get(0)).getLong(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "id", (DynamicObject)tmpList.get(0))));
        }
    }

    private static /* synthetic */ String lambda$filterVersionTemplateTree$9(Table form2key2DTProps, DynamicObject e) {
        return e.getString(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, "bcm_templateentity", "number", e));
    }

    static interface IDataProvider {
        public DynamicObject query(Object var1);

        default public DynamicObject toPlainQuery(String entityName, String selectFields, QFilter[] filters) {
            return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
        }

        default public DynamicObject queryModel(String entityName, Object pk) {
            return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
        }
    }

    static class ReportDataProvider
    implements IDataProvider {
        ReportDataProvider() {
        }

        @Override
        public DynamicObject query(Object pk) {
            return this.toPlainQuery("bcm_reportentity", "spreadjson,data", new QFilter[]{new QFilter("id", "=", (Object)ConvertUtil.convertObjToLong(pk))});
        }
    }

    static class TemplateDataProvider
    implements IDataProvider {
        TemplateDataProvider() {
        }

        @Override
        public DynamicObject query(Object pk) {
            return this.queryModel("bcm_templateentity", pk);
        }
    }
}

