/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class TemplateUtils {
    public static long getTemplateFirstVersionId(Long templateId) {
        return (Long)ThreadCache.get((Object)("getTemplateFirstVersionId" + templateId), () -> {
            DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"number,group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
            if (template == null) {
                throw new KDBizException(String.format("template id = %s not exist", templateId));
            }
            List templateArray = QueryServiceHelper.queryPrimaryKeys((String)"bcm_templateentity", (QFilter[])new QFBuilder("group", "=", (Object)template.getLong("group")).toArray(), (String)"sequence,versionnumber asc", (int)1);
            if (templateArray != null && templateArray.size() > 0) {
                return (Long)templateArray.get(0);
            }
            throw new KDBizException(String.format("template number %s not min version", template.getString("number")));
        });
    }

    public static Collection<Long> getAllVersionTemplateIds(Collection<Long> templateIds) {
        HashSet result = Sets.newHashSet();
        try (DataSet dateSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.util.TemplateUtils.getTemplateIds(Collection<Long>).one", (String)"bcm_templateentity", (String)"group", (QFilter[])new QFilter("id", "in", templateIds).toArray(), null);){
            TemplateUtils.propertyValue2Collection(dateSet, result, "group");
            try (DataSet allDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.util.TemplateUtils.getTemplateIds(Collection<Long>).two", (String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter("group", "in", (Object)result).toArray(), null);){
                result.clear();
                TemplateUtils.propertyValue2Collection(allDataSet, result, "id");
            }
        }
        return result;
    }

    private static void propertyValue2Collection(DataSet dateSet, Set<Long> groupIds, String property) {
        dateSet.forEach(row -> groupIds.add(row.getLong(property)));
    }

    public static Map<Long, Long> getRightTplIdByVersioned(Long modelId, Long yearId, Long periodId, Set<Long> templateIds) {
        return TemplateUtil.getRightTplIdByVersioned(modelId, yearId, periodId, templateIds);
    }
}

