/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;

public class ThirdPartyDataCenterUtil {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ThirdPartyDataCenterUtil.class);
    private static final int HTTP_CONN_TIMEOUT = 3000;
    private static final int HTTP_READ_TIMEOUT = 10000;
    private static volatile String APP_SECU = null;
    private static final String DATA_PWD = "DataPwd_";

    public static boolean getAppToken(String targetDomainContextUrl, String accountId, String appId, String securet) {
        HashMap<String, String> requestBody = new HashMap<String, String>(6);
        requestBody.put("appId", appId);
        requestBody.put("appSecuret", securet);
        requestBody.put("accountId", accountId);
        requestBody.put("language", "zh_CN");
        HashMap restHeader = new HashMap(8);
        String response = "";
        try {
            response = HttpClientUtils.postjson((String)(targetDomainContextUrl + "/api/getAppToken.do"), restHeader, (String)JacksonUtils.toJson(requestBody), (int)3000, (int)10000);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        Map responseBody = (Map)JacksonUtils.fromJson((String)response, Map.class);
        if ("success".equals(responseBody.get("state"))) {
            return true;
        }
        LOG.info(responseBody.get("errorMsg").toString());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getThirdAppPassword() {
        if (!Objects.isNull(APP_SECU)) return APP_SECU;
        Class<ThirdPartyDataCenterUtil> clazz = ThirdPartyDataCenterUtil.class;
        synchronized (ThirdPartyDataCenterUtil.class) {
            if (!Objects.isNull(APP_SECU)) return APP_SECU;
            Properties p = new Properties();
            try (InputStream in = OlapServiceHelper.class.getClassLoader().getResourceAsStream("bcm/cm.properties");){
                p.load(in);
                APP_SECU = "V0ahHDEEDE" + p.getProperty("lynt_cyru");
            }
            catch (IOException e) {
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return APP_SECU;
        }
    }

    public static String encrypterPwd(String password) {
        if (password.startsWith(DATA_PWD)) {
            return password;
        }
        return DATA_PWD + EncryptUtils.aesEncrypt((String)password);
    }

    public static String decrypterPwd(String password) {
        if (password.startsWith(DATA_PWD)) {
            password = password.substring(8);
            return EncryptUtils.aesDecrypt((String)password);
        }
        return password;
    }

    public static String checkSysPerm(String appId, String permItem) {
        boolean hasPermission = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bcm_tdp_datacenter", (String)permItem);
        if (!hasPermission) {
            return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6388\u6743\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ThirdPartyDataCenterPlugin_0", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return "";
    }
}

