/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.util.CurrencyTool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import org.apache.commons.collections.CollectionUtils;

public class TransMemberUtil {
    private static final List<String> pcProList = Collections.unmodifiableList(Arrays.asList("CCTotal", "CCADJ", "CC", "EJE", "PRPT", "CADJ", "ARPT", "ADJ", "Rpt", "IRpt", "RAdj", "TARPT", "TADJ", "TRpt", "EIT", "ECF", "EICA", "EOE", "EOther"));
    private static final List<String> p_CList = Collections.unmodifiableList(Arrays.asList("CCTotal", "CCADJ", "CC", "EJE", "PRPT", "CADJ", "ARPT", "ADJ", "TARPT", "TADJ", "TRpt", "EIT", "ECF", "EICA", "EOE", "EOther"));
    private static final List<String> EProcess = Arrays.asList("ERpt", "EIRpt", "ERAdj");
    public static final List<String> NEProcess = Arrays.asList("Rpt", "IRpt", "RAdj");

    @SDKMark
    public static Pair<String, String> transOrgAndCurbyOrgId(long modelId, long orgId, String bpNum, String curNum, long fyearId, long periodId) {
        IDNumberTreeNode numberTreeNode = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)DimTypesEnum.ENTITY.getNumber(), (long)orgId);
        return TransMemberUtil.getTransOrgAndCurbyOrgId(numberTreeNode, modelId, bpNum, curNum);
    }

    public static Pair<String, String> transOrgAndCurbyOrgId(String modelNum, long orgId, String bpNum, String curNum, long fyearId, long periodId) {
        IDNumberTreeNode numberTreeNode = BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (long)orgId);
        long modelId = numberTreeNode.getModelId();
        return TransMemberUtil.getTransOrgAndCurbyOrgId(numberTreeNode, modelId, bpNum, curNum);
    }

    public static Pair<String, String> getTransOrgAndCurbyOrgId(IDNumberTreeNode numberTreeNode, long modelId, String bpNum, String curNum) {
        String tagCurNum = null;
        String tagOrgNum = null;
        String orgNumber = numberTreeNode.getNumber();
        if (numberTreeNode.getParent() == null) {
            tagCurNum = CurrencyTool.isTransCurrency(curNum) ? numberTreeNode.getCurrency() : curNum;
            tagOrgNum = orgNumber;
        } else if ("Entity".equals(numberTreeNode.getParent().getNumber())) {
            tagCurNum = "DC".equals(curNum) || "EC".equals(curNum) || "PC".equals(curNum) ? numberTreeNode.getCurrency() : curNum;
            tagOrgNum = TransMemberUtil.getOrgNumber(bpNum, numberTreeNode, modelId);
        } else if ("DC".equals(curNum)) {
            if (pcProList.contains(bpNum)) {
                tagCurNum = numberTreeNode.getParent().getCurrency();
                tagOrgNum = TransMemberUtil.getOrgNumber(bpNum, numberTreeNode, modelId);
            } else {
                tagCurNum = numberTreeNode.getCurrency();
                tagOrgNum = orgNumber;
            }
        } else if ("EC".equals(curNum)) {
            tagCurNum = numberTreeNode.getCurrency();
            tagOrgNum = TransMemberUtil.getOrgNumber(bpNum, numberTreeNode, modelId);
        } else if ("PC".equals(curNum)) {
            tagCurNum = numberTreeNode.getParent().getCurrency();
            tagOrgNum = TransMemberUtil.getOrgNumber(bpNum, numberTreeNode, modelId);
        } else {
            tagCurNum = curNum;
            tagOrgNum = TransMemberUtil.getOrgNumber(bpNum, numberTreeNode, modelId);
        }
        return new Pair((Object)tagOrgNum, (Object)tagCurNum);
    }

    public static String getOrgNumber(String bpNum, IDNumberTreeNode numberTreeNode, long modelId) {
        String tagOrgNum = null;
        String orgNumber = numberTreeNode.getNumber();
        if (!p_CList.contains(bpNum)) {
            tagOrgNum = orgNumber;
        } else {
            OrgRelaMembSupplier supplier = new OrgRelaMembSupplier(numberTreeNode.getId(), orgNumber, modelId);
            tagOrgNum = supplier.access(orgNumber);
        }
        return tagOrgNum;
    }

    public static Table<Long, String, String> getCurrencyTableByOrgIdAndProNum(Set<Long> orgIdSet, Set<String> proNumSet, String modelnumber) {
        HashBasedTable orgProCurrencyTable = HashBasedTable.create();
        if (CollectionUtils.isNotEmpty(proNumSet)) {
            Map<Long, String> orgECCurrencyMap = TransMemberUtil.getOrgECCurrencyByOrgId(orgIdSet, modelnumber);
            Map<Long, String> orgPCCurrencyMap = TransMemberUtil.getOrgPCCurrencyByOrgId(orgIdSet, modelnumber);
            for (String proNum : proNumSet) {
                Long orgId;
                if (TransMemberUtil.isPCByProcess(proNum)) {
                    for (Map.Entry<Long, String> entry : orgPCCurrencyMap.entrySet()) {
                        orgId = entry.getKey();
                        if (orgPCCurrencyMap.get(orgId) == null) continue;
                        orgProCurrencyTable.put((Object)orgId, (Object)proNum, (Object)entry.getValue());
                    }
                    continue;
                }
                for (Map.Entry<Long, String> entry : orgECCurrencyMap.entrySet()) {
                    orgId = entry.getKey();
                    String value = entry.getValue();
                    if (value == null) continue;
                    orgProCurrencyTable.put((Object)orgId, (Object)proNum, (Object)value);
                }
            }
        }
        return orgProCurrencyTable;
    }

    public static Map<Long, String> getOrgECCurrencyByOrgId(Set<Long> orgIdSet, String modelnumber) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        if (CollectionUtils.isNotEmpty(orgIdSet)) {
            for (Long orgId : orgIdSet) {
                IDNumberTreeNode numberTreeNode = BcmThreadCache.findNodeById((String)modelnumber, (String)DimTypesEnum.ENTITY.getNumber(), (long)orgId);
                result.put(numberTreeNode.getId(), numberTreeNode.getCurrency());
            }
        }
        return result;
    }

    public static Map<Long, String> getOrgPCCurrencyByOrgId(Set<Long> orgIdSet, String modelnumber) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        if (CollectionUtils.isNotEmpty(orgIdSet)) {
            for (Long orgId : orgIdSet) {
                IDNumberTreeNode numberTreeNode = BcmThreadCache.findNodeById((String)modelnumber, (String)DimTypesEnum.ENTITY.getNumber(), (long)orgId);
                IDNumberTreeNode parent = numberTreeNode.getParent();
                if (parent != null) {
                    result.put(numberTreeNode.getId(), parent.getCurrency());
                    continue;
                }
                result.put(numberTreeNode.getId(), numberTreeNode.getCurrency());
            }
        }
        return result;
    }

    public static boolean isPCByProcess(String proNum) {
        if (StringUtils.isNotEmpty((String)proNum)) {
            return pcProList.contains(proNum);
        }
        return false;
    }

    public static boolean isSpecialEntity(String proNum) {
        if (StringUtils.isNotEmpty((String)proNum)) {
            return p_CList.contains(proNum);
        }
        return false;
    }

    public static String toNEProcess(String number) {
        if (EProcess.contains(number)) {
            return NEProcess.get(EProcess.indexOf(number));
        }
        return number;
    }

    public static void toNEProcess(Set<String> numbers) {
        if (CollectionUtils.isNotEmpty(numbers)) {
            for (String e : EProcess) {
                if (!numbers.remove(e)) continue;
                numbers.add(NEProcess.get(EProcess.indexOf(e)));
            }
        }
    }
}

