/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class UpgradeStatusUtil {
    public static List<String> WHITE_LIST = Lists.newArrayList((Object[])new String[]{"bcm_apphome", "bcm_upgrademanage", "bcm_card_myvalue", "bcm_upgradelog", "bcm_singlemember_rate", "epbs_datasource", "bcm_modelperm", "bcm_modelolap_recordpage", "bcm_modelcopyandtransfer", "bcm_model_upload", "bcm_query_mainpage", "bcm_query_result"});

    public static Boolean isModelUpgraded(long modelId) {
        return MemberReader.getAllNodeFromCache((String)"bcm_currencymembertree", (Object)modelId).values().stream().anyMatch(x -> CurrencyEnum.DC.getNumber().equals(x.getNumber()));
    }

    public static Set<Object> getUpgradesModelIds() {
        return (Set)GlobalCacheServiceHelper.getCommonCache().getOrLoad("getUpgradesModelIds", () -> {
            QFBuilder qb = new QFBuilder("number", "=", (Object)CurrencyEnum.DC.getNumber());
            DynamicObjectCollection records = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id,number,model", (QFilter[])qb.toArray());
            return DynamicObjectCollectionUtil.getFieldSet(records, "model");
        });
    }

    public static Set<Long> getUnUpgradeModels() {
        return (Set)GlobalCacheServiceHelper.getCommonCache().getOrLoad("getUnUpgradeModels", () -> {
            DynamicObjectCollection records = QueryServiceHelper.query((String)"bcm_model", (String)"id", (QFilter[])new QFilter("id", "not in", UpgradeStatusUtil.getUpgradesModelIds()).toArray());
            return records.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        });
    }

    public static boolean isInWhiteList(FormShowParameter fs) {
        String formId = fs.getFormId();
        if ("bos_list".equals(formId)) {
            formId = fs instanceof ListShowParameter ? ((ListShowParameter)fs).getBillFormId() : (String)fs.getCustomParam("billFormId");
        }
        if (StringUtils.isNotEmpty((CharSequence)formId) && formId.startsWith("bcm")) {
            return WHITE_LIST.contains(formId);
        }
        return true;
    }
}

