/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class UpgradeUtil {
    private static final String MODELCONSTANT = "model";
    private static final String BCM_UPGRADE_DYNCALCINFO = "bcm_upgrade_dyncalcinfo";
    private static final String EXCEPERIOD = "exceperiod";
    private static final String ENABLEYEAR = "enableyear";
    private static final String DATA = "data";

    private UpgradeUtil() {
    }

    public static boolean existPeriodInfo(Long modelId, String currentYear) {
        QFilter modelFilter = new QFilter(MODELCONSTANT, "=", (Object)modelId);
        QFilter yearFilter = new QFilter(ENABLEYEAR, "=", (Object)currentYear);
        QFilter[] filters = new QFilter[]{modelFilter, yearFilter};
        return UpgradeUtil.doPeriodInfoExistQuery(filters);
    }

    public static boolean existPeriodInfoForModel(Long modelId) {
        QFilter modelFilter = new QFilter(MODELCONSTANT, "=", (Object)modelId);
        DynamicObjectCollection FYCollection = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"number", (QFilter[])new QFilter[]{modelFilter});
        List FYList = FYCollection.stream().map(x -> x.getString("number")).collect(Collectors.toList());
        QFilter yearFilter = new QFilter(ENABLEYEAR, "in", FYList);
        QFilter[] filters = new QFilter[]{modelFilter, yearFilter};
        return UpgradeUtil.doPeriodInfoExistQuery(filters);
    }

    private static boolean doPeriodInfoExistQuery(QFilter[] filters) {
        Boolean dynamicCalcInfoExist = QueryServiceHelper.exists((String)BCM_UPGRADE_DYNCALCINFO, (QFilter[])filters);
        if (dynamicCalcInfoExist.booleanValue()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)BCM_UPGRADE_DYNCALCINFO, (String)"exceperiod,data", (QFilter[])filters);
            String expPeriod = (String)dynamicObject.get(EXCEPERIOD);
            String expPeriodData = (String)dynamicObject.get(DATA);
            if (StringUtils.isNotEmpty((String)expPeriodData)) {
                return true;
            }
            if (StringUtils.isNotEmpty((String)expPeriod)) {
                return true;
            }
        }
        return false;
    }

    public static String placeHolder(int size) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (int i = 0; i < size; ++i) {
            stringJoiner.add("?");
        }
        return stringJoiner.toString();
    }
}

