/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class UpgradeWorkPaperTemplateUtil {
    public static void upgradeWpTemplate(Long modelId) {
        UpgradeWorkPaperTemplateUtil.updateTemplateCatalogId(modelId, UpgradeWorkPaperTemplateUtil.addMergeWP(modelId));
    }

    public static Long addMergeWP(Long modelId) {
        QFBuilder filter = UpgradeWorkPaperTemplateUtil.createFilter(modelId, "bcm_templatecatalog");
        DynamicObject single = BusinessDataServiceHelper.loadSingle((String)"bcm_templatecatalog", (String)"id", (QFilter[])filter.toArray());
        if (single == null) {
            single = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templatecatalog");
            long rootId = QueryServiceHelper.queryOne((String)"bcm_templatecatalog", (String)"id", (QFilter[])UpgradeWorkPaperTemplateUtil.createFilter(modelId, "").toArray()).getLong("id");
            Date now = TimeServiceHelper.now();
            single.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            single.set("createtime", (Object)now);
            single.set("modifytime", (Object)now);
            single.set("level", (Object)TemplateCatalogEnum.MERGE_WP.getLevel());
            single.set("enable", (Object)"1");
            single.set("status", (Object)"C");
            single.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            single.set("model", (Object)modelId);
            single.set("isleaf", (Object)TemplateCatalogEnum.MERGE_WP.isIsleaf());
            single.set("longnumber", (Object)TemplateCatalogEnum.MERGE_WP.getLongnumber());
            single.set("masterid", (Object)0);
            single.set("catalogtype", (Object)Character.valueOf(TemplateCatalogEnum.MERGE_WP.getType()));
            single.set("parent", (Object)rootId);
            single.set("number", (Object)TemplateCatalogEnum.MERGE_WP.getNumber());
            single.set("name", LanguageUtil.getValue(TemplateCatalogEnum.MERGE_WP.getName(), "TemplateCatalogEnum_" + TemplateCatalogEnum.MERGE_WP.getNumber(), "fi-bcm-business"));
            single.set("sequence", (Object)TemplateCatalogEnum.MERGE_WP.getSeq());
            single.set("instruction", (Object)"");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{single});
        }
        return single.getLong("id");
    }

    public static void updateTemplateCatalogId(Long modelId, long id) {
        try (TXHandle tx = TX.required((String)"bcm_template_save");){
            try {
                String sql = "update T_BCM_Template SET ftemplatecatalogid=? WHERE ftemplatetype=? And fmodelid=?";
                DB.update((DBRoute)BCMConstant.DBROUTE, (String)sql, (Object[])new Object[]{id, TemplateTypeEnum.MSN.getType() + "", modelId});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static QFBuilder createFilter(Long modelId, String entity) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        switch (entity) {
            case "bcm_templatecatalog": {
                qfBuilder.add("number", "=", (Object)TemplateCatalogEnum.MERGE_WP.getNumber());
                break;
            }
            case "bcm_templateentity": {
                qfBuilder.add("templatetype", "=", (Object)Character.valueOf(TemplateCatalogEnum.MERGE_WP.getType()));
                break;
            }
            default: {
                qfBuilder.add("number", "=", (Object)TemplateCatalogEnum.ROOT.getNumber());
            }
        }
        return qfBuilder;
    }
}

